/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.config.BaseCustomObject;
import com.ibm.ws.st.ui.internal.config.ConfigVarComputer;
import com.ibm.ws.st.ui.internal.config.TextModifiers;
import com.ibm.xwt.dde.customization.IAdvancedCustomizationObject;
import java.util.EventListener;
import java.util.HashMap;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.osgi.framework.Bundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LocationTextCustomObject
extends BaseCustomObject {
    protected static final HashMap<String, String> dialogHash = new HashMap();
    protected static final HashMap<String, LocationType> dialogType = new HashMap();

    protected LocationType getLocationType() {
        return LocationType.ALL;
    }

    protected String getClassName() {
        return "com.ibm.ws.st.ui.internal.config.GenericLocationBrowser";
    }

    public void createCustomControl(final Element input, final String itemName, final Composite composite, final IEditorPart editorPart, EventListener listener) {
        Class<?> dialogClass;
        boolean isIncludeLocation = "include".equals(input.getNodeName()) && "location".equals(itemName);
        ConfigVarComputer configVarComputer = this.getConfigVarComputer(isIncludeLocation ? null : input, isIncludeLocation ? null : itemName, editorPart);
        String attrType = null;
        String defaultValue = null;
        CMAttributeDeclaration attrDecl = this.getAttrDecl(input, itemName);
        if (attrDecl != null) {
            attrType = ConfigUtils.getTypeName((CMNode)attrDecl);
            defaultValue = attrDecl.getDefaultValue();
        }
        Attr attr = input.getAttributeNode(itemName);
        String value = defaultValue;
        if (attr != null) {
            value = attr.getNodeValue();
        }
        TabbedPropertySheetWidgetFactory widgetFactory = new TabbedPropertySheetWidgetFactory();
        this.setLabelVerticalAlign(composite, 2);
        final Text textControl = widgetFactory.createText(composite, "");
        if (value != null && !value.isEmpty()) {
            textControl.setText(value);
            textControl.setToolTipText(value);
        }
        TextModifiers.addVariableContentProposalProvider(textControl, configVarComputer, attrType);
        TextModifiers.addVariableHyperlink(textControl, configVarComputer);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.horizontalIndent = 2;
        textControl.setLayoutData((Object)data);
        textControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String text = textControl.getText();
                Attr attr = input.getAttributeNode(itemName);
                if (text == null || text.isEmpty()) {
                    if (attr != null) {
                        input.removeAttributeNode(attr);
                    }
                } else {
                    input.setAttribute(itemName, text);
                }
                textControl.setToolTipText(text);
            }
        });
        String className = dialogHash.get(input.getNodeName());
        if (className == null) {
            className = this.getClassName();
        }
        if ((dialogClass = this.getDialogClass(className)) == null) {
            this.fixTextSpan(textControl, 2);
            return;
        }
        LocationType type = dialogType.get(input.getNodeName());
        if (type == null) {
            type = this.getLocationType();
        }
        final LocationType locationType = type;
        final Composite buttonComposite = widgetFactory.createComposite(composite);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = false;
        buttonComposite.setLayoutData((Object)data);
        final Button browseButton = widgetFactory.createButton(buttonComposite, Messages.editorBrowse, 8);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = false;
        browseButton.setLayoutData((Object)data);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String result = LocationTextCustomObject.this.openDialog(dialogClass, input, itemName, editorPart, textControl.getText());
                if (result != null && !result.isEmpty()) {
                    textControl.setText(result);
                }
            }
        });
        Button dropdownButton = widgetFactory.createButton(buttonComposite, "", 8);
        this.setDropdownData((Control)browseButton, dropdownButton);
        dropdownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Menu menu = new Menu((Decorations)composite.getShell(), 8);
                MenuItem item = new MenuItem(menu, 8);
                item.setText(Messages.relPathButton);
                item.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        String result = LocationTextCustomObject.this.openDialog(dialogClass, input, itemName, editorPart, textControl.getText());
                        if (result != null) {
                            textControl.setText(result);
                        }
                    }
                });
                menu.setDefaultItem(item);
                if (locationType == LocationType.ALL) {
                    item = new MenuItem(menu, 8);
                    item.setText(Messages.absFilePathButton);
                    item.addListener(13, new Listener(){

                        public void handleEvent(Event e) {
                            FileDialog fileDialog = new FileDialog(buttonComposite.getShell());
                            String path = fileDialog.open();
                            if (path != null && !path.isEmpty()) {
                                textControl.setText(path);
                            }
                        }
                    });
                    item = new MenuItem(menu, 8);
                    item.setText(Messages.absFolderPathButton);
                    item.addListener(13, new Listener(){

                        public void handleEvent(Event e) {
                            DirectoryDialog dirDialog = new DirectoryDialog(buttonComposite.getShell());
                            dirDialog.setMessage(Messages.absFolderPathMessage);
                            String path = dirDialog.open();
                            if (path != null && !path.isEmpty()) {
                                textControl.setText(path);
                            }
                        }
                    });
                } else {
                    item = new MenuItem(menu, 8);
                    item.setText(Messages.absPathButton);
                    item.addListener(13, new Listener(){

                        public void handleEvent(Event e) {
                            String path = null;
                            switch (locationType) {
                                case FILE: {
                                    FileDialog fileDialog = new FileDialog(buttonComposite.getShell());
                                    path = fileDialog.open();
                                    break;
                                }
                                case FOLDER: {
                                    DirectoryDialog dirDialog = new DirectoryDialog(buttonComposite.getShell());
                                    dirDialog.setMessage(Messages.absFolderPathMessage);
                                    path = dirDialog.open();
                                    break;
                                }
                                default: {
                                    if (!Trace.ENABLED) break;
                                    Trace.trace((byte)1, "Encountered unexpected location type when creating drop down menu for location text: " + (Object)((Object)locationType));
                                }
                            }
                            if (path != null && !path.isEmpty()) {
                                textControl.setText(path);
                            }
                        }
                    });
                }
                LocationTextCustomObject.this.displayDropdownMenu((Control)browseButton, menu, false);
                menu.dispose();
            }
        });
        textControl.setEnabled(!this.getReadOnly());
        browseButton.setEnabled(!this.getReadOnly());
        dropdownButton.setEnabled(!this.getReadOnly());
    }

    protected void fixTextSpan(Text textControl, int span) {
        GridData data = (GridData)textControl.getLayoutData();
        data.horizontalSpan = span;
    }

    protected Class<?> getDialogClass(String className) {
        Class dialogClass = null;
        Bundle bundle = Activator.getInstance().getBundle();
        try {
            dialogClass = bundle.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            Trace.logError("Failed to load class for: " + className, e);
        }
        return dialogClass;
    }

    protected String openDialog(Class<?> dialogClass, Element input, String itemName, IEditorPart editorPart, String text) {
        String result = null;
        try {
            Object dialog = dialogClass.newInstance();
            if (dialog instanceof IAdvancedCustomizationObject) {
                Attr attr = input.getAttributeNode(itemName);
                result = ((IAdvancedCustomizationObject)dialog).invoke(text, (Node)attr, input, editorPart);
            } else {
                Trace.logError("Dialog class is not an instance of IAdvancedCustomizationObject: " + dialogClass.getName(), null);
            }
        }
        catch (IllegalAccessException e1) {
            Trace.logError("Failed to create dialog instance: " + dialogClass.getName(), e1);
        }
        catch (InstantiationException e1) {
            Trace.logError("Failed to create dialog instance: " + dialogClass.getName(), e1);
        }
        return result;
    }

    static {
        dialogHash.put("include", "com.ibm.ws.st.ui.internal.config.IncludeBrowser");
        dialogHash.put("applicationMonitor", "com.ibm.ws.st.ui.internal.config.AppMonitorBrowser");
        dialogHash.put("application", "com.ibm.ws.st.ui.internal.config.ApplicationLocationBrowser");
        dialogHash.put("logging", "com.ibm.ws.st.ui.internal.config.GenericDirBrowser");
        dialogHash.put("transaction", "com.ibm.ws.st.ui.internal.config.GenericDirBrowser");
        dialogHash.put("fileset", "com.ibm.ws.st.ui.internal.config.FilesetDirBrowser");
        dialogHash.put("keyStore", "com.ibm.ws.st.ui.internal.config.GenericFileBrowser");
        dialogHash.put("ltpa", "com.ibm.ws.st.ui.internal.config.GenericFileBrowser");
        dialogHash.put("file", "com.ibm.ws.st.ui.internal.config.SharedFileBrowser");
        dialogHash.put("folder", "com.ibm.ws.st.ui.internal.config.SharedFolderBrowser");
        dialogType.put("include", LocationType.FILE);
        dialogType.put("applicationMonitor", LocationType.FOLDER);
        dialogType.put("application", LocationType.ALL);
        dialogType.put("logging", LocationType.FOLDER);
        dialogType.put("transaction", LocationType.FOLDER);
        dialogType.put("fileset", LocationType.FOLDER);
        dialogType.put("keyStore", LocationType.FILE);
        dialogType.put("ltpa", LocationType.FILE);
        dialogType.put("file", LocationType.FILE);
        dialogType.put("folder", LocationType.FOLDER);
    }

    protected static enum LocationType {
        FILE,
        FOLDER,
        ALL;

    }
}

