/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.config.AbstractChainableDialog;
import com.ibm.ws.st.ui.internal.config.LibraryCreateDialog;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JDBCDriverCreateDialog
extends AbstractChainableDialog {
    protected boolean isOK = false;
    protected String id = null;
    protected String libraryRef = null;
    protected List<Element> libraryElements = null;
    protected Text idText = null;

    public JDBCDriverCreateDialog(Shell parent, Document doc, URI docURI, UserDirectory userDir, String[] tags, String[] labels) {
        super(parent, doc, docURI, userDir, tags, labels);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.jdbcDriverCreateTitle);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        this.isOK = true;
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.jdbcDriverCreateLabel);
        this.setTitleImage(Activator.getImage("wizServer"));
        this.setMessage(Messages.jdbcDriverCreateMessage);
        final Composite composite = this.createTopLevelComposite(parent);
        this.createBreadcrumb(composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.chainableConfigId);
        GridData data = new GridData(1, 2, false, false);
        label.setLayoutData((Object)data);
        this.idText = new Text(composite, 2048);
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        this.idText.setLayoutData((Object)data);
        this.idText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String idStr = JDBCDriverCreateDialog.this.idText.getText();
                if (idStr != null && !idStr.isEmpty()) {
                    JDBCDriverCreateDialog.this.id = idStr;
                    if (JDBCDriverCreateDialog.this.libraryRef != null) {
                        JDBCDriverCreateDialog.this.enableOKButton(true);
                    }
                } else {
                    JDBCDriverCreateDialog.this.enableOKButton(false);
                }
            }
        });
        label = new Label(composite, 0);
        label.setText(Messages.jdbcDriverLibRef);
        data = new GridData(1, 2, false, false);
        label.setLayoutData((Object)data);
        final Combo libraryCombo = new Combo(composite, 0);
        libraryCombo.setItems(this.getIds("library"));
        data = new GridData(4, 4, true, false);
        libraryCombo.setLayoutData((Object)data);
        libraryCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String libraryStr = libraryCombo.getText();
                if (libraryStr != null && !libraryStr.isEmpty()) {
                    JDBCDriverCreateDialog.this.libraryRef = libraryStr;
                    if (JDBCDriverCreateDialog.this.id != null) {
                        JDBCDriverCreateDialog.this.enableOKButton(true);
                    }
                } else {
                    JDBCDriverCreateDialog.this.libraryRef = null;
                    JDBCDriverCreateDialog.this.enableOKButton(false);
                }
            }
        });
        Button libraryCreateButton = new Button(composite, 8);
        libraryCreateButton.setText(Messages.newButtonAcc);
        data = new GridData(2, 2, false, false);
        libraryCreateButton.setLayoutData((Object)data);
        libraryCreateButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                String[] newTags = AbstractChainableDialog.arrayAppend(JDBCDriverCreateDialog.this.tags, "library");
                String[] newLabels = AbstractChainableDialog.arrayAppend(JDBCDriverCreateDialog.this.labels, AbstractChainableDialog.getLabel(JDBCDriverCreateDialog.this.doc, newTags, JDBCDriverCreateDialog.this.docURI, "library"));
                LibraryCreateDialog libraryDialog = new LibraryCreateDialog(composite.getShell(), JDBCDriverCreateDialog.this.doc, JDBCDriverCreateDialog.this.docURI, JDBCDriverCreateDialog.this.userDir, newTags, newLabels);
                libraryDialog.setParentLocation(JDBCDriverCreateDialog.this.getShell().getBounds());
                libraryDialog.open();
                if (libraryDialog.isOK()) {
                    JDBCDriverCreateDialog.this.libraryElements = libraryDialog.getElements();
                    JDBCDriverCreateDialog.this.libraryRef = JDBCDriverCreateDialog.this.getRefString(libraryDialog.getIds());
                    libraryCombo.setText(JDBCDriverCreateDialog.this.libraryRef);
                }
            }
        });
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.enableOKButton(false);
        return control;
    }

    public void create() {
        super.create();
        this.idText.setFocus();
    }

    protected void enableOKButton(boolean value) {
        this.getButton(0).setEnabled(value);
    }

    public boolean isOK() {
        return this.isOK;
    }

    @Override
    public String[] getIds() {
        if (this.isOK) {
            return new String[]{this.id};
        }
        return new String[0];
    }

    @Override
    public List<Element> getElements() {
        if (this.isOK) {
            ArrayList<Element> list = new ArrayList<Element>(1);
            Element elem = this.doc.createElement("jdbcDriver");
            elem.setAttribute("id", this.id);
            elem.setAttribute("libraryRef", this.libraryRef);
            list.add(elem);
            if (this.libraryElements != null) {
                list.addAll(this.libraryElements);
            }
            return list;
        }
        return Collections.emptyList();
    }
}

