/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.config.validation.FilterItem;
import com.ibm.ws.st.core.internal.config.validation.ValidationFilterSettings;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.SWTUtil;
import com.ibm.ws.st.ui.internal.config.IgnoreFilterLabelProvider;
import com.ibm.ws.st.ui.internal.config.IgnoreFilterTreeContentProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class IgnoreFilterPropertyPage
extends PropertyPage {
    protected TreeViewer treeViewer;
    protected IProject project;
    protected ValidationFilterSettings ignoreSettings;

    protected void performDefaults() {
    }

    protected void performApply() {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 64);
        label.setText(Messages.validationFilterLabel);
        GridData data = new GridData(4, 4, false, false);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        Tree tree = new Tree(composite, 68354);
        data = new GridData(4, 4, true, true);
        tree.setLayoutData((Object)data);
        tree.setFont(this.getFont());
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setAutoExpandLevel(3);
        this.treeViewer.setContentProvider((IContentProvider)new IgnoreFilterTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new IgnoreFilterLabelProvider());
        final Button filterRemove = SWTUtil.createButton(composite, Messages.remove);
        filterRemove.setEnabled(false);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty() || !(selection instanceof StructuredSelection)) {
                    filterRemove.setEnabled(false);
                } else {
                    filterRemove.setEnabled(true);
                }
            }
        });
        filterRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)IgnoreFilterPropertyPage.this.treeViewer.getSelection();
                boolean success = true;
                IgnoreFilterPropertyPage.this.treeViewer.getTree().setRedraw(false);
                for (Object element : selection) {
                    if (!(element instanceof FilterItem) || IgnoreFilterPropertyPage.this.ignoreSettings.removeFilter((FilterItem)element)) continue;
                    success = false;
                    break;
                }
                if (!success) {
                    IgnoreFilterPropertyPage.this.showErrorMessage();
                    IgnoreFilterPropertyPage.this.refreshTree();
                }
                IgnoreFilterPropertyPage.this.treeViewer.getTree().setRedraw(true);
            }
        });
        this.loadSettings();
        return composite;
    }

    private void loadSettings() {
        IAdaptable element = this.getElement();
        this.project = (IProject)element.getAdapter(IProject.class);
        if (this.project == null) {
            return;
        }
        this.ignoreSettings = new ValidationFilterSettings(this.project);
        this.treeViewer.setInput((Object)this.ignoreSettings);
    }

    protected void refreshTree() {
        this.ignoreSettings.refresh();
        this.treeViewer.setInput((Object)this.ignoreSettings);
    }

    protected void showErrorMessage() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        MessageDialog.openError((Shell)shell, (String)Messages.title, (String)Messages.removeFilterFailedMessage);
    }
}

