/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class HoverHelper {
    public static final String HOVER_DATA = "hoverData";
    public static final String DATA_ITEM = "dataItem";

    public static void addHoverHelp(final Table table) {
        table.setToolTipText("");
        final Shell shell = table.getShell();
        final Display display = shell.getDisplay();
        final Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TableItem)label.getData(HoverHelper.DATA_ITEM);
                        table.setSelection(new TableItem[]{(TableItem)e.item});
                        table.notifyListeners(13, e);
                        shell.dispose();
                        table.setFocus();
                        break;
                    }
                    case 7: {
                        shell.dispose();
                        break;
                    }
                }
            }
        };
        Listener tableListener = new Listener(){
            Shell tip = null;
            Label label = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        TableItem item = table.getItem(new Point(event.x, event.y));
                        if (item == null) break;
                        if (this.tip != null && !this.tip.isDisposed()) {
                            this.tip.dispose();
                        }
                        this.tip = new Shell(shell, 540676);
                        this.tip.setBackground(display.getSystemColor(29));
                        FillLayout layout = new FillLayout();
                        layout.marginWidth = 2;
                        this.tip.setLayout((Layout)layout);
                        this.label = new Label((Composite)this.tip, 0);
                        this.label.setForeground(display.getSystemColor(28));
                        this.label.setBackground(display.getSystemColor(29));
                        this.label.setData(HoverHelper.DATA_ITEM, (Object)item);
                        String tooltipStr = (String)item.getData(HoverHelper.HOVER_DATA);
                        if (tooltipStr == null || tooltipStr.isEmpty()) {
                            tooltipStr = item.getText();
                        }
                        this.label.setText(tooltipStr);
                        this.label.addListener(7, labelListener);
                        this.label.addListener(3, labelListener);
                        Point size = this.tip.computeSize(-1, -1);
                        Rectangle rect = item.getBounds(0);
                        Point pt = table.toDisplay(rect.x, rect.y);
                        this.tip.setBounds(pt.x, pt.y, size.x, size.y);
                        this.tip.setVisible(true);
                        break;
                    }
                }
            }
        };
        table.addListener(12, tableListener);
        table.addListener(1, tableListener);
        table.addListener(5, tableListener);
        table.addListener(32, tableListener);
    }

    public static void addHoverHelp(final Tree tree) {
        tree.setToolTipText("");
        final Shell shell = tree.getShell();
        final Display display = shell.getDisplay();
        final Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TreeItem)label.getData(HoverHelper.DATA_ITEM);
                        tree.setSelection(new TreeItem[]{(TreeItem)e.item});
                        tree.notifyListeners(13, e);
                        shell.dispose();
                        tree.setFocus();
                        break;
                    }
                    case 7: {
                        shell.dispose();
                        break;
                    }
                }
            }
        };
        Listener treeListener = new Listener(){
            Shell tip = null;
            Label label = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        TreeItem item = tree.getItem(new Point(event.x, event.y));
                        if (item == null) break;
                        if (this.tip != null && !this.tip.isDisposed()) {
                            this.tip.dispose();
                        }
                        this.tip = new Shell(shell, 540676);
                        this.tip.setBackground(display.getSystemColor(29));
                        FillLayout layout = new FillLayout();
                        layout.marginWidth = 2;
                        this.tip.setLayout((Layout)layout);
                        this.label = new Label((Composite)this.tip, 0);
                        this.label.setForeground(display.getSystemColor(28));
                        this.label.setBackground(display.getSystemColor(29));
                        this.label.setData(HoverHelper.DATA_ITEM, (Object)item);
                        String tooltipStr = (String)item.getData(HoverHelper.HOVER_DATA);
                        if (tooltipStr == null || tooltipStr.isEmpty()) {
                            tooltipStr = item.getText();
                        }
                        this.label.setText(tooltipStr);
                        this.label.addListener(7, labelListener);
                        this.label.addListener(3, labelListener);
                        Point size = this.tip.computeSize(-1, -1);
                        Rectangle rect = item.getBounds(0);
                        Point pt = tree.toDisplay(rect.x, rect.y);
                        this.tip.setBounds(pt.x, pt.y, size.x, size.y);
                        this.tip.setVisible(true);
                        break;
                    }
                }
            }
        };
        tree.addListener(12, treeListener);
        tree.addListener(1, treeListener);
        tree.addListener(5, treeListener);
        tree.addListener(32, treeListener);
    }
}

