/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.config.AbstractChainableDialog;
import com.ibm.ws.st.ui.internal.config.FileSelectorDialog;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FilesetCreateDialog
extends AbstractChainableDialog {
    private static final String DEFAULT_INCLUDES = "*";
    private static final String INITIAL_FILTER = "*.jar";
    protected boolean isOK = false;
    protected String id = null;
    protected String filesetDir = null;
    protected String filesetIncludes = null;
    protected String filesetExcludes = null;
    protected Text idText = null;

    public FilesetCreateDialog(Shell parent, Document doc, URI docURI, UserDirectory userDir, String[] tags, String[] labels) {
        super(parent, doc, docURI, userDir, tags, labels);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.filesetCreateTitle);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        this.isOK = true;
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.filesetCreateLabel);
        this.setTitleImage(Activator.getImage("wizServer"));
        this.setMessage(Messages.filesetCreateMessage);
        Composite composite = this.createTopLevelComposite(parent);
        this.createBreadcrumb(composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.chainableConfigId);
        GridData data = new GridData(1, 2, false, false);
        label.setLayoutData((Object)data);
        this.idText = new Text(composite, 2048);
        data = new GridData(4, 4, true, false);
        data.horizontalSpan = 2;
        this.idText.setLayoutData((Object)data);
        this.idText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String idStr = FilesetCreateDialog.this.idText.getText();
                if (idStr != null && !idStr.isEmpty()) {
                    FilesetCreateDialog.this.id = idStr;
                    if (FilesetCreateDialog.this.filesetDir != null) {
                        FilesetCreateDialog.this.enableOKButton(true);
                    }
                } else {
                    FilesetCreateDialog.this.enableOKButton(false);
                }
            }
        });
        label = new Label(composite, 0);
        label.setText(Messages.filesetCreateBaseDir);
        data = new GridData(1, 2, false, false);
        label.setLayoutData((Object)data);
        final Text dirText = new Text(composite, 2048);
        data = new GridData(4, 4, true, false);
        dirText.setLayoutData((Object)data);
        Button dirBrowseButton = new Button(composite, 8);
        dirBrowseButton.setText(Messages.browseButtonAcc);
        data = new GridData(2, 2, false, false);
        dirBrowseButton.setLayoutData((Object)data);
        dirBrowseButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                DirectoryDialog dirDialog = new DirectoryDialog(FilesetCreateDialog.this.getShell());
                String dirStr = dirDialog.open();
                if (dirStr != null && !dirStr.isEmpty()) {
                    FilesetCreateDialog.this.filesetDir = dirStr;
                    dirText.setText(dirStr);
                    dirText.setToolTipText(dirStr);
                    if (FilesetCreateDialog.this.id != null) {
                        FilesetCreateDialog.this.enableOKButton(true);
                    }
                }
            }
        });
        label = new Label(composite, 0);
        label.setText(Messages.filesetCreateIncludes);
        data = new GridData(1, 2, false, false);
        label.setLayoutData((Object)data);
        final Text includesText = new Text(composite, 2048);
        data = new GridData(4, 4, true, false);
        includesText.setLayoutData((Object)data);
        includesText.setText(DEFAULT_INCLUDES);
        includesText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String includesStr = includesText.getText();
                if (includesStr != null && !includesStr.isEmpty()) {
                    FilesetCreateDialog.this.filesetIncludes = includesStr;
                    includesText.setToolTipText(includesStr);
                } else {
                    FilesetCreateDialog.this.filesetIncludes = null;
                    includesText.setToolTipText("");
                }
            }
        });
        final Button includeBrowseButton = new Button(composite, 8);
        includeBrowseButton.setText(Messages.browseButtonAcc2);
        data = new GridData(2, 2, false, false);
        includeBrowseButton.setLayoutData((Object)data);
        includeBrowseButton.setEnabled(false);
        includeBrowseButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                FileSelectorDialog fileDialog = new FileSelectorDialog(FilesetCreateDialog.this.getShell(), FilesetCreateDialog.this.filesetDir, Messages.filesetIncludesTitle, Messages.filesetIncludesLabel, Messages.filesetIncludesMessage);
                fileDialog.setInitialFilter(FilesetCreateDialog.INITIAL_FILTER);
                fileDialog.open();
                if (fileDialog.isOK()) {
                    FilesetCreateDialog.this.filesetIncludes = fileDialog.getFileList();
                    includesText.setText(FilesetCreateDialog.this.filesetIncludes);
                    includesText.setToolTipText(FilesetCreateDialog.this.filesetIncludes);
                }
            }
        });
        label = new Label(composite, 0);
        label.setText(Messages.filesetCreateExcludes);
        data = new GridData(1, 2, false, false);
        label.setLayoutData((Object)data);
        final Text excludesText = new Text(composite, 2048);
        data = new GridData(4, 4, true, false);
        excludesText.setLayoutData((Object)data);
        excludesText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String excludesStr = excludesText.getText();
                if (excludesStr != null && !excludesStr.isEmpty()) {
                    FilesetCreateDialog.this.filesetExcludes = excludesStr;
                    excludesText.setToolTipText(excludesStr);
                } else {
                    FilesetCreateDialog.this.filesetExcludes = null;
                    excludesText.setToolTipText("");
                }
            }
        });
        final Button excludeBrowseButton = new Button(composite, 8);
        excludeBrowseButton.setText(Messages.browseButtonAcc3);
        data = new GridData(2, 2, false, false);
        excludeBrowseButton.setLayoutData((Object)data);
        excludeBrowseButton.setEnabled(false);
        excludeBrowseButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                FileSelectorDialog fileDialog = new FileSelectorDialog(FilesetCreateDialog.this.getShell(), FilesetCreateDialog.this.filesetDir, Messages.filesetExcludesTitle, Messages.filesetExcludesLabel, Messages.filesetExcludesMessage);
                fileDialog.setInitialFilter(FilesetCreateDialog.INITIAL_FILTER);
                fileDialog.open();
                if (fileDialog.isOK()) {
                    FilesetCreateDialog.this.filesetExcludes = fileDialog.getFileList();
                    excludesText.setText(FilesetCreateDialog.this.filesetExcludes);
                    excludesText.setToolTipText(FilesetCreateDialog.this.filesetExcludes);
                }
            }
        });
        dirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String dirStr = dirText.getText();
                if (dirStr != null && !dirStr.isEmpty()) {
                    FilesetCreateDialog.this.filesetDir = dirStr;
                    dirText.setToolTipText(dirStr);
                    includeBrowseButton.setEnabled(true);
                    excludeBrowseButton.setEnabled(true);
                    if (FilesetCreateDialog.this.id != null) {
                        FilesetCreateDialog.this.enableOKButton(true);
                    }
                } else {
                    FilesetCreateDialog.this.filesetDir = null;
                    dirText.setToolTipText("");
                    includeBrowseButton.setEnabled(false);
                    excludeBrowseButton.setEnabled(false);
                    FilesetCreateDialog.this.enableOKButton(false);
                }
            }
        });
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.enableOKButton(false);
        return control;
    }

    public void create() {
        super.create();
        this.idText.setFocus();
    }

    protected void enableOKButton(boolean value) {
        this.getButton(0).setEnabled(value);
    }

    public boolean isOK() {
        return this.isOK;
    }

    @Override
    public String[] getIds() {
        if (this.isOK) {
            return new String[]{this.id};
        }
        return new String[0];
    }

    @Override
    public List<Element> getElements() {
        if (this.isOK) {
            ArrayList<Element> list = new ArrayList<Element>(1);
            Element elem = this.doc.createElement("fileset");
            elem.setAttribute("id", this.id);
            elem.setAttribute("dir", this.filesetDir);
            if (this.filesetIncludes != null) {
                elem.setAttribute("includes", this.filesetIncludes);
            }
            if (this.filesetExcludes != null) {
                elem.setAttribute("excludes", this.filesetExcludes);
            }
            list.add(elem);
            return list;
        }
        return Collections.emptyList();
    }
}

