/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.RuntimeFeatureResolver;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.FeatureList;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.config.FeatureUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class FeatureConflictDialog
extends TitleAreaDialog {
    protected WebSphereRuntime wsRuntime;
    protected ConfigurationFile configFile;
    protected Set<RuntimeFeatureResolver.FeatureConflict> conflicts;
    protected Map<String, List<String>> requiredFeatures;
    private final List<String> allFeatures;
    private final List<String> mainFeatures;
    private final List<String> includeFeatures;
    protected List<String> currentFeatures;
    protected Label appinfoLabel;
    protected Label includeLabel;
    protected Table featureTable;
    protected Text descriptionLabel;
    protected Text enablesLabel;
    protected Text enabledByLabel;
    protected Text conflictsWithLabel;
    protected Link conflictsLink;
    protected Button ignoreButton;
    protected boolean changed;
    private boolean showIgnoreButton = true;
    private final Color gray = Display.getCurrent().getSystemColor(15);

    public FeatureConflictDialog(Shell parent, WebSphereRuntime wsRuntime, ConfigurationFile file, Map<String, List<String>> requiredFeatures, Set<RuntimeFeatureResolver.FeatureConflict> conflicts) {
        super(parent);
        this.wsRuntime = wsRuntime;
        this.configFile = file;
        this.allFeatures = this.configFile.getAllFeatures();
        this.mainFeatures = this.configFile.getFeatures();
        this.includeFeatures = new ArrayList<String>(this.allFeatures);
        this.includeFeatures.removeAll(this.mainFeatures);
        this.currentFeatures = this.configFile.getAllFeatures();
        this.requiredFeatures = requiredFeatures;
        this.conflicts = conflicts;
        this.setTitleImage(Activator.getImage("wizServer"));
    }

    public FeatureConflictDialog(Shell parent, WebSphereServerInfo serverInfo, Map<String, List<String>> requiredFeatures, Set<RuntimeFeatureResolver.FeatureConflict> conflicts) {
        super(parent);
        this.wsRuntime = serverInfo.getWebSphereRuntime();
        this.configFile = serverInfo.getConfigRoot();
        this.allFeatures = this.configFile.getAllFeatures();
        this.mainFeatures = this.configFile.getFeatures();
        this.includeFeatures = new ArrayList<String>(this.allFeatures);
        this.includeFeatures.removeAll(this.mainFeatures);
        this.currentFeatures = this.configFile.getAllFeatures();
        this.requiredFeatures = requiredFeatures;
        this.conflicts = conflicts;
        this.setTitleImage(Activator.getImage("wizServer"));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.featureConflictLabel);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.featureConflictTitle);
        this.setMessage(Messages.featureConflictDescription);
        final Shell shell = parent.getShell();
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 11;
        layout.marginWidth = 9;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.configFile.addFeatures(this.requiredFeatures.keySet());
        this.mainFeatures.addAll(this.requiredFeatures.keySet());
        this.currentFeatures.addAll(this.requiredFeatures.keySet());
        this.changed = true;
        Composite featureComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 11;
        layout.marginWidth = 9;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        layout.numColumns = 2;
        featureComposite.setLayout((Layout)layout);
        data = new GridData(4, 4, true, true);
        featureComposite.setLayoutData((Object)data);
        featureComposite.setFont(composite.getFont());
        if (this.requiredFeatures != null && !this.requiredFeatures.isEmpty()) {
            HashSet<String> allApps = new HashSet<String>();
            for (Map.Entry<String, List<String>> entry : this.requiredFeatures.entrySet()) {
                allApps.addAll((Collection<String>)entry.getValue());
            }
            String apps = FeatureUI.formatList(allApps);
            String appMessage = NLS.bind((String)Messages.featureConflictAddedAppsMessage, (Object)apps);
            this.appinfoLabel = new Label(featureComposite, 64);
            data = new GridData(4, 4, true, false);
            data.widthHint = 500;
            data.horizontalSpan = 2;
            this.appinfoLabel.setLayoutData((Object)data);
            this.appinfoLabel.setText(appMessage);
        }
        this.includeLabel = new Label(featureComposite, 64);
        data = new GridData(4, 4, true, false);
        data.widthHint = 500;
        data.horizontalSpan = 2;
        this.includeLabel.setLayoutData((Object)data);
        this.includeLabel.setText(Messages.featureConflictIncludeMessage);
        this.featureTable = new Table(featureComposite, 68098);
        data = new GridData(4, 4, true, true);
        data.heightHint = this.featureTable.getItemHeight() * 6;
        data.verticalSpan = 2;
        this.featureTable.setLayoutData((Object)data);
        FeatureUI.createColumns(this.featureTable);
        this.initFeatureTable();
        FeatureUI.resizeColumns(this.featureTable);
        Button addButton = new Button(featureComposite, 8);
        addButton.setText(Messages.addButton);
        data = new GridData(4, 1, false, false);
        addButton.setLayoutData((Object)data);
        final Button removeButton = new Button(featureComposite, 8);
        removeButton.setText(Messages.removeButton);
        data = new GridData(4, 1, false, false);
        removeButton.setLayoutData((Object)data);
        ScrolledComposite descriptionScroll = new ScrolledComposite(featureComposite, 512);
        this.descriptionLabel = new Text((Composite)descriptionScroll, 72);
        this.descriptionLabel.setText(NLS.bind((String)Messages.featureDescription, (Object)""));
        this.descriptionLabel.setBackground(parent.getBackground());
        descriptionScroll.setContent((Control)this.descriptionLabel);
        this.enablesLabel = new Text(featureComposite, 8);
        data = new GridData(4, 1, true, false);
        data.horizontalSpan = 2;
        this.enablesLabel.setLayoutData((Object)data);
        data = new GridData(4, 4, true, false);
        int lineHeight = this.enablesLabel.computeSize((int)-1, (int)-1).y;
        data.heightHint = lineHeight * 4;
        data.horizontalSpan = 2;
        descriptionScroll.setLayoutData((Object)data);
        descriptionScroll.getVerticalBar().setPageIncrement(lineHeight);
        descriptionScroll.getVerticalBar().setIncrement(lineHeight);
        this.enabledByLabel = new Text(featureComposite, 8);
        data = new GridData(4, 1, true, false);
        data.horizontalSpan = 2;
        this.enabledByLabel.setLayoutData((Object)data);
        Composite conflictsComposite = new Composite(featureComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        layout.numColumns = 2;
        conflictsComposite.setLayout((Layout)layout);
        data = new GridData(4, 4, false, false);
        conflictsComposite.setLayoutData((Object)data);
        conflictsComposite.setFont(composite.getFont());
        this.conflictsWithLabel = new Text(conflictsComposite, 8);
        data = new GridData(4, 1, false, false);
        data.horizontalSpan = 1;
        data.widthHint = 180;
        this.conflictsWithLabel.setLayoutData((Object)data);
        this.conflictsLink = new Link(conflictsComposite, 0);
        this.conflictsLink.setText("(<a>" + Messages.wizPromptDetailsLabel + "</a>)");
        data = new GridData(4, 1, false, false);
        data.horizontalSpan = 1;
        this.conflictsLink.setLayoutData((Object)data);
        this.conflictsLink.pack();
        this.featureTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FeatureConflictDialog.this.updateRemoveButton(removeButton, FeatureConflictDialog.this.featureTable);
                FeatureUI.updateInfo(FeatureConflictDialog.this.enablesLabel, FeatureConflictDialog.this.enabledByLabel, FeatureConflictDialog.this.descriptionLabel, FeatureConflictDialog.this.conflictsWithLabel, FeatureConflictDialog.this.conflictsLink, FeatureConflictDialog.this.featureTable, null, FeatureConflictDialog.this.wsRuntime);
            }
        });
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeSet<String> runtimeFeatures = new TreeSet<String>(new Comparator<String>(){

                    @Override
                    public int compare(String str1, String str2) {
                        return str1.compareToIgnoreCase(str2);
                    }
                });
                runtimeFeatures.addAll(FeatureList.getRuntimeFeatureSet((WebSphereRuntime)FeatureConflictDialog.this.wsRuntime));
                TreeSet<String> configuredFeatures = new TreeSet<String>(new Comparator<String>(){

                    @Override
                    public int compare(String str1, String str2) {
                        return str1.compareToIgnoreCase(str2);
                    }
                });
                configuredFeatures.addAll(FeatureConflictDialog.this.getFeatures());
                if (runtimeFeatures.size() == 0) {
                    MessageDialog.openInformation((Shell)shell, (String)Messages.title, (String)Messages.featureAllEnabledMsg);
                } else {
                    FeatureUI.AddDialog dialog = new FeatureUI.AddDialog(shell, runtimeFeatures, configuredFeatures, FeatureConflictDialog.this.wsRuntime);
                    if (dialog.open() == 0) {
                        Set<String> newFeatures = dialog.getFeatures();
                        for (String feature : newFeatures) {
                            FeatureConflictDialog.this.currentFeatures.add(feature);
                        }
                        FeatureConflictDialog.this.changed = true;
                        FeatureConflictDialog.this.initFeatureTable();
                        FeatureConflictDialog.this.updateRemoveButton(removeButton, FeatureConflictDialog.this.featureTable);
                        FeatureUI.updateInfo(FeatureConflictDialog.this.enablesLabel, FeatureConflictDialog.this.enabledByLabel, FeatureConflictDialog.this.descriptionLabel, FeatureConflictDialog.this.conflictsWithLabel, FeatureConflictDialog.this.conflictsLink, FeatureConflictDialog.this.featureTable, null, FeatureConflictDialog.this.wsRuntime);
                    }
                }
                FeatureConflictDialog.this.validate();
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                for (TableItem item : items = FeatureConflictDialog.this.featureTable.getSelection()) {
                    FeatureConflictDialog.this.currentFeatures.remove(((FeatureItemData)item.getData()).getFeatureName());
                }
                FeatureConflictDialog.this.changed = true;
                FeatureConflictDialog.this.initFeatureTable();
                FeatureConflictDialog.this.updateRemoveButton(removeButton, FeatureConflictDialog.this.featureTable);
                FeatureUI.updateInfo(FeatureConflictDialog.this.enablesLabel, FeatureConflictDialog.this.enabledByLabel, FeatureConflictDialog.this.descriptionLabel, FeatureConflictDialog.this.conflictsWithLabel, FeatureConflictDialog.this.conflictsLink, FeatureConflictDialog.this.featureTable, null, FeatureConflictDialog.this.wsRuntime);
                FeatureConflictDialog.this.validate();
            }
        });
        this.validate();
        return composite;
    }

    protected void updateRemoveButton(Button removeButton, Table featureTable) {
        TableItem[] items;
        for (TableItem item : items = featureTable.getSelection()) {
            if (!item.getForeground().equals((Object)this.gray)) continue;
            removeButton.setEnabled(false);
            return;
        }
        removeButton.setEnabled(items.length > 0);
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.featureTable.setFocus();
        this.getButton(0).setEnabled(false);
        if (this.showIgnoreButton) {
            this.getButton(9).setEnabled(true);
        } else {
            this.getButton(1).setEnabled(true);
        }
        return control;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.showIgnoreButton) {
            this.ignoreButton = this.createButton(parent, 9, IDialogConstants.IGNORE_LABEL, false);
            this.ignoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (MessageDialog.openConfirm((Shell)FeatureConflictDialog.this.getShell(), (String)Messages.featureConflictLabel, (String)(Messages.featureConflictIgnoreInfo + "\n\n" + Messages.featureConflictIgnoreInfoNote))) {
                        FeatureConflictDialog.this.setReturnCode(9);
                        FeatureConflictDialog.this.close();
                        return;
                    }
                    FeatureConflictDialog.this.validate();
                }
            });
        } else {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    protected void setReturnCode(int code) {
        super.setReturnCode(code);
    }

    public void create() {
        super.create();
        FeatureUI.updateInfo(this.enablesLabel, this.enabledByLabel, this.descriptionLabel, this.conflictsWithLabel, this.conflictsLink, this.featureTable, null, this.wsRuntime);
        this.descriptionLabel.setSize(this.descriptionLabel.computeSize(-1, -1));
    }

    public boolean isChanged() {
        return this.changed;
    }

    public Set<RuntimeFeatureResolver.FeatureConflict> getConflicts() {
        return this.conflicts;
    }

    protected void initFeatureTable() {
        ConflictInfo[] conflictInfos = this.getConflictInfos(this.currentFeatures);
        Collections.sort(this.currentFeatures);
        this.featureTable.removeAll();
        for (String feature : this.currentFeatures) {
            TableItem item = new TableItem(this.featureTable, 0);
            item.setText(0, feature);
            this.setItemData(item, feature, conflictInfos);
            String name = FeatureList.getFeatureDisplayName((String)feature, (WebSphereRuntime)this.wsRuntime);
            if (name != null) {
                item.setText(1, name);
            }
            String featureName = item.getText();
            if (this.requiredFeatures.keySet().contains(featureName)) {
                featureName = featureName + " (" + Messages.featureConflictNewFeature + ")";
                item.setText(0, featureName);
            }
            if (FeatureList.isValidFeature((String)feature, (WebSphereRuntime)this.wsRuntime)) {
                if (FeatureList.isFeatureSuperseded((String)feature, (WebSphereRuntime)this.wsRuntime)) {
                    item.setImage(Activator.getImage("featureSuperseded"));
                } else {
                    item.setImage(new Image[]{Activator.getImage("featureElement")});
                }
                if (this.includeFeatures.contains(feature)) {
                    item.setForeground(this.gray);
                }
                if (((FeatureItemData)item.getData()).getConflictInfo() == null) continue;
                Image img = item.getImage() == null ? Activator.getImage("featureElement") : item.getImage();
                DecorationOverlayIcon decoratedImage = new DecorationOverlayIcon(img, ImageDescriptor.createFromImage((Image)Activator.getImage("errorOverlay")), 0);
                item.setImage(new Image[]{decoratedImage.createImage()});
                continue;
            }
            item.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        }
    }

    private void setItemData(TableItem item, String feature, ConflictInfo[] conflictInfos) {
        List<Object> conflictList = null;
        for (ConflictInfo conflict : conflictInfos) {
            if (!feature.equals(conflict.feature) && !feature.equals(conflict.enablingFeature)) continue;
            List<Object> list = conflictList = item.getData() == null ? new ArrayList(1) : ((FeatureItemData)item.getData()).getConflictInfo();
            if (conflictList == null || conflictList.contains(conflict)) continue;
            conflictList.add(conflict);
        }
        item.setData((Object)new FeatureItemData(feature, conflictList));
    }

    protected List<String> getFeatures() {
        TableItem[] items = this.featureTable.getItems();
        ArrayList<String> features = new ArrayList<String>(items.length);
        for (TableItem item : items) {
            features.add(((FeatureItemData)item.getData()).getFeatureName());
        }
        return features;
    }

    private ConflictInfo[] getConflictInfos(List<String> allFeatures) {
        RuntimeFeatureResolver.ResolverResult result = RuntimeFeatureResolver.resolve((WebSphereRuntime)this.wsRuntime, allFeatures);
        this.conflicts = result.getFeatureConflicts();
        if (this.conflicts == null || this.conflicts.isEmpty()) {
            return new ConflictInfo[0];
        }
        ArrayList<ConflictInfo> infos = new ArrayList<ConflictInfo>();
        HashSet<String> symbolicFeatures = new HashSet<String>();
        for (String feature : allFeatures) {
            symbolicFeatures.add(FeatureList.getFeatureSymbolicName((String)FeatureList.getCanonicalFeatureName((String)feature, (WebSphereRuntime)this.wsRuntime), (WebSphereRuntime)this.wsRuntime));
        }
        HashMap<String, List<String>> symbolicRequiredFeatures = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.requiredFeatures.entrySet()) {
            symbolicRequiredFeatures.put(FeatureList.getFeatureSymbolicName((String)FeatureList.getCanonicalFeatureName((String)entry.getKey(), (WebSphereRuntime)this.wsRuntime), (WebSphereRuntime)this.wsRuntime), entry.getValue());
        }
        for (RuntimeFeatureResolver.FeatureConflict conflict : this.conflicts) {
            if (conflict.getDependencyChainA().isEmpty() || conflict.getDependencyChainB().isEmpty()) {
                if (!Trace.ENABLED) continue;
                Trace.trace((byte)1, "Empty conflict dependency chain.  Chain A: " + RuntimeFeatureResolver.getDependencyChainString((List)conflict.getDependencyChainA(), (WebSphereRuntime)this.wsRuntime) + ", Chain B: " + RuntimeFeatureResolver.getDependencyChainString((List)conflict.getDependencyChainB(), (WebSphereRuntime)this.wsRuntime));
                continue;
            }
            String featureA = (String)conflict.getDependencyChainA().get(0);
            String featureB = (String)conflict.getDependencyChainB().get(0);
            String feature = null;
            List conflictChain = null;
            if (symbolicRequiredFeatures.containsKey(featureA)) {
                feature = featureA;
                conflictChain = conflict.getDependencyChainB();
            } else if (symbolicRequiredFeatures.containsKey(featureB)) {
                feature = featureB;
                conflictChain = conflict.getDependencyChainA();
            } else if (symbolicFeatures.contains(feature)) {
                feature = featureA;
                conflictChain = conflict.getDependencyChainB();
            } else {
                feature = featureB;
                conflictChain = conflict.getDependencyChainA();
            }
            String mainFeature = FeatureList.getPublicFeatureName((String)feature, (WebSphereRuntime)this.wsRuntime);
            String conflictFeature = FeatureList.getPublicFeatureName((String)((String)conflictChain.get(conflictChain.size() - 1)), (WebSphereRuntime)this.wsRuntime);
            String enablingFeature = conflictChain.size() > 1 ? FeatureList.getPublicFeatureName((String)((String)conflictChain.get(0)), (WebSphereRuntime)this.wsRuntime) : conflictFeature;
            infos.add(new ConflictInfo(conflict, mainFeature, conflictFeature, enablingFeature, (List)symbolicRequiredFeatures.get(feature)));
        }
        return infos.toArray(new ConflictInfo[infos.size()]);
    }

    protected void setShellStyle(int arg0) {
        super.setShellStyle(48);
    }

    protected boolean canHandleShellCloseEvent() {
        return false;
    }

    public void setShowIgnoreButton(boolean value) {
        this.showIgnoreButton = value;
    }

    public int getRemainingConflictsSize() {
        try {
            List allFeatures = this.configFile.getAllFeatures();
            ConflictInfo[] conflictInfos = this.getConflictInfos(allFeatures);
            return conflictInfos.length;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    void validate() {
        Button okButton;
        if (this.ignoreButton != null) {
            this.ignoreButton.setEnabled(!this.conflicts.isEmpty());
        }
        if ((okButton = this.getButton(0)) != null) {
            boolean okEnable = this.conflicts.isEmpty();
            okButton.setEnabled(okEnable);
        }
    }

    protected void okPressed() {
        for (String feature : this.mainFeatures) {
            this.configFile.removeFeature(feature);
        }
        this.currentFeatures.removeAll(this.includeFeatures);
        this.configFile.addFeatures(this.currentFeatures);
        super.okPressed();
    }

    static class ConflictInfo {
        RuntimeFeatureResolver.FeatureConflict featureConflict;
        String feature;
        String conflictFeature;
        String enablingFeature;
        List<String> appNames;

        public ConflictInfo(RuntimeFeatureResolver.FeatureConflict featureConflict, String feature, String conflictFeature, String enablingFeature, List<String> appNames) {
            this.featureConflict = featureConflict;
            this.feature = feature;
            this.conflictFeature = conflictFeature;
            this.enablingFeature = enablingFeature;
            this.appNames = appNames;
        }

        public RuntimeFeatureResolver.FeatureConflict getFeatureConflict() {
            return this.featureConflict;
        }

        public String getMessage() {
            return NLS.bind((String)Messages.featureConflictDetails, (Object)this.feature, (Object)this.conflictFeature);
        }

        public String getDetails() {
            StringBuilder sb = new StringBuilder();
            if (this.appNames != null) {
                for (String appName : this.appNames) {
                    sb.append("\n - ");
                    sb.append(appName);
                }
            }
            String msg = null;
            msg = this.enablingFeature != null && !this.enablingFeature.equals(this.feature) ? (sb.length() > 0 ? NLS.bind((String)Messages.featureConflictDetailsWithDependencyAndModules, (Object[])new String[]{this.feature, this.conflictFeature, this.enablingFeature, sb.toString()}) : NLS.bind((String)Messages.featureConflictDetailsWithDependency, (Object[])new String[]{this.feature, this.conflictFeature, this.enablingFeature})) : (sb.length() > 0 ? NLS.bind((String)Messages.featureConflictDetailsWithModules, (Object[])new String[]{this.feature, this.conflictFeature, sb.toString()}) : NLS.bind((String)Messages.featureConflictDetails, (Object[])new String[]{this.feature, this.conflictFeature}));
            return msg;
        }
    }

    static class FeatureItemData {
        private final String featureName;
        private final List<ConflictInfo> conflicts;

        public FeatureItemData(String featureName, List<ConflictInfo> conflicts) {
            this.featureName = featureName;
            this.conflicts = conflicts;
        }

        public String getFeatureName() {
            return this.featureName;
        }

        public List<ConflictInfo> getConflictInfo() {
            return this.conflicts;
        }
    }
}

