/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.core.internal.config.DocumentLocation;
import com.ibm.ws.st.core.internal.config.validation.AbstractConfigurationValidator;
import com.ibm.xwt.dde.customization.ICustomItemValidationObject;
import com.ibm.xwt.dde.customization.ICustomNodeValidationObject;
import com.ibm.xwt.dde.customization.ValidationMessage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DDEConfigurationValidator
extends AbstractConfigurationValidator
implements ICustomNodeValidationObject,
ICustomItemValidationObject {
    private final List<ValidationMessage> messages = new ArrayList<ValidationMessage>();
    private Node validateNode = null;

    public ValidationMessage[] validate(Element treeNodeElement, IResource resource) {
        if (!DOMUtils.isServerElement((Element)treeNodeElement)) {
            this.validateNode = treeNodeElement;
        }
        this.validate(treeNodeElement.getOwnerDocument(), resource);
        return this.messages.toArray(new ValidationMessage[this.messages.size()]);
    }

    public ValidationMessage validate(String value, Node itemNode, Element closestAncestor, IResource resource) {
        this.validateNode = itemNode;
        this.validate(closestAncestor.getOwnerDocument(), resource);
        if (this.messages.size() > 0) {
            return this.messages.get(0);
        }
        return null;
    }

    protected void createMessage(String text, IResource resource, AbstractConfigurationValidator.Level level, Node node, AbstractConfigurationValidator.QuickFixData fixData) {
        DocumentLocation docLocation;
        if (this.validateNode != null && !node.isSameNode(this.validateNode)) {
            if (node.getNodeType() == 2) {
                if (!((Attr)node).getOwnerElement().isSameNode(this.validateNode)) {
                    return;
                }
            } else {
                return;
            }
        }
        StringBuilder builder = new StringBuilder(text);
        String location = this.getTopLevelLocation();
        if (location != null) {
            builder.append("; URI:");
            builder.append(location);
        }
        if (node != null && (docLocation = DocumentLocation.createDocumentLocation((Node)node)).getLine() != -1) {
            builder.append(", Line: ");
            builder.append(docLocation.getLine());
            if (docLocation.getColumn() != -1) {
                builder.append(", Column: ");
                builder.append(docLocation.getColumn());
            }
        }
        ValidationMessage message = new ValidationMessage(builder.toString(), this.getType(level));
        this.messages.add(message);
    }

    private int getType(AbstractConfigurationValidator.Level level) {
        switch (level) {
            case INFO: 
            case WARNING: {
                return 0;
            }
        }
        return 1;
    }
}

