/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.ui.internal.config.IContentAssistProposal;
import com.ibm.ws.st.ui.internal.config.IContentAssistProposalProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public abstract class ContentAssistBaseModifier {
    private static final int MIN_ITEMS = 5;
    private static final int MAX_ITEMS = 8;
    private static final String PROPOSAL_KEY = "proposalKey";
    private static final int MIN_CONTENT_ASSIST_WIDTH = 200;
    protected final Control control;
    protected final IContentAssistProposalProvider proposalProvider;
    protected final char autoChar;
    protected Shell popupShell;
    protected Shell popupDetails;
    protected Table suggestionTable;
    protected boolean updating = false;
    protected Color gray;
    protected TableColumn tableColumn;

    protected ContentAssistBaseModifier(Control control, IContentAssistProposalProvider proposalProvider, char autoChar) {
        this.control = control;
        this.proposalProvider = proposalProvider;
        this.autoChar = autoChar;
    }

    protected void createControls() {
        this.popupShell = new Shell(this.control.getShell(), 16384);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.popupShell.setLayout((Layout)layout);
        this.popupDetails = new Shell(this.control.getShell(), 16384);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.popupDetails.setLayout((Layout)layout);
        this.popupDetails.setBackground(this.control.getDisplay().getSystemColor(29));
        this.popupDetails.setForeground(this.control.getDisplay().getSystemColor(28));
        this.suggestionTable = new Table((Composite)this.popupShell, 65796);
        this.suggestionTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.suggestionTable.setHeaderVisible(false);
        Color bg = this.suggestionTable.getBackground();
        Color fg = this.suggestionTable.getForeground();
        this.gray = new Color(bg.getDevice(), (bg.getRed() + fg.getRed()) / 2, (bg.getGreen() + fg.getGreen()) / 2, (bg.getBlue() + fg.getBlue()) / 2);
        this.tableColumn = new TableColumn(this.suggestionTable, 0);
        this.addControlListeners();
        this.popupShell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        ContentAssistBaseModifier.this.handleESC(event);
                        event.detail = 0;
                        break;
                    }
                    case 4: {
                        ContentAssistBaseModifier.this.handleCR(event);
                        event.detail = 0;
                        break;
                    }
                }
            }
        });
        this.suggestionTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                TableItem item;
                IContentAssistProposal proposal;
                ContentAssistBaseModifier.this.updating = true;
                if (ContentAssistBaseModifier.this.suggestionTable.getSelectionIndex() != -1 && (proposal = (IContentAssistProposal)(item = ContentAssistBaseModifier.this.suggestionTable.getItem(ContentAssistBaseModifier.this.suggestionTable.getSelectionIndex())).getData(ContentAssistBaseModifier.PROPOSAL_KEY)).isEnabled()) {
                    ContentAssistBaseModifier.this.setText(proposal.getText());
                    ContentAssistBaseModifier.this.setSelection(proposal.getCursorPosition());
                    ContentAssistBaseModifier.this.popupDetails.setVisible(false);
                    ContentAssistBaseModifier.this.popupShell.setVisible(false);
                }
                ContentAssistBaseModifier.this.updating = false;
            }

            public void widgetSelected(SelectionEvent event) {
                ContentAssistBaseModifier.this.showDetails();
            }
        });
        this.suggestionTable.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                switch (event.keyCode) {
                    case 0x1000002: {
                        ContentAssistBaseModifier.this.handleArrowDown(event);
                        break;
                    }
                    case 0x1000001: {
                        ContentAssistBaseModifier.this.handleArrowUp(event);
                        break;
                    }
                }
            }
        });
        this.suggestionTable.addListener(16, (Listener)new FocusOutListener());
    }

    protected void fillSuggestionTable(String filter) {
        this.suggestionTable.removeAll();
        Point selection = this.getSelection();
        IContentAssistProposal[] proposals = this.proposalProvider.getProposals(filter, selection.x, selection.y);
        if (proposals == null) {
            return;
        }
        for (IContentAssistProposal proposal : proposals) {
            TableItem item = new TableItem(this.suggestionTable, 0);
            item.setText(proposal.getLabel());
            item.setImage(proposal.getImage());
            item.setData(PROPOSAL_KEY, (Object)proposal);
            if (proposal.isEnabled()) continue;
            item.setForeground(this.gray);
        }
    }

    protected void showSuggestions() {
        this.fillSuggestionTable(this.getText());
        if (this.suggestionTable.getItemCount() > 0) {
            Point size = this.control.getSize();
            Point location = this.control.toDisplay(0, size.y);
            this.popupShell.setLocation(location);
            int numItems = Math.max(5, Math.min(8, this.suggestionTable.getItemCount()));
            int height = this.suggestionTable.getItemHeight() * numItems + this.popupShell.getBorderWidth() * 2;
            int width = size.x > 200 ? size.x : 200;
            this.popupShell.setSize(width, height);
            this.tableColumn.setWidth(this.suggestionTable.getClientArea().width);
            this.popupShell.setVisible(true);
            size = this.popupShell.getSize();
            Display display = this.popupDetails.getDisplay();
            if ((this.popupShell.getStyle() & 0x8000000) != 0) {
                int x = location.x - size.x;
                if (x < 0) {
                    x = location.x + size.x;
                }
                location.x = x;
            } else {
                int x = location.x + size.x;
                Rectangle bounds = display.getBounds();
                if (x + size.x > bounds.width && location.x > size.x) {
                    x = location.x - size.x;
                }
                location.x = x;
            }
            this.popupDetails.setLocation(location);
            this.popupDetails.setSize(size.x, size.y);
            this.suggestionTable.setSelection(0);
            this.showDetails();
        } else {
            this.popupDetails.setVisible(false);
            this.popupShell.setVisible(false);
        }
    }

    protected void showDetails() {
        TableItem item;
        IContentAssistProposal proposal;
        if (this.suggestionTable.getSelectionIndex() != -1 && (proposal = (IContentAssistProposal)(item = this.suggestionTable.getItem(this.suggestionTable.getSelectionIndex())).getData(PROPOSAL_KEY)).hasDetails()) {
            Control[] children;
            for (Control control : children = this.popupDetails.getChildren()) {
                control.dispose();
            }
            proposal.createDetails((Composite)this.popupDetails);
            this.popupDetails.layout(true);
            this.popupDetails.setVisible(true);
            return;
        }
        this.popupDetails.setVisible(false);
    }

    protected void handleArrowDown(Event event) {
        int startIndex = this.suggestionTable.getSelectionIndex();
        int index = (startIndex + 1) % this.suggestionTable.getItemCount();
        if (startIndex == -1) {
            startIndex = this.suggestionTable.getItemCount() - 1;
        }
        IContentAssistProposal proposal = (IContentAssistProposal)this.suggestionTable.getItem(index).getData(PROPOSAL_KEY);
        while (!proposal.isEnabled() && index != startIndex) {
            index = (index + 1) % this.suggestionTable.getItemCount();
            proposal = (IContentAssistProposal)this.suggestionTable.getItem(index).getData(PROPOSAL_KEY);
        }
        if (proposal.isEnabled()) {
            this.suggestionTable.setSelection(index);
            this.suggestionTable.setFocus();
            this.showDetails();
        }
        event.doit = false;
    }

    protected void handleArrowUp(Event event) {
        int startIndex;
        int index = startIndex = this.suggestionTable.getSelectionIndex();
        int n = index = --index < 0 ? this.suggestionTable.getItemCount() - 1 : index;
        if (startIndex == -1) {
            startIndex = 0;
        }
        IContentAssistProposal proposal = (IContentAssistProposal)this.suggestionTable.getItem(index).getData(PROPOSAL_KEY);
        while (!proposal.isEnabled() && index != startIndex) {
            index = --index < 0 ? this.suggestionTable.getItemCount() - 1 : index;
            proposal = (IContentAssistProposal)this.suggestionTable.getItem(index).getData(PROPOSAL_KEY);
        }
        if (proposal.isEnabled()) {
            this.suggestionTable.setSelection(index);
            this.suggestionTable.setFocus();
            this.showDetails();
        }
        event.doit = false;
    }

    protected void handleCR(Event event) {
        TableItem item;
        IContentAssistProposal proposal;
        this.updating = true;
        if (this.suggestionTable.getSelectionIndex() != -1 && (proposal = (IContentAssistProposal)(item = this.suggestionTable.getItem(this.suggestionTable.getSelectionIndex())).getData(PROPOSAL_KEY)).isEnabled()) {
            this.setText(proposal.getText());
            this.setSelection(proposal.getCursorPosition());
            this.popupDetails.setVisible(false);
            this.popupShell.setVisible(false);
        }
        this.updating = false;
        event.doit = false;
    }

    protected void handleESC(Event event) {
        this.popupDetails.setVisible(false);
        this.popupShell.setVisible(false);
        event.doit = false;
    }

    protected abstract String getText();

    protected abstract void setText(String var1);

    protected abstract Point getSelection();

    protected abstract void setSelection(int var1);

    protected abstract void addControlListeners();

    protected class FocusOutListener
    implements Listener {
        protected FocusOutListener() {
        }

        public void handleEvent(Event event) {
            if (ContentAssistBaseModifier.this.control.isDisposed()) {
                return;
            }
            ContentAssistBaseModifier.this.control.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ContentAssistBaseModifier.this.control.isDisposed() || ContentAssistBaseModifier.this.control.getDisplay().isDisposed()) {
                        return;
                    }
                    Control focusControl = ContentAssistBaseModifier.this.control.getDisplay().getFocusControl();
                    if (focusControl == null || focusControl != ContentAssistBaseModifier.this.suggestionTable && focusControl != ContentAssistBaseModifier.this.popupShell && focusControl != ContentAssistBaseModifier.this.popupDetails) {
                        ContentAssistBaseModifier.this.popupDetails.setVisible(false);
                        ContentAssistBaseModifier.this.popupShell.setVisible(false);
                    }
                }
            });
        }
    }

    protected class ControlDisposeListener
    implements DisposeListener {
        protected ControlDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent notUsed) {
            ContentAssistBaseModifier.this.popupDetails.dispose();
            ContentAssistBaseModifier.this.popupShell.dispose();
            ContentAssistBaseModifier.this.gray.dispose();
        }
    }

    protected class MoveListener
    implements Listener {
        protected MoveListener() {
        }

        public void handleEvent(Event event) {
            if (!ContentAssistBaseModifier.this.popupDetails.isDisposed()) {
                ContentAssistBaseModifier.this.popupDetails.setVisible(false);
            }
            if (!ContentAssistBaseModifier.this.popupShell.isDisposed()) {
                ContentAssistBaseModifier.this.popupShell.setVisible(false);
            }
        }
    }

    protected class MouseDownListener
    implements Listener {
        protected MouseDownListener() {
        }

        public void handleEvent(Event event) {
            ContentAssistBaseModifier.this.popupDetails.setVisible(false);
            ContentAssistBaseModifier.this.popupShell.setVisible(false);
        }
    }

    protected class KeyListener
    implements Listener {
        protected KeyListener() {
        }

        public void handleEvent(Event event) {
            if (!ContentAssistBaseModifier.this.popupShell.isVisible()) {
                if ((event.stateMask & 0x40000) != 0 && event.keyCode == 32) {
                    ContentAssistBaseModifier.this.showSuggestions();
                    event.doit = false;
                } else if (event.character == ContentAssistBaseModifier.this.autoChar) {
                    ContentAssistBaseModifier.this.showSuggestions();
                }
                return;
            }
            switch (event.keyCode) {
                case 32: {
                    if ((event.stateMask & 0x40000) == 0) break;
                    event.doit = false;
                    break;
                }
                case 0x1000002: {
                    ContentAssistBaseModifier.this.handleArrowDown(event);
                    break;
                }
                case 0x1000001: {
                    ContentAssistBaseModifier.this.handleArrowUp(event);
                    break;
                }
                case 13: {
                    ContentAssistBaseModifier.this.handleCR(event);
                    break;
                }
                case 27: {
                    ContentAssistBaseModifier.this.handleESC(event);
                    break;
                }
            }
        }
    }

    protected class TextModifyListener
    implements ModifyListener {
        protected TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (ContentAssistBaseModifier.this.updating) {
                return;
            }
            if (ContentAssistBaseModifier.this.getText().isEmpty()) {
                ContentAssistBaseModifier.this.popupDetails.setVisible(false);
                ContentAssistBaseModifier.this.popupShell.setVisible(false);
            } else if (ContentAssistBaseModifier.this.popupShell.isVisible()) {
                ContentAssistBaseModifier.this.showSuggestions();
            }
        }
    }
}

