/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.core.internal.config.LocalConfigVars;
import com.ibm.ws.st.core.internal.config.SchemaUtil;
import com.ibm.ws.st.core.internal.config.URILocation;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.xwt.dde.customization.ICustomIconObject;
import com.ibm.xwt.dde.internal.customization.CustomizationManager;
import com.ibm.xwt.dde.internal.customization.DetailItemCustomization;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConfigUIUtils {
    protected static final String INDENT_STRING = "    ";

    public static IEditorInput getActiveEditorInput() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IWorkbenchPart part = page.getActivePart();
        if (part == null || !(part instanceof IEditorPart)) {
            return null;
        }
        IEditorPart editorPart = (IEditorPart)part;
        IEditorInput editorInput = editorPart.getEditorInput();
        return editorInput;
    }

    public static URI getURI(IEditorInput editorInput) {
        if (editorInput instanceof IPathEditorInput) {
            IPath path = ((IPathEditorInput)editorInput).getPath();
            return path.toFile().toURI();
        }
        if (editorInput instanceof IURIEditorInput) {
            return ((IURIEditorInput)editorInput).getURI();
        }
        return null;
    }

    public static URI getURI(IEditorInput editorInput, Document doc) {
        URI uri;
        block6: {
            uri = ConfigUIUtils.getURI(editorInput);
            if (uri == null) {
                String uriStr = null;
                try {
                    uriStr = doc.getDocumentURI();
                    if (uriStr != null) {
                        uri = new URI(uriStr);
                    }
                }
                catch (UnsupportedOperationException e) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)1, "Failed to get document URI", e);
                    }
                }
                catch (URISyntaxException e) {
                    if (!Trace.ENABLED) break block6;
                    Trace.trace((byte)1, "Failed to creat URI from string: " + uriStr, e);
                }
            }
        }
        return uri;
    }

    public static IFile getFile(IEditorInput editorInput) {
        if (editorInput instanceof FileEditorInput) {
            return ((FileEditorInput)editorInput).getFile();
        }
        return null;
    }

    public static List<String> getFeatures(IEditorInput editorInput, Document document) {
        URI uri = null;
        WebSphereServerInfo serverInfo = null;
        UserDirectory userDir = null;
        if (editorInput != null && (uri = ConfigUIUtils.getURI(editorInput)) != null) {
            serverInfo = ConfigUtils.getServer((URI)uri);
            userDir = serverInfo != null ? serverInfo.getUserDirectory() : ConfigUtils.getUserDirectory((URI)uri);
        }
        if (document != null) {
            List features = DOMUtils.getAllFeatures((Document)document, (URI)uri, serverInfo, userDir);
            return features;
        }
        return null;
    }

    public static ConfigVars getConfigVars(IEditorInput editorInput, Document document) {
        ConfigVars configVars = new ConfigVars();
        URI uri = null;
        ConfigurationFile configFile = null;
        WebSphereServerInfo server = null;
        UserDirectory userDir = null;
        if (editorInput != null && (uri = ConfigUIUtils.getURI(editorInput)) != null) {
            server = ConfigUtils.getServerInfo((URI)uri);
            if (server != null) {
                server.getVariables(configVars, true);
                configFile = server.getConfigurationFileFromURI(uri);
                userDir = server.getUserDirectory();
            } else {
                userDir = ConfigUtils.getUserDirectory((URI)uri);
                if (userDir != null) {
                    userDir.getVariables(configVars, true);
                }
            }
        }
        if (document != null) {
            ConfigUtils.getVariables(configFile, (Document)document, (URI)uri, (WebSphereServerInfo)server, userDir, (ConfigVars)configVars);
        }
        return configVars;
    }

    public static ConfigVars getConfigVars(IEditorInput editorInput, Element elem, String attrExclude) {
        Document document = elem == null ? null : elem.getOwnerDocument();
        ConfigVars vars = ConfigUIUtils.getConfigVars(editorInput, document);
        vars = ConfigUIUtils.getConfigVars(editorInput, elem, attrExclude, vars);
        return vars;
    }

    public static ConfigVars getConfigVars(IEditorInput editorInput, Element elem, String attrExclude, ConfigVars globalVars) {
        if (elem != null) {
            URI uri = editorInput == null ? null : ConfigUIUtils.getURI(editorInput);
            LocalConfigVars localVars = new LocalConfigVars(globalVars);
            ConfigUtils.getLocalVariables((Element)elem, (String)attrExclude, (URI)uri, (ConfigVars)localVars);
            return localVars;
        }
        return globalVars;
    }

    public static List<String> getSortedMatches(String match, List<String> candidates) {
        List<String> matches = ConfigUIUtils.getMatches(match, candidates);
        Collections.sort(matches);
        return matches;
    }

    public static List<String> getMatches(String match, List<String> candidates) {
        ArrayList<String> matches = new ArrayList<String>();
        for (String candidate : candidates) {
            String startString;
            if (match.isEmpty()) {
                matches.add(candidate);
                continue;
            }
            if (candidate.length() < match.length() || !match.equalsIgnoreCase(startString = candidate.substring(0, match.length()))) continue;
            matches.add(candidate);
        }
        return matches;
    }

    public static WebSphereRuntime getRuntime(IEditorPart editorPart) {
        UserDirectory userDir;
        URI uri;
        IEditorInput editorInput;
        if (editorPart != null && (editorInput = editorPart.getEditorInput()) != null && (uri = ConfigUIUtils.getURI(editorInput)) != null && (userDir = ConfigUtils.getUserDirectory((URI)uri)) != null) {
            return userDir.getWebSphereRuntime();
        }
        return null;
    }

    public static String getListItem(String text, int startOffset, int endOffset) {
        int start = 0;
        block3: for (int index = 0; index < text.length(); ++index) {
            char c = text.charAt(index);
            switch (c) {
                case ' ': 
                case ',': {
                    if (index < startOffset) {
                        start = index + 1;
                        continue block3;
                    }
                    if (endOffset > index) {
                        return null;
                    }
                    return text.substring(start, index);
                }
            }
        }
        String str = text.substring(start, text.length());
        return str;
    }

    public static Map<String, URILocation> getIdMap(Document doc, URI docURI, WebSphereServerInfo server, UserDirectory userDir, String reference) {
        if (reference != null) {
            HashMap<String, URILocation> idMap = new HashMap<String, URILocation>();
            DOMUtils.addIds(idMap, (Document)doc, (URI)docURI, (WebSphereServerInfo)server, (UserDirectory)userDir, (String)reference);
            if ("library".equals(reference)) {
                ConfigUtils.addDropInLibIds(idMap, (WebSphereServerInfo)server, (UserDirectory)userDir);
            }
            return idMap;
        }
        return Collections.emptyMap();
    }

    public static Map<String, URILocation> getIdMap(Document doc, URI docURI, WebSphereServerInfo server, UserDirectory userDir, String[] references) {
        if (references != null) {
            HashMap<String, URILocation> idMap = new HashMap<String, URILocation>();
            for (String reference : references) {
                DOMUtils.addIds(idMap, (Document)doc, (URI)docURI, (WebSphereServerInfo)server, (UserDirectory)userDir, (String)reference);
                if (!"library".equals(reference)) continue;
                ConfigUtils.addDropInLibIds(idMap, (WebSphereServerInfo)server, (UserDirectory)userDir);
            }
            return idMap;
        }
        return Collections.emptyMap();
    }

    public static CustomizationManager.Customization getCustomization() {
        return CustomizationManager.getInstance().getCustomization("com.ibm.ws.st.ui.configuration.editor");
    }

    public static String getTreeLabel(Element element, boolean isCreation) {
        CMElementDeclaration elemDecl;
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        if (modelQuery != null && (elemDecl = modelQuery.getCMElementDeclaration(element)) != null) {
            String path = ConfigUIUtils.getElementFullPath(element);
            return ConfigUIUtils.getTreeLabel(elemDecl, path, ConfigUIUtils.getCustomization(), false);
        }
        return element.getNodeName();
    }

    public static String getTreeLabel(CMElementDeclaration node, String path, CustomizationManager.Customization customization, boolean isCreation) {
        DetailItemCustomization nodeCustomization = customization == null ? null : customization.getItemCustomization(ConfigUIUtils.getNamespaceURI((CMNode)node), path);
        String label = null;
        if (nodeCustomization != null) {
            if (isCreation) {
                label = nodeCustomization.getCreationLabel();
            }
            if (label == null || label.isEmpty()) {
                label = nodeCustomization.getLabel();
            }
        }
        if (label == null || label.isEmpty()) {
            label = SchemaUtil.getLabel((CMNode)node);
        }
        if (label == null || label.isEmpty()) {
            label = node.getElementName();
        }
        return label;
    }

    public static Image getTreeIcon(Element element) {
        CMElementDeclaration elemDecl;
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        if (modelQuery != null && (elemDecl = modelQuery.getCMElementDeclaration(element)) != null) {
            String path = ConfigUIUtils.getElementFullPath(element);
            return ConfigUIUtils.getTreeIcon(elemDecl, path, ConfigUIUtils.getCustomization());
        }
        return Activator.getImage("configElement");
    }

    public static Image getTreeIcon(CMElementDeclaration elemDecl, String path, CustomizationManager.Customization customization) {
        block12: {
            block11: {
                if (customization == null) {
                    return Activator.getImage("configElement");
                }
                DetailItemCustomization nodeCustomization = customization.getItemCustomization(ConfigUIUtils.getNamespaceURI((CMNode)elemDecl), path);
                if (nodeCustomization != null) {
                    Image image = nodeCustomization.getIcon();
                    if (image != null) {
                        return image;
                    }
                    if (nodeCustomization.getIconClass() != null) {
                        try {
                            ICustomIconObject customIconObject;
                            Object iconClass = nodeCustomization.getIconClass().newInstance();
                            if (iconClass instanceof ICustomIconObject && (image = (customIconObject = (ICustomIconObject)iconClass).getIcon(elemDecl, null)) != null) {
                                return image;
                            }
                        }
                        catch (Exception e) {
                            if (!Trace.ENABLED) break block11;
                            Trace.trace((byte)1, "Failed to instantiate custom icon class", e);
                        }
                    }
                }
            }
            if (customization.getIconClass() != null) {
                try {
                    ICustomIconObject customIconObject;
                    Image image;
                    Object iconClass = customization.getIconClass().newInstance();
                    if (iconClass instanceof ICustomIconObject && (image = (customIconObject = (ICustomIconObject)iconClass).getIcon(elemDecl, null)) != null) {
                        return image;
                    }
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block12;
                    Trace.trace((byte)1, "Failed to instantiate top level custom icon class", e);
                }
            }
        }
        return Activator.getImage("configElement");
    }

    public static String getNamespaceURI(CMNode cmNode) {
        CMDocument cmDocument = (CMDocument)cmNode.getProperty("CMDocument");
        if (cmDocument != null) {
            return (String)cmDocument.getProperty("http://org.eclipse.wst/cm/properties/targetNamespaceURI");
        }
        return null;
    }

    public static String getElementFullPath(Element element) {
        String path = element.getLocalName();
        for (Node parentNode = element.getParentNode(); parentNode != null && parentNode.getNodeType() == 1; parentNode = parentNode.getParentNode()) {
            path = parentNode.getLocalName() + '/' + path;
        }
        return '/' + path;
    }

    public static Element addNode(String name, Element parent) {
        Document doc = parent.getOwnerDocument();
        int nestedLevel = ConfigUIUtils.getNestedLevel(parent);
        Element elem = doc.createElement(name);
        if (parent.hasChildNodes()) {
            parent.appendChild(doc.createTextNode(INDENT_STRING));
        } else {
            parent.appendChild(doc.createTextNode("\n" + ConfigUIUtils.getIndent(nestedLevel + 1)));
        }
        parent.appendChild(elem);
        parent.appendChild(doc.createTextNode("\n" + ConfigUIUtils.getIndent(nestedLevel)));
        return elem;
    }

    public static void removeNode(Element node) {
        Node parent = node.getParentNode();
        Node beforeText = node.getPreviousSibling();
        while (beforeText != null && beforeText.getNodeType() == 3) {
            Node tmpText = beforeText.getPreviousSibling();
            parent.removeChild(beforeText);
            beforeText = tmpText;
        }
        if (!parent.hasChildNodes()) {
            Node afterText = node.getNextSibling();
            while (afterText != null && afterText.getNodeType() == 3) {
                Node tmpText = afterText.getNextSibling();
                parent.removeChild(afterText);
                afterText = tmpText;
            }
        }
        parent.removeChild(node);
    }

    private static int getNestedLevel(Element elem) {
        int i = 0;
        for (Node parent = elem.getParentNode(); parent != null && parent.getNodeType() != 9; parent = parent.getParentNode()) {
            ++i;
        }
        return i;
    }

    private static String getIndent(int indent) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            builder.append(INDENT_STRING);
        }
        return builder.toString();
    }

    public static Map<String, XSDEnumerationFacet> getEnumerationMap(XSDSimpleTypeDefinition type) {
        if (type == null) {
            return null;
        }
        EList facets = type.getEnumerationFacets();
        LinkedHashMap<String, XSDEnumerationFacet> map = new LinkedHashMap<String, XSDEnumerationFacet>(facets.size());
        for (XSDEnumerationFacet facet : facets) {
            map.put(facet.getLexicalValue(), facet);
        }
        return map;
    }

    public static CMElementDeclaration getElementDecl(Element elem) {
        CMElementDeclaration elemDecl = null;
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)elem.getOwnerDocument());
        if (modelQuery != null) {
            elemDecl = modelQuery.getCMElementDeclaration(elem);
        }
        if (Trace.ENABLED && elemDecl == null) {
            if (modelQuery == null) {
                Trace.trace((byte)1, "Could not get the model based on the element passed to the custom control object by the editor: " + elem.getNodeName());
            } else {
                Trace.trace((byte)1, "Could not get the element declaration based on the element passed to the custom control object by the editor: " + elem.getNodeName());
            }
        }
        return elemDecl;
    }
}

