/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.SchemaUtil;
import com.ibm.ws.st.core.internal.config.URILocation;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.config.ConfigUIUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.AbstractXMLCompletionProposalComputer;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConfigCompletionProposalComputer
extends AbstractXMLCompletionProposalComputer {
    protected void addAttributeNameProposals(ContentAssistRequest arg0, CompletionProposalInvocationContext arg1) {
    }

    protected void addAttributeValueProposals(ContentAssistRequest request, CompletionProposalInvocationContext context) {
        Node node = request.getNode();
        if (node == null) {
            return;
        }
        Attr attr = this.getAttributeNode(request);
        Document document = node.getOwnerDocument();
        if (document == null || attr == null) {
            return;
        }
        CMAttributeDeclaration attrDecl = null;
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)document);
        if (modelQuery != null) {
            attrDecl = modelQuery.getCMAttributeDeclaration(attr);
        }
        List<ICompletionProposal> proposals = this.computeProposals(request, document, attr, attrDecl);
        for (ICompletionProposal proposal : proposals) {
            request.addProposal(proposal);
        }
    }

    protected void addCommentProposal(ContentAssistRequest arg0, CompletionProposalInvocationContext arg1) {
    }

    protected void addEmptyDocumentProposals(ContentAssistRequest arg0, CompletionProposalInvocationContext arg1) {
    }

    protected void addEndTagNameProposals(ContentAssistRequest arg0, CompletionProposalInvocationContext arg1) {
    }

    protected void addEndTagProposals(ContentAssistRequest arg0, CompletionProposalInvocationContext arg1) {
    }

    protected void addEntityProposals(ContentAssistRequest arg0, ITextRegion arg1, IDOMNode arg2, CompletionProposalInvocationContext arg3) {
    }

    protected void addEntityProposals(Vector arg0, Properties arg1, String arg2, int arg3, IStructuredDocumentRegion arg4, ITextRegion arg5, CompletionProposalInvocationContext arg6) {
    }

    protected void addPCDATAProposal(String arg0, ContentAssistRequest arg1, CompletionProposalInvocationContext arg2) {
    }

    protected void addStartDocumentProposals(ContentAssistRequest arg0, CompletionProposalInvocationContext arg1) {
    }

    protected void addTagCloseProposals(ContentAssistRequest arg0, CompletionProposalInvocationContext arg1) {
    }

    protected void addTagInsertionProposals(ContentAssistRequest arg0, int arg1, CompletionProposalInvocationContext arg2) {
    }

    protected void addTagNameProposals(ContentAssistRequest arg0, int arg1, CompletionProposalInvocationContext arg2) {
    }

    public void sessionEnded() {
    }

    public void sessionStarted() {
    }

    private List<ICompletionProposal> computeProposals(ContentAssistRequest request, Document document, Attr attr, CMAttributeDeclaration attrDecl) {
        IEditorInput editorInput = ConfigUIUtils.getActiveEditorInput();
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String type = null;
        boolean isRefType = false;
        if (attrDecl != null) {
            type = ConfigUtils.getTypeName((CMNode)attrDecl);
            boolean bl = isRefType = ConfigVars.getTypeSet((String)type) == ConfigVars.REFERENCE_TYPES;
            if (isRefType) {
                URI docURI = null;
                WebSphereServerInfo serverInfo = null;
                UserDirectory userDir = null;
                if (editorInput != null && (docURI = ConfigUIUtils.getURI(editorInput, document)) != null) {
                    serverInfo = ConfigUtils.getServerInfo((URI)docURI);
                    userDir = serverInfo != null ? serverInfo.getUserDirectory() : ConfigUtils.getUserDirectory((URI)docURI);
                }
                String[] references = SchemaUtil.getReferences((CMNode)attrDecl);
                HashMap<String, String> idMap = new HashMap<String, String>();
                for (String reference : references) {
                    Map<String, URILocation> map = ConfigUIUtils.getIdMap(document, docURI, serverInfo, userDir, reference);
                    for (String id : map.keySet()) {
                        idMap.put(id, reference);
                    }
                }
                proposals.addAll(this.computeReferenceProposals(request, idMap));
            }
        }
        if (!this.isVariableName(attr)) {
            boolean isIncludeLocation;
            Element elem = attr.getOwnerElement();
            boolean bl = isIncludeLocation = elem != null && "include".equals(elem.getNodeName()) && "location".equals(attr.getNodeName());
            ConfigVars configVars = isRefType ? ConfigUIUtils.getConfigVars(editorInput, isIncludeLocation ? null : document) : ConfigUIUtils.getConfigVars(editorInput, isIncludeLocation ? null : elem, isIncludeLocation ? null : attr.getName());
            proposals.addAll(this.computeVariableProposals(request, configVars, type));
        }
        return proposals;
    }

    private List<ICompletionProposal> computeVariableProposals(ContentAssistRequest request, ConfigVars vars, String type) {
        int replaceStart;
        ArrayList<ICompletionProposal> list = new ArrayList<ICompletionProposal>();
        int offset = request.getReplacementBeginPosition();
        String text = request.getText();
        String match = request.getMatchString();
        if (text == null || match == null || offset < 0) {
            return list;
        }
        int matchLen = match.length();
        String prefix = "";
        String suffix = "";
        String endQuote = "";
        int replaceEnd = replaceStart = offset;
        if ("=".equals(text)) {
            prefix = "\"${";
            suffix = "}";
            endQuote = "\"";
        } else {
            prefix = "${";
            suffix = "}";
            boolean inVariable = false;
            boolean start = true;
            int matchOffset = 0;
            for (int index = 0; index < matchLen; ++index) {
                char c = match.charAt(index);
                switch (c) {
                    case '\"': {
                        if (!start) break;
                        matchOffset = 1;
                        break;
                    }
                    case '$': {
                        if (index + 1 < matchLen && match.charAt(index + 1) == '{') {
                            inVariable = true;
                            matchOffset = index + 2;
                            ++index;
                            prefix = "";
                            break;
                        }
                        if (index + 1 != matchLen) break;
                        inVariable = true;
                        matchOffset = index + 1;
                        prefix = "{";
                        break;
                    }
                    case '}': {
                        if (!inVariable) break;
                        inVariable = false;
                        matchOffset = index + 1;
                        prefix = "${";
                        break;
                    }
                    case ' ': 
                    case ',': {
                        if (inVariable) break;
                        matchOffset = index + 1;
                        prefix = "${";
                        break;
                    }
                }
                if (!start) continue;
                start = false;
            }
            if (inVariable) {
                match = matchOffset >= matchLen ? "" : match.substring(matchOffset);
                replaceStart = offset + matchOffset;
                int varEnd = text.indexOf("}", matchOffset);
                if (varEnd >= 0) {
                    suffix = "}";
                    replaceEnd = offset + varEnd + 1;
                } else {
                    suffix = "}";
                    replaceEnd = offset + matchLen;
                }
            } else if (matchOffset > 0 && matchOffset < matchLen) {
                match = match.substring(matchOffset);
                replaceStart = offset + matchOffset;
                replaceEnd = replaceStart + match.length();
            } else {
                match = "";
                replaceEnd = replaceStart = offset + matchLen;
            }
        }
        List names = vars.getVars(type, true);
        List<String> varNames = ConfigUIUtils.getSortedMatches(match, names);
        String typeName = vars.getTypeName(type);
        for (String varName : varNames) {
            String str = prefix + varName + suffix;
            int strlen = str.length();
            String fullStr = str + endQuote;
            String value = vars.getValue(varName);
            if (value == null) {
                value = Messages.contentAssistUnresolved;
            }
            ConfigCompletionProposal proposal = ConfigCompletionProposal.createVariableProposal(fullStr, replaceStart, replaceEnd - replaceStart, strlen, varName, typeName, value);
            list.add(proposal);
        }
        return list;
    }

    private List<ICompletionProposal> computeReferenceProposals(ContentAssistRequest request, Map<String, String> idMap) {
        int replaceStart;
        ArrayList<ICompletionProposal> list = new ArrayList<ICompletionProposal>();
        int offset = request.getReplacementBeginPosition();
        String text = request.getText();
        String match = request.getMatchString();
        if (text == null || match == null || offset < 0) {
            return list;
        }
        int matchLen = match.length();
        String prefix = "";
        String endQuote = "";
        int replaceEnd = replaceStart = offset;
        if ("=".equals(text)) {
            prefix = "\"";
            endQuote = "\"";
        } else {
            boolean inVariable = false;
            boolean start = true;
            int matchOffset = 0;
            block6: for (int index = 0; index < matchLen; ++index) {
                char c = match.charAt(index);
                switch (c) {
                    case '\"': {
                        if (!start) continue block6;
                        matchOffset = 1;
                        continue block6;
                    }
                    case '$': {
                        if (index + 1 >= matchLen || match.charAt(index + 1) != '{') continue block6;
                        inVariable = true;
                        ++index;
                        continue block6;
                    }
                    case '}': {
                        if (!inVariable) continue block6;
                        inVariable = false;
                        matchOffset = -1;
                        continue block6;
                    }
                    case ' ': 
                    case ',': {
                        if (inVariable) continue block6;
                        matchOffset = index + 1;
                        continue block6;
                    }
                }
            }
            if (inVariable || matchOffset == -1) {
                return list;
            }
            if (matchOffset > 0 && matchOffset < matchLen) {
                match = match.substring(matchOffset);
                replaceStart = offset + matchOffset;
                replaceEnd = replaceStart + match.length();
            } else if (matchOffset >= matchLen) {
                match = "";
                replaceEnd = replaceStart = offset + matchLen;
            }
        }
        ArrayList<String> ids = new ArrayList<String>(idMap.keySet());
        List<String> idMatches = ConfigUIUtils.getSortedMatches(match, ids);
        for (String idMatch : idMatches) {
            String str = prefix + idMatch;
            int strlen = str.length();
            String fullStr = str + endQuote;
            ConfigCompletionProposal proposal = ConfigCompletionProposal.createReferenceProposal(fullStr, replaceStart, replaceEnd - replaceStart, strlen, idMatch, idMap.get(idMatch));
            list.add(proposal);
        }
        return list;
    }

    private Attr getAttributeNode(ContentAssistRequest request) {
        Node node = request.getNode();
        if (node == null) {
            return null;
        }
        Attr attr = null;
        block0 : switch (node.getNodeType()) {
            case 2: {
                attr = (Attr)node;
                break;
            }
            case 1: {
                Element elem = (Element)node;
                ITextRegion valueRegion = request.getRegion();
                IStructuredDocumentRegion docRegion = request.getDocumentRegion();
                if (valueRegion == null || docRegion == null) break;
                ITextRegionList textRegions = docRegion.getRegions();
                int index = textRegions.indexOf(valueRegion) - 1;
                while (index >= 0) {
                    ITextRegion textRegion;
                    if (!"XML_TAG_ATTRIBUTE_NAME".equals((textRegion = textRegions.get(index--)).getType())) continue;
                    String name = docRegion.getFullText(textRegion);
                    attr = elem.getAttributeNode(name);
                    break block0;
                }
                break;
            }
        }
        return attr;
    }

    protected boolean isVariableName(Attr attr) {
        Element elem;
        return attr != null && "name".equals(attr.getNodeName()) && (elem = attr.getOwnerElement()) != null && "variable".equals(elem.getNodeName());
    }

    protected static class ConfigCompletionProposal
    implements ICompletionProposal,
    ICompletionProposalExtension3 {
        protected final ICompletionProposal proposal;
        protected final List<StyleRange> styles;

        public static ConfigCompletionProposal createVariableProposal(String replaceStr, int replaceStart, int replaceLen, int cursorPos, String varName, String varType, String varValue) {
            ArrayList<StyleRange> styles = new ArrayList<StyleRange>(3);
            StringBuilder builder = new StringBuilder();
            ConfigCompletionProposal.addItem(builder, styles, Messages.contentAssistVariableLabel, varName, true);
            ConfigCompletionProposal.addItem(builder, styles, Messages.contentAssistTypeLabel, varType, true);
            ConfigCompletionProposal.addItem(builder, styles, Messages.contentAssistValueLabel, varValue, false);
            CompletionProposal proposal = new CompletionProposal(replaceStr, replaceStart, replaceLen, cursorPos, Activator.getImage("variableRef"), varName, null, builder.toString());
            return new ConfigCompletionProposal((ICompletionProposal)proposal, styles);
        }

        public static ConfigCompletionProposal createReferenceProposal(String replaceStr, int replaceStart, int replaceLen, int cursorPos, String idName, String reference) {
            ArrayList<StyleRange> styles = new ArrayList<StyleRange>(3);
            StringBuilder builder = new StringBuilder();
            ConfigCompletionProposal.addItem(builder, styles, Messages.contentAssistIdLabel, idName, true);
            ConfigCompletionProposal.addItem(builder, styles, Messages.contentAssistTypeLabel, reference, true);
            CompletionProposal proposal = new CompletionProposal(replaceStr, replaceStart, replaceLen, cursorPos, Activator.getImage("factoryRef"), idName, null, builder.toString());
            return new ConfigCompletionProposal((ICompletionProposal)proposal, styles);
        }

        private ConfigCompletionProposal(ICompletionProposal proposal, List<StyleRange> styles) {
            this.proposal = proposal;
            this.styles = styles;
        }

        protected static void addItem(StringBuilder builder, List<StyleRange> styles, String label, String value, boolean addNewline) {
            int offset = builder.length();
            builder.append(label);
            builder.append("  ");
            styles.add(new StyleRange(offset, label.length(), null, null, 1));
            builder.append(value);
            if (addNewline) {
                builder.append("\n");
            }
        }

        public IInformationControlCreator getInformationControlCreator() {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent, (DefaultInformationControl.IInformationPresenter)new ConfigProposalInformationPresenter());
                }
            };
        }

        public int getPrefixCompletionStart(IDocument arg0, int arg1) {
            return 0;
        }

        public CharSequence getPrefixCompletionText(IDocument arg0, int arg1) {
            return null;
        }

        public void apply(IDocument doc) {
            this.proposal.apply(doc);
        }

        public String getAdditionalProposalInfo() {
            return this.proposal.getAdditionalProposalInfo();
        }

        public IContextInformation getContextInformation() {
            return this.proposal.getContextInformation();
        }

        public String getDisplayString() {
            return this.proposal.getDisplayString();
        }

        public Image getImage() {
            return this.proposal.getImage();
        }

        public Point getSelection(IDocument doc) {
            return this.proposal.getSelection(doc);
        }

        protected class ConfigProposalInformationPresenter
        implements DefaultInformationControl.IInformationPresenter {
            protected ConfigProposalInformationPresenter() {
            }

            public String updatePresentation(Display display, String hoverInfo, TextPresentation presentation, int maxWidth, int maxHeight) {
                for (StyleRange style : ConfigCompletionProposal.this.styles) {
                    presentation.addStyleRange(style);
                }
                return hoverInfo;
            }
        }
    }
}

