/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.config.ConfigVarsUtils;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.config.AbstractBrowseDialog;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.w3c.dom.Document;

public class ApplicationLocationDialog
extends AbstractBrowseDialog {
    private static final String SERVERAPPVAR = ConfigVarsUtils.getVarRef((String)"server.config.dir") + "/apps";

    public ApplicationLocationDialog(Shell parent, Document document, IEditorInput editorInput) {
        super(parent, document, editorInput);
    }

    @Override
    protected String getDialogTitle() {
        return Messages.appLocationDialogTitle;
    }

    @Override
    protected String getDialogLabel() {
        return Messages.appLocationDialogLabel;
    }

    @Override
    protected String getDialogMessage() {
        return Messages.appLocationDialogMessage;
    }

    @Override
    protected AbstractBrowseDialog.VariableEntry[] initVariables() {
        IPath serverApps;
        ArrayList<AbstractBrowseDialog.VariableEntry> list = new ArrayList<AbstractBrowseDialog.VariableEntry>();
        if (this.server != null && (serverApps = this.server.getServerAppsPath()) != null) {
            list.add(new AbstractBrowseDialog.VariableEntry(Messages.relativePath, serverApps.toOSString(), SERVERAPPVAR, Activator.getImage("appFolder")));
        }
        if (this.userDir != null) {
            IPath sharedApps = this.userDir.getSharedAppsPath();
            list.add(new AbstractBrowseDialog.VariableEntry(NLS.bind((String)Messages.sharedAppsPath, (Object)"shared.app.dir"), sharedApps.toOSString(), SHAREDAPPVAR, Activator.getImage("appFolder")));
        }
        this.addConfigVars(list, "shared.app.dir", true);
        return list.toArray(new AbstractBrowseDialog.VariableEntry[list.size()]);
    }

    @Override
    protected String getEntryLabel() {
        return Messages.appLocationDialogEntryLabel;
    }
}

