/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.config.BaseCustomObject;
import com.ibm.xwt.dde.internal.util.ModelUtil;
import java.util.EventListener;
import java.util.Set;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AdditionalPropertiesCustomObject
extends BaseCustomObject {
    private static final int KEY = 0;
    private static final int VALUE = 1;

    public void createCustomControl(final Element element, String itemName, Composite parent, IEditorPart editorPart, EventListener listener) {
        TableItem item;
        TabbedPropertySheetWidgetFactory widgetFactory = new TabbedPropertySheetWidgetFactory();
        Set<String> predefinedAttrs = this.getAttributes(element);
        this.setLabelVerticalAlign(parent, 1);
        final Composite tableComposite = widgetFactory.createComposite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        tableComposite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.horizontalIndent = 2;
        tableComposite.setLayoutData((Object)data);
        tableComposite.setFont(parent.getFont());
        final Composite buttonComposite = widgetFactory.createComposite(parent, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        data = new GridData(4, 1, false, false);
        buttonComposite.setLayoutData((Object)data);
        buttonComposite.setFont(parent.getFont());
        final Table propertyTable = widgetFactory.createTable(tableComposite, 67586);
        propertyTable.setLinesVisible(true);
        propertyTable.setHeaderVisible(true);
        data = new GridData(4, 4, true, true);
        data.heightHint = 100;
        propertyTable.setLayoutData((Object)data);
        final TableColumn keyColumn = new TableColumn(propertyTable, 0);
        keyColumn.setText(Messages.additionalPropsKeyColumn);
        keyColumn.setWidth(100);
        final TableColumn valueColumn = new TableColumn(propertyTable, 0);
        valueColumn.setText(Messages.additionalPropsValueColumn);
        valueColumn.setWidth(100);
        NamedNodeMap attrMap = element.getAttributes();
        if (attrMap != null) {
            for (int i = 0; i < attrMap.getLength(); ++i) {
                Attr attr = (Attr)attrMap.item(i);
                if (predefinedAttrs.contains(attr.getName())) continue;
                item = new TableItem(propertyTable, 0);
                item.setText(0, attr.getName());
                item.setText(1, attr.getValue());
            }
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !"property".equals(node.getNodeName())) continue;
            Element childElement = (Element)node;
            item = new TableItem(propertyTable, 0);
            item.setText(0, childElement.getAttribute("name"));
            item.setText(1, childElement.getAttribute("value"));
        }
        Button addButton = widgetFactory.createButton(buttonComposite, Messages.addButton, 8);
        data = new GridData(4, 1, false, false);
        addButton.setLayoutData((Object)data);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EntryDialog dialog = AdditionalPropertiesCustomObject.this.createNewEntryDialog(buttonComposite.getShell(), element);
                dialog.open();
                if (dialog.isOK()) {
                    TableItem item = new TableItem(propertyTable, 0);
                    String key = dialog.getKey();
                    String value = dialog.getValue();
                    item.setText(0, key);
                    item.setText(1, value);
                    AdditionalPropertiesCustomObject.this.setValue(element, key, value);
                }
            }
        });
        final Button editButton = widgetFactory.createButton(buttonComposite, Messages.editButton, 8);
        data = new GridData(4, 1, false, false);
        editButton.setLayoutData((Object)data);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = propertyTable.getSelection();
                if (items.length > 0) {
                    TableItem item = items[0];
                    String origKey = item.getText(0);
                    EntryDialog dialog = AdditionalPropertiesCustomObject.this.createEditEntryDialog(buttonComposite.getShell(), element);
                    dialog.setKeyValuePair(origKey, item.getText(1));
                    dialog.open();
                    if (dialog.isOK()) {
                        String key = dialog.getKey();
                        String value = dialog.getValue();
                        item.setText(0, key);
                        item.setText(1, value);
                        if (!origKey.equalsIgnoreCase(key)) {
                            AdditionalPropertiesCustomObject.this.removeValue(element, origKey);
                        }
                        AdditionalPropertiesCustomObject.this.setValue(element, key, value);
                    }
                }
            }
        });
        final Button removeButton = widgetFactory.createButton(buttonComposite, Messages.removeButton, 8);
        data = new GridData(4, 1, false, false);
        removeButton.setLayoutData((Object)data);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indices;
                for (int index : indices = propertyTable.getSelectionIndices()) {
                    String key = propertyTable.getItem(index).getText(0);
                    AdditionalPropertiesCustomObject.this.removeValue(element, key);
                }
                propertyTable.remove(indices);
                editButton.setEnabled(false);
                removeButton.setEnabled(false);
            }
        });
        propertyTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (AdditionalPropertiesCustomObject.this.getReadOnly()) {
                    return;
                }
                int count = propertyTable.getSelectionCount();
                if (count == 1) {
                    editButton.setEnabled(true);
                    removeButton.setEnabled(true);
                } else if (count > 1) {
                    editButton.setEnabled(false);
                    removeButton.setEnabled(true);
                } else {
                    editButton.setEnabled(false);
                    removeButton.setEnabled(false);
                }
            }
        });
        tableComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = tableComposite.getClientArea();
                Point preferredSize = propertyTable.computeSize(-1, -1);
                int width = area.width - 2 * propertyTable.getBorderWidth();
                if (preferredSize.y > area.height + propertyTable.getHeaderHeight()) {
                    Point vBarSize = propertyTable.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = propertyTable.getSize();
                if (oldSize.x > area.width) {
                    keyColumn.setWidth(width / 2);
                    valueColumn.setWidth(width - keyColumn.getWidth());
                    propertyTable.setSize(area.width, area.height);
                } else {
                    propertyTable.setSize(area.width, area.height);
                    keyColumn.setWidth(width / 2);
                    valueColumn.setWidth(width - keyColumn.getWidth());
                }
            }
        });
        addButton.setEnabled(!this.getReadOnly());
        editButton.setEnabled(false);
        removeButton.setEnabled(false);
    }

    protected boolean childPropertyElementsSupported(Element element) {
        CMElementDeclaration cmElementDeclaration = this.getElementDecl(element);
        if (cmElementDeclaration != null) {
            CMNamedNodeMap localElements = cmElementDeclaration.getLocalElements();
            for (Object object : localElements) {
                CMElementDeclaration childCMElementDeclaration;
                if (!(object instanceof CMElementDeclaration) || !"property".equals((childCMElementDeclaration = (CMElementDeclaration)object).getNodeName())) continue;
                return true;
            }
        }
        return false;
    }

    protected void setValue(Element element, String key, String value) {
        NamedNodeMap attributes = element.getAttributes();
        boolean attributeFound = false;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String nodeName = attributes.item(i).getNodeName();
            if (!key.equalsIgnoreCase(nodeName) || key.equals(nodeName)) continue;
            attributeFound = true;
            break;
        }
        if (!this.childPropertyElementsSupported(element) || !attributeFound) {
            element.setAttribute(key, value);
        } else {
            boolean childElementFound = false;
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                Element childElement;
                if (node.getNodeType() != 1 || !"property".equals(node.getNodeName()) || !key.equals((childElement = (Element)node).getAttribute("name"))) continue;
                childElement.setAttribute("value", value);
                childElementFound = true;
                break;
            }
            if (!childElementFound) {
                Element propertyElement = element.getOwnerDocument().createElement("property");
                propertyElement.setAttribute("name", key);
                propertyElement.setAttribute("value", value);
                element.appendChild(propertyElement);
                ModelUtil.formatXMLNode((Node)element);
            }
        }
    }

    protected void removeValue(Element element, String key) {
        String attribute = element.getAttribute(key);
        if (attribute != null && attribute.length() > 0) {
            element.removeAttribute(key);
        } else {
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                Element childElement;
                if (node.getNodeType() != 1 || !key.equals((childElement = (Element)node).getAttribute("name"))) continue;
                ModelUtil.removePrecedingText((Element)childElement);
                element.removeChild(childElement);
                ModelUtil.formatXMLNode((Node)element);
                break;
            }
        }
    }

    protected EntryDialog createNewEntryDialog(Shell parent, Element element) {
        return new EntryDialog(parent, Messages.additionalPropsNewTitle, Messages.additionalPropsNewLabel, Messages.additionalPropsNewMessage, false, element);
    }

    protected EntryDialog createEditEntryDialog(Shell parent, Element element) {
        return new EntryDialog(parent, Messages.additionalPropsEditTitle, Messages.additionalPropsEditLabel, Messages.additionalPropsEditMessage, true, element);
    }

    private static class EntryDialog
    extends TitleAreaDialog {
        protected String dialogTitle;
        protected String dialogLabel;
        protected String dialogMessage;
        protected boolean isEdit;
        protected Element element;
        protected boolean isOK = false;
        protected String origKey = "";
        protected String key = "";
        protected String value = "";

        public EntryDialog(Shell parent, String title, String label, String message, boolean isEdit, Element element) {
            super(parent);
            this.dialogTitle = title;
            this.dialogLabel = label;
            this.dialogMessage = message;
            this.isEdit = isEdit;
            this.element = element;
        }

        public void setKeyValuePair(String key, String value) {
            this.origKey = key;
            this.key = key;
            this.value = value;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(this.dialogTitle);
        }

        protected boolean isResizable() {
            return true;
        }

        protected void buttonPressed(int buttonId) {
            super.buttonPressed(buttonId);
            if (buttonId == 0) {
                this.isOK = true;
            }
        }

        protected Control createDialogArea(Composite parent) {
            this.setTitle(this.dialogLabel);
            this.setTitleImage(Activator.getImage("wizServer"));
            this.setMessage(this.dialogMessage);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 11;
            layout.marginWidth = 9;
            layout.horizontalSpacing = 5;
            layout.verticalSpacing = 7;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            GridData data = new GridData(1808);
            data.minimumWidth = 300;
            composite.setLayoutData((Object)data);
            composite.setFont(parent.getFont());
            Label label = new Label(composite, 0);
            label.setText(Messages.additionalPropsKeyLabel);
            data = new GridData(1, 2, false, false);
            label.setLayoutData((Object)data);
            final Text keyText = new Text(composite, 2048);
            if (!this.key.isEmpty()) {
                keyText.setText(this.key);
            }
            data = new GridData(4, 4, true, false);
            keyText.setLayoutData((Object)data);
            label = new Label(composite, 0);
            label.setText(Messages.additionalPropsValueLabel);
            data = new GridData(1, 2, false, false);
            label.setLayoutData((Object)data);
            final Text valueText = new Text(composite, 2048);
            if (!this.value.isEmpty()) {
                valueText.setText(this.value);
            }
            data = new GridData(4, 4, true, false);
            valueText.setLayoutData((Object)data);
            ModifyListener listener = new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    String keyStr = keyText.getText();
                    if (!(isEdit && keyStr.equals(origKey) || !this.keyPresent(element, keyStr))) {
                        this.setErrorMessage(Messages.additionalPropsKeyError);
                        this.enableOKButton(false);
                    } else {
                        this.setErrorMessage(null);
                        String valueStr = valueText.getText();
                        if (!keyStr.isEmpty() && !valueStr.isEmpty()) {
                            key = keyStr;
                            value = valueStr;
                            this.enableOKButton(true);
                        } else {
                            key = "";
                            value = "";
                            this.enableOKButton(false);
                        }
                    }
                }

                private boolean keyPresent(Element element, String keyStr) {
                    if (element.hasAttribute(keyStr)) {
                        return true;
                    }
                    for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                        Element childElement;
                        if (node.getNodeType() != 1 || !"property".equals(node.getNodeName()) || !keyStr.equals((childElement = (Element)node).getAttribute("name"))) continue;
                        return true;
                    }
                    return false;
                }
            };
            keyText.addModifyListener(listener);
            valueText.addModifyListener(listener);
            if (this.isEdit) {
                valueText.selectAll();
                valueText.setFocus();
            } else {
                keyText.setFocus();
            }
            return composite;
        }

        protected Control createButtonBar(Composite parent) {
            Control control = super.createButtonBar(parent);
            this.enableOKButton(false);
            return control;
        }

        protected void enableOKButton(boolean value) {
            this.getButton(0).setEnabled(value);
        }

        public boolean isOK() {
            return this.isOK;
        }

        public String getKey() {
            if (this.isOK) {
                return this.key;
            }
            return null;
        }

        public String getValue() {
            if (this.isOK) {
                return this.value;
            }
            return null;
        }
    }
}

