/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.config.SchemaUtil;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.config.ConfigUIUtils;
import com.ibm.xwt.dde.internal.customization.CustomizationManager;
import com.ibm.xwt.dde.internal.util.ModelUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.PaintObjectEvent;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQueryAction;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AddConfigElemDialog
extends TitleAreaDialog {
    private static final String CMELEMENT_DECLARATION_DATA = "cmelementDeclarationData";
    private static final String HISTORY_KEY = "com.ibm.ws.st.ui.internal.config.addConfigElementDialog.history";
    private static final int HISTORY_MAX_SIZE = 10;
    private static final int DESCRIPTION_HEIGHT = 80;
    private static final String[] HISTORY_DEFAULT_ELEMS = new String[]{"quickStartSecurity", "basicRegistry", "dataSource", "library", "variable"};
    protected final Element element;
    protected final String elemPath;
    protected CMElementDeclaration newItem;
    protected SearchPattern pattern = new SearchPattern(35);
    protected Text filterText;
    protected Table itemTable;
    protected StyledText descriptionText;
    protected CustomizationManager.Customization customization = ConfigUIUtils.getCustomization();
    protected Color gray;
    protected Image selectedItemImage;

    public AddConfigElemDialog(Shell parent, Element element) {
        super(parent);
        this.element = element;
        this.elemPath = ConfigUIUtils.getElementFullPath(element);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.addElementTitle);
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.addElementLabel);
        this.setTitleImage(Activator.getImage("wizServer"));
        this.setMessage(Messages.addElementMessage);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 11;
        layout.marginWidth = 9;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)this.element.getOwnerDocument());
        String label = ConfigUIUtils.getTreeLabel(modelQuery.getCMElementDeclaration(this.element), this.elemPath, this.customization, false);
        Label contextLabel = new Label(composite, 0);
        contextLabel.setText(NLS.bind((String)Messages.addElementContextLabel, (Object)label));
        contextLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        this.filterText = new Text(composite, 2048);
        data = new GridData(4, 4, true, false);
        this.filterText.setLayoutData((Object)data);
        this.filterText.setMessage(Messages.filterMessage);
        this.itemTable = new Table(composite, 2820);
        data = new GridData(4, 4, true, true);
        data.heightHint = 300;
        this.itemTable.setLayoutData((Object)data);
        IDialogSettings settings = Activator.getInstance().getDialogSettings();
        String[] history = settings.getArray(HISTORY_KEY);
        if (history == null) {
            settings.put(HISTORY_KEY, HISTORY_DEFAULT_ELEMS);
        }
        Color bg = this.itemTable.getBackground();
        Color fg = this.itemTable.getForeground();
        this.gray = new Color(bg.getDevice(), (bg.getRed() + fg.getRed()) / 2, (bg.getGreen() + fg.getGreen()) / 2, (bg.getBlue() + fg.getBlue()) / 2);
        this.createItems(this.itemTable, this.element, "");
        this.descriptionText = new StyledText(composite, 2634);
        this.descriptionText.setTopMargin(3);
        this.descriptionText.setLeftMargin(5);
        this.descriptionText.setRightMargin(5);
        this.descriptionText.setAlwaysShowScrollBars(false);
        data = new GridData(1808);
        data.minimumHeight = 80;
        this.descriptionText.setLayoutData((Object)data);
        this.descriptionText.setBackground(parent.getBackground());
        this.descriptionText.addPaintObjectListener(new PaintObjectListener(){

            public void paintObject(PaintObjectEvent event) {
                GC gc = event.gc;
                StyleRange style = event.style;
                int x = event.x;
                int y = event.y + event.ascent - style.metrics.ascent;
                gc.drawImage(AddConfigElemDialog.this.selectedItemImage, x, y + 3);
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String text = AddConfigElemDialog.this.filterText.getText();
                if (text == null) {
                    text = "";
                }
                AddConfigElemDialog.this.createItems(AddConfigElemDialog.this.itemTable, AddConfigElemDialog.this.element, text);
                TableItem[] allItems = AddConfigElemDialog.this.itemTable.getItems();
                if (allItems.length > 0) {
                    String label;
                    int i = -1;
                    TableItem item = null;
                    while ((label = (item = allItems[++i]).getText()).startsWith("--- ") && (label.contains(Messages.addElementRecentlyAddedElementsLabel) || label.contains(Messages.addElementAllElementsLabel)) && i + 1 < allItems.length) {
                    }
                    AddConfigElemDialog.this.itemTable.select(i);
                }
                AddConfigElemDialog.this.updateInfo(AddConfigElemDialog.this.itemTable);
                TableItem[] items = AddConfigElemDialog.this.itemTable.getSelection();
                AddConfigElemDialog.this.enableOKButton(items.length > 0 && items[0].getData(AddConfigElemDialog.CMELEMENT_DECLARATION_DATA) != null);
            }
        });
        this.filterText.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 0x1000002) {
                    if (AddConfigElemDialog.this.itemTable.getItemCount() > 0) {
                        AddConfigElemDialog.this.itemTable.setSelection(0);
                        AddConfigElemDialog.this.itemTable.setFocus();
                    }
                    event.doit = false;
                }
            }
        });
        this.itemTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] items = AddConfigElemDialog.this.itemTable.getSelection();
                AddConfigElemDialog.this.enableOKButton(items.length > 0 && items[0].getData(AddConfigElemDialog.CMELEMENT_DECLARATION_DATA) != null);
                AddConfigElemDialog.this.updateInfo(AddConfigElemDialog.this.itemTable);
            }
        });
        this.itemTable.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                AddConfigElemDialog.this.okPressed();
            }
        });
        this.itemTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent notUsed) {
                AddConfigElemDialog.this.gray.dispose();
            }
        });
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.enableOKButton(false);
        return control;
    }

    public void create() {
        super.create();
        this.updateInfo(this.itemTable);
        this.filterText.setFocus();
    }

    protected void okPressed() {
        TableItem[] items = this.itemTable.getSelection();
        this.newItem = (CMElementDeclaration)items[0].getData(CMELEMENT_DECLARATION_DATA);
        if (this.newItem != null) {
            this.updateHistory(this.newItem.getElementName());
            super.okPressed();
        }
    }

    protected void enableOKButton(boolean value) {
        this.getButton(0).setEnabled(value);
    }

    protected void createItems(Table table, Element element, String filter) {
        int count;
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        CMElementDeclaration cmElementDeclaration = modelQuery.getCMElementDeclaration(element);
        ArrayList modelQueryActions = new ArrayList();
        HashMap<String, CMElementDeclaration> labelMap = new HashMap<String, CMElementDeclaration>();
        final HashMap<String, String> nameMap = new HashMap<String, String>();
        modelQuery.getInsertActions(element, cmElementDeclaration, -1, 2, 2, modelQueryActions);
        for (ModelQueryAction modelQueryAction : modelQueryActions) {
            CMElementDeclaration elemDecl;
            CMNode node = modelQueryAction.getCMNode();
            if (!(node instanceof CMElementDeclaration) || !ModelUtil.elementMustAppearInTree((CustomizationManager.Customization)this.customization, (Element)element, (CMElementDeclaration)cmElementDeclaration, (CMElementDeclaration)(elemDecl = (CMElementDeclaration)node))) continue;
            String label = ConfigUIUtils.getTreeLabel(elemDecl, this.getChildPath(node), this.customization, true);
            labelMap.put(label, elemDecl);
            nameMap.put(elemDecl.getElementName(), label);
        }
        Set labelSet = labelMap.keySet();
        ArrayList labelList = new ArrayList(labelSet);
        Collections.sort(labelList, new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                return str1.compareToIgnoreCase(str2);
            }
        });
        table.removeAll();
        this.pattern.setPattern("*" + filter + "*");
        int separatorIndex = -1;
        List<Object> history = Collections.emptyList();
        if ("server".equals(element.getNodeName())) {
            history = this.getHistory();
            Collections.sort(history, new Comparator<String>(){

                @Override
                public int compare(String str1, String str2) {
                    String labelB;
                    String labelA = (String)nameMap.get(str1);
                    if (labelA == null) {
                        labelA = str1;
                    }
                    if ((labelB = (String)nameMap.get(str2)) == null) {
                        labelB = str2;
                    }
                    return labelA.compareToIgnoreCase(labelB);
                }
            });
            count = 0;
            for (String string : history) {
                String label = (String)nameMap.get(string);
                if (label == null || !this.addItem(label, (CMElementDeclaration)labelMap.get(label), table)) continue;
                ++count;
            }
            if (count > 0) {
                TableItem item = new TableItem(table, 0, 0);
                item.setText("--- " + Messages.addElementRecentlyAddedElementsLabel + " ---");
                item.setForeground(this.gray);
                separatorIndex = table.getItemCount();
                item = new TableItem(table, 0);
                item.setText("--- " + Messages.addElementAllElementsLabel + " ---");
                item.setForeground(this.gray);
            }
        }
        count = 0;
        for (String string : labelList) {
            if (!this.addItem(string, (CMElementDeclaration)labelMap.get(string), table)) continue;
            ++count;
        }
        if (count == 0 && separatorIndex != -1) {
            table.remove(separatorIndex);
        }
    }

    protected boolean addItem(String label, CMElementDeclaration node, Table table) {
        String name = node.getElementName();
        String description = SchemaUtil.getDocumentation((CMNode)node);
        if (this.pattern.matches(name) || label != null && this.pattern.matches(label) || description != null && this.pattern.matches(description)) {
            TableItem item = new TableItem(table, 0);
            item.setText(label);
            item.setImage(ConfigUIUtils.getTreeIcon(node, this.getChildPath((CMNode)node), this.customization));
            item.setData(CMELEMENT_DECLARATION_DATA, (Object)node);
            return true;
        }
        return false;
    }

    protected void updateHistory(String elemName) {
        IDialogSettings settings = Activator.getInstance().getDialogSettings();
        String[] history = settings.getArray(HISTORY_KEY);
        ArrayList<String> newHistory = new ArrayList<String>(10);
        newHistory.add(elemName);
        int size = 1;
        for (int i = 0; i < history.length && size < 10; ++i, ++size) {
            if (newHistory.contains(history[i])) continue;
            newHistory.add(history[i]);
        }
        settings.put(HISTORY_KEY, newHistory.toArray(new String[newHistory.size()]));
    }

    protected List<String> getHistory() {
        IDialogSettings settings = Activator.getInstance().getDialogSettings();
        String[] history = settings.getArray(HISTORY_KEY);
        return Arrays.asList(history);
    }

    protected String getChildPath(CMNode node) {
        return this.elemPath + "/" + node.getNodeName();
    }

    protected void updateInfo(Table itemTable) {
        TableItem[] items = itemTable.getSelection();
        CMElementDeclaration node = null;
        if (items.length > 0) {
            node = (CMElementDeclaration)items[0].getData(CMELEMENT_DECLARATION_DATA);
        }
        if (node != null) {
            String description = SchemaUtil.getDocumentation(node);
            if (description == null || description.isEmpty()) {
                description = Messages.featureNoDescriptionAvailable;
            }
            String styledDescription = NLS.bind((String)Messages.featureRichFormatDescription, (Object[])new String[]{items[0].getText(), node.getNodeName(), description});
            this.descriptionText.setText(styledDescription);
            this.selectedItemImage = items[0].getImage();
            StyleRange style = new StyleRange();
            style.start = 1;
            style.length = styledDescription.indexOf(10);
            style.fontStyle = 1;
            this.descriptionText.setStyleRange(style);
            style = new StyleRange();
            style.start = styledDescription.indexOf(40);
            style.length = node.getNodeName().length() + 2;
            style.foreground = this.getShell().getDisplay().getSystemColor(8);
            style.fontStyle = 1;
            this.descriptionText.setStyleRange(style);
        } else {
            this.descriptionText.setText(Messages.featureRichFormatEmptySelection);
            this.selectedItemImage = Activator.getImage("information");
        }
        StyleRange style = new StyleRange();
        style.start = 0;
        style.length = 1;
        style.metrics = new GlyphMetrics(16, 0, 16);
        this.descriptionText.setStyleRange(style);
    }

    public CMElementDeclaration getNewItem() {
        return this.newItem;
    }
}

