/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.actions.OpenConfigFileAction;
import com.ibm.ws.st.ui.internal.actions.OpenMergedConfigAction;
import com.ibm.ws.st.ui.internal.actions.OpenSchemaBrowserAction;
import com.ibm.ws.st.ui.internal.actions.RefreshConfigFileAction;
import com.ibm.ws.st.ui.internal.actions.ShowInExplorerAction;
import com.ibm.ws.st.ui.internal.actions.ShowInFilesystemAction;
import com.ibm.ws.st.ui.internal.actions.ValidateConfigAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class WebSphereActionProvider
extends CommonActionProvider {
    protected OpenConfigFileAction openAction;
    protected OpenMergedConfigAction openMergedAction;
    protected OpenSchemaBrowserAction openSchemaBrowserAction;
    protected ShowInExplorerAction showInExplorerAction;
    protected ShowInFilesystemAction showInFilesystemAction;
    protected RefreshConfigFileAction refreshConfigAction;
    protected ValidateConfigAction validateConfigAction;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        StructuredViewer selectionProvider = aSite.getStructuredViewer();
        this.openAction = new OpenConfigFileAction((ISelectionProvider)selectionProvider);
        this.openMergedAction = new OpenMergedConfigAction((ISelectionProvider)selectionProvider);
        this.openSchemaBrowserAction = new OpenSchemaBrowserAction((ISelectionProvider)selectionProvider);
        this.showInExplorerAction = new ShowInExplorerAction((ISelectionProvider)selectionProvider);
        this.showInFilesystemAction = new ShowInFilesystemAction((ISelectionProvider)selectionProvider);
        this.refreshConfigAction = new RefreshConfigFileAction((ISelectionProvider)selectionProvider);
        this.validateConfigAction = new ValidateConfigAction((ISelectionProvider)selectionProvider);
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.add((IAction)this.openAction);
        if (this.openMergedAction.isEnabled()) {
            menu.add((IAction)this.openMergedAction);
        }
        if (this.openSchemaBrowserAction.isEnabled()) {
            menu.add((IAction)this.openSchemaBrowserAction);
        }
        if (this.showInExplorerAction.isEnabled()) {
            String text = Messages.actionShowIn;
            IWorkbench workbench = PlatformUI.getWorkbench();
            IBindingService bindingService = (IBindingService)workbench.getAdapter(IBindingService.class);
            TriggerSequence[] activeBindings = bindingService.getActiveBindingsFor("org.eclipse.ui.navigate.showInQuickMenu");
            if (activeBindings.length > 0) {
                text = text + "\t" + activeBindings[0].format();
            }
            MenuManager showInMenu = new MenuManager(text, "org.eclipse.ui.navigate.showInQuickMenu");
            showInMenu.add((IAction)this.showInExplorerAction);
            showInMenu.add((IAction)this.showInFilesystemAction);
            menu.appendToGroup("group.show", (IContributionItem)showInMenu);
        }
        if (this.refreshConfigAction.isEnabled()) {
            menu.add((IAction)this.refreshConfigAction);
        }
        if (this.validateConfigAction.isEnabled()) {
            menu.add((IAction)this.validateConfigAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshConfigAction);
        actionBars.updateActionBars();
    }
}

