/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.ui.internal.RuntimeExplorerView;
import com.ibm.ws.st.ui.internal.Trace;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;

public class ShowInRuntimeExplorerAction
implements IObjectActionDelegate {
    protected WebSphereServer wsServer;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            action.setEnabled(false);
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel.size() != 1) {
            action.setEnabled(false);
            return;
        }
        Object obj = sel.getFirstElement();
        if (obj instanceof IServer) {
            IServer server = (IServer)obj;
            this.wsServer = (WebSphereServer)server.loadAdapter(WebSphereServer.class, null);
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    public void run(IAction action) {
        IWorkbenchPage page;
        if (this.wsServer == null) {
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IViewPart part = page.findView("com.ibm.ws.st.ui.runtime.view");
            if (part == null) {
                try {
                    part = page.showView("com.ibm.ws.st.ui.runtime.view");
                }
                catch (PartInitException e) {
                    Trace.logError("Could not open runtime explorer view", e);
                }
            }
            if (part != null) {
                page.activate((IWorkbenchPart)part);
                RuntimeExplorerView view = (RuntimeExplorerView)((Object)part.getAdapter(RuntimeExplorerView.class));
                if (view != null) {
                    view.setFocus();
                    view.select(this.wsServer);
                }
            }
        }
    }
}

