/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.ConfigurationFolder;
import com.ibm.ws.st.core.internal.config.ExtendedConfigFile;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.RuntimeExplorer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;
import org.eclipse.wst.server.core.IServer;
import org.w3c.dom.Element;

public class ShowInExplorerAction
extends SelectionProviderAction {
    private static final String EXPLORER_VIEW_ID = "org.eclipse.ui.navigator.ProjectExplorer";
    private IResource resource;

    public ShowInExplorerAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, "Explorer");
        IViewRegistry reg = PlatformUI.getWorkbench().getViewRegistry();
        IViewDescriptor desc = reg.find(EXPLORER_VIEW_ID);
        this.setText(desc.getLabel());
        this.setImageDescriptor(desc.getImageDescriptor());
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.size() != 1) {
            this.setEnabled(false);
            return;
        }
        this.resource = null;
        Object obj = sel.getFirstElement();
        if (obj instanceof IServer) {
            IServer srv = (IServer)obj;
            WebSphereServer server = (WebSphereServer)srv.loadAdapter(WebSphereServer.class, null);
            if (server != null && server.getServerPath() != null) {
                this.resource = server.getServerInfo().getServerFolder();
            }
        } else if (obj instanceof ConfigurationFolder) {
            ConfigurationFolder folder = (ConfigurationFolder)obj;
            this.resource = folder.getFolder();
        } else if (obj instanceof ConfigurationFile) {
            ConfigurationFile configFile = (ConfigurationFile)obj;
            this.resource = configFile.getIFile();
        } else if (obj instanceof ExtendedConfigFile) {
            ExtendedConfigFile configFile = (ExtendedConfigFile)obj;
            this.resource = configFile.getIFile();
        } else if (obj instanceof Element) {
            Element element = (Element)obj;
            if (element.getParentNode() == element.getOwnerDocument()) {
                WebSphereServerInfo wsi = (WebSphereServerInfo)Platform.getAdapterManager().getAdapter(obj, WebSphereServerInfo.class);
                if (wsi != null) {
                    this.resource = wsi.getServerFolder();
                } else {
                    IFile configFile = (IFile)Platform.getAdapterManager().getAdapter(obj, IFile.class);
                    if (configFile != null) {
                        this.resource = configFile;
                    }
                }
            }
        } else if (obj instanceof UserDirectory) {
            UserDirectory userDir = (UserDirectory)obj;
            this.resource = userDir.getProject();
        } else if (obj instanceof RuntimeExplorer.Node) {
            RuntimeExplorer.Node node = (RuntimeExplorer.Node)obj;
            UserDirectory userDir = node.getUserDirectory();
            if (RuntimeExplorer.NodeType.SHARED_APPLICATIONS == node.getType()) {
                this.resource = userDir.getSharedAppsFolder();
            } else if (RuntimeExplorer.NodeType.SHARED_CONFIGURATIONS == node.getType()) {
                this.resource = userDir.getSharedConfigFolder();
            } else if (RuntimeExplorer.NodeType.SERVERS == node.getType()) {
                this.resource = userDir.getServersFolder();
            }
        } else if (obj instanceof WebSphereServerInfo) {
            WebSphereServerInfo server = (WebSphereServerInfo)obj;
            this.resource = server.getServerFolder();
        }
        this.setEnabled(this.resource != null);
    }

    public void run() {
        if (this.resource == null) {
            return;
        }
        Activator.showResource(this.resource);
    }
}

