/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.DDETreeContentProvider;
import com.ibm.ws.st.ui.internal.Messages;
import java.net.URI;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.wst.server.core.IServer;
import org.w3c.dom.Element;

public class RefreshConfigFileAction
extends SelectionProviderAction {
    private WebSphereServerInfo refreshServer;

    public RefreshConfigFileAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.actionRefresh);
        this.setActionDefinitionId("org.eclipse.ui.file.refresh");
        this.setImageDescriptor(Activator.getImageDescriptor("refresh"));
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.size() != 1) {
            this.setEnabled(false);
            return;
        }
        this.refreshServer = null;
        for (Object obj : sel) {
            ConfigurationFile file;
            WebSphereServerInfo[] servers;
            URI uri;
            if (obj instanceof IServer) {
                IServer srv = (IServer)obj;
                WebSphereServer server = (WebSphereServer)srv.loadAdapter(WebSphereServer.class, null);
                if (server == null) continue;
                this.refreshServer = server.getServerInfo();
                continue;
            }
            if (obj instanceof ConfigurationFile) {
                ConfigurationFile configFile = (ConfigurationFile)obj;
                uri = configFile.getURI();
                for (WebSphereServerInfo server : servers = WebSphereUtil.getWebSphereServerInfos()) {
                    file = server.getConfigurationFileFromURI(uri);
                    if (file == null) continue;
                    this.refreshServer = server;
                }
                continue;
            }
            if (obj instanceof Element) {
                Element element = (Element)obj;
                uri = DDETreeContentProvider.getURI(element);
                for (WebSphereServerInfo server : servers = WebSphereUtil.getWebSphereServerInfos()) {
                    file = server.getConfigurationFileFromURI(uri);
                    if (file == null) continue;
                    this.refreshServer = server;
                }
                continue;
            }
            this.setEnabled(false);
            return;
        }
        this.setEnabled(this.refreshServer != null);
    }

    public void run() {
        if (this.refreshServer == null) {
            return;
        }
        this.refreshServer.updateCache();
    }
}

