/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.RuntimeExplorer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.server.core.IRuntime;

public class PropertiesAction
extends SelectionProviderAction {
    protected String propertyPageId;
    protected Shell shell;
    protected IRuntime runtime;

    public PropertiesAction(ISelectionProvider selectionProvider, Shell shell) {
        this(shell, null, selectionProvider);
    }

    public PropertiesAction(Shell shell, String propertyPageId, ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.actionProperties);
        this.shell = shell;
        this.propertyPageId = propertyPageId;
        if (propertyPageId == null) {
            this.setActionDefinitionId("org.eclipse.ui.file.properties");
        }
        try {
            this.selectionChanged((IStructuredSelection)selectionProvider.getSelection());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.size() != 1) {
            this.setEnabled(false);
            return;
        }
        for (Object obj : sel) {
            if (obj instanceof IRuntime) {
                this.runtime = (IRuntime)obj;
                continue;
            }
            if (obj instanceof RuntimeExplorer.Node) {
                RuntimeExplorer.Node node = (RuntimeExplorer.Node)obj;
                this.runtime = node.getRuntime();
                continue;
            }
            if (obj instanceof UserDirectory) {
                UserDirectory userDir = (UserDirectory)obj;
                this.runtime = userDir.getWebSphereRuntime().getRuntime();
                continue;
            }
            if (obj instanceof WebSphereServerInfo) {
                WebSphereServerInfo server = (WebSphereServerInfo)obj;
                this.runtime = server.getWebSphereRuntime().getRuntime();
                continue;
            }
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    public void run() {
        PreferenceDialog dialog;
        if (this.propertyPageId == null) {
            this.propertyPageId = "com.ibm.ws.st.ui.properties.support";
        }
        if ((dialog = PreferencesUtil.createPropertyDialogOn((Shell)this.shell, (IAdaptable)this.runtime, (String)this.propertyPageId, null, null)) != null) {
            dialog.open();
        }
    }
}

