/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.core.internal.config.ExtendedConfigFile;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.DDETreeContentProvider;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.utility.PathUtil;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OpenConfigFileAction
extends SelectionProviderAction {
    private URI uri;
    private IFile file;
    private String xpath;
    private boolean extended;

    public OpenConfigFileAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.actionOpenConfiguration);
        this.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.editor");
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.size() != 1) {
            this.setEnabled(false);
            return;
        }
        this.file = null;
        block0: for (Object obj : sel) {
            ConfigurationFile configFile;
            if (obj instanceof Element) {
                WebSphereServerInfo[] servers;
                Element element = (Element)obj;
                this.extended = false;
                this.xpath = DOMUtils.createXPath((Node)element);
                this.uri = DDETreeContentProvider.getURI(element);
                this.file = PathUtil.getBestIFileMatchForURI(this.uri);
                if (this.file != null) continue;
                for (WebSphereServerInfo server : servers = WebSphereUtil.getWebSphereServerInfos()) {
                    ConfigurationFile configFile2 = server.getConfigurationFileFromURI(this.uri);
                    if (configFile2 == null) continue;
                    this.file = configFile2.getIFile();
                    continue block0;
                }
                continue;
            }
            if (obj instanceof ConfigurationFile) {
                configFile = (ConfigurationFile)obj;
                this.extended = false;
                this.uri = configFile.getURI();
                this.file = configFile.getIFile();
                continue;
            }
            if (obj instanceof ExtendedConfigFile) {
                configFile = (ExtendedConfigFile)obj;
                this.extended = true;
                this.uri = configFile.getURI();
                this.file = PathUtil.getBestIFileMatchForURI(this.uri);
                if (this.file != null) continue;
                this.file = configFile.getIFile();
                continue;
            }
            if (obj instanceof IFile) {
                this.file = (IFile)obj;
                this.uri = this.file.getLocation().toFile().toURI();
                continue;
            }
            this.setEnabled(false);
            return;
        }
        this.setEnabled(this.uri != null);
    }

    public void run() {
        if (this.uri == null) {
            return;
        }
        if (this.extended) {
            Activator.openEditor(this.file, this.uri);
        } else {
            Activator.openConfigurationEditor(this.file, this.uri, this.xpath);
        }
    }
}

