/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.RuntimeExplorer;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.wizard.WebSphereServerWizardFragment;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.WizardTaskUtil;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class NewServerAction
extends SelectionProviderAction {
    private final Shell shell;
    private IRuntime runtime;
    private UserDirectory userDirectory;

    public NewServerAction(ISelectionProvider selectionProvider, Shell shell) {
        super(selectionProvider, Messages.actionNewServer);
        this.shell = shell;
        this.setImageDescriptor(Activator.getImageDescriptor("server"));
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.size() != 1) {
            this.setEnabled(false);
            return;
        }
        for (Object obj : sel) {
            if (obj instanceof IRuntime) {
                this.runtime = (IRuntime)obj;
                this.userDirectory = null;
                continue;
            }
            if (obj instanceof UserDirectory) {
                this.userDirectory = (UserDirectory)obj;
                this.runtime = this.userDirectory.getWebSphereRuntime().getRuntime();
                continue;
            }
            if (obj instanceof RuntimeExplorer.Node) {
                RuntimeExplorer.Node node = (RuntimeExplorer.Node)obj;
                this.runtime = node.getRuntime();
                this.userDirectory = node.getUserDirectory();
                continue;
            }
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    public void run() {
        if (this.runtime == null) {
            return;
        }
        try {
            IServerType st = null;
            String runtimeId = this.runtime.getRuntimeType().getId();
            st = runtimeId.endsWith(".v85.was") ? ServerCore.findServerType((String)"com.ibm.ws.st.server.v85.was") : ServerCore.findServerType((String)"com.ibm.ws.st.server.wlp");
            IServerWorkingCopy wc = st.createServer(null, null, this.runtime, null);
            TaskModel taskModel = new TaskModel();
            taskModel.putObject("server", (Object)wc);
            taskModel.putObject("userDirectory", (Object)this.userDirectory);
            taskModel.putObject("runtime", (Object)this.runtime);
            taskModel.putObject("preventResize", (Object)true);
            WizardFragment fragment = new WizardFragment(){

                protected void createChildFragments(List<WizardFragment> list) {
                    list.add(new WebSphereServerWizardFragment());
                    list.add(WizardTaskUtil.SaveServerFragment);
                }
            };
            TaskWizard wizard = new TaskWizard(Messages.title, fragment, taskModel);
            WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard);
            dialog.open();
        }
        catch (CoreException ce) {
            Trace.logError("Error creating server", ce);
        }
    }
}

