/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public class NewQuickServerAction
extends SelectionProviderAction {
    private WebSphereServerInfo serverInfo;

    public NewQuickServerAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.actionNewQuickServer);
        this.setImageDescriptor(Activator.getImageDescriptor("server"));
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj = sel.getFirstElement();
        if (obj instanceof WebSphereServerInfo) {
            WebSphereServer[] servers;
            this.serverInfo = (WebSphereServerInfo)obj;
            for (WebSphereServer ws : servers = WebSphereUtil.getWebSphereServers()) {
                if (!this.serverInfo.equals(ws.getServerInfo())) continue;
                this.setEnabled(false);
                return;
            }
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        NewQuickServerAction.createServer(this.serverInfo, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void createServer(WebSphereServerInfo serverInfo, IProgressMonitor monitor) {
        try {
            IRuntime runtime = serverInfo.getWebSphereRuntime().getRuntime();
            IServerType st = null;
            String runtimeId = runtime.getRuntimeType().getId();
            st = runtimeId.endsWith(".v85.was") ? ServerCore.findServerType((String)"com.ibm.ws.st.server.v85.was") : ServerCore.findServerType((String)"com.ibm.ws.st.server.wlp");
            IServerWorkingCopy wc = st.createServer(null, null, runtime, monitor);
            wc.setName(serverInfo.getServerName());
            WebSphereServer ws = (WebSphereServer)wc.loadAdapter(WebSphereServer.class, monitor);
            ws.setServerName(serverInfo.getServerName());
            ws.setUserDir(serverInfo.getUserDirectory());
            wc.save(false, monitor);
        }
        catch (Exception e) {
            Trace.logError("Error trying to create server: " + serverInfo.getServerName(), e);
        }
    }
}

