/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.ui.internal.ChangeRuntimeLocationDialog;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.plugin.ServerUtil;
import com.ibm.ws.st.ui.internal.wizard.WebSphereRuntimeWizardFragment;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.WizardTaskUtil;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class EditRuntimeAction
extends SelectionProviderAction {
    protected final Shell shell;
    protected IRuntime runtime;
    private final StructuredViewer viewer;

    public EditRuntimeAction(Shell shell, ISelectionProvider selectionProvider, StructuredViewer viewer) {
        super(selectionProvider, Messages.actionEditRuntime);
        this.shell = shell;
        this.viewer = viewer;
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.size() != 1) {
            this.setEnabled(false);
            return;
        }
        for (Object obj : sel) {
            if (obj instanceof IRuntime) {
                this.runtime = (IRuntime)obj;
                continue;
            }
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    public void run() {
        if (this.runtime == null) {
            return;
        }
        try {
            IRuntimeWorkingCopy runtimeWorkingCopy = this.runtime.createWorkingCopy();
            if (this.showWizard(runtimeWorkingCopy) != 1) {
                WebSphereRuntime wasRuntime = (WebSphereRuntime)this.runtime.loadAdapter(WebSphereRuntime.class, null);
                wasRuntime.refresh();
            }
            this.viewer.refresh((Object)this.runtime);
        }
        catch (Exception ce) {
            Trace.logError("Error editing runtime: " + this.runtime.getId(), ce);
        }
    }

    protected int showWizard(final IRuntimeWorkingCopy runtimeWorkingCopy) {
        final IPath oldLoc = runtimeWorkingCopy.getLocation();
        TaskModel taskModel = new TaskModel();
        taskModel.putObject("runtime", (Object)runtimeWorkingCopy);
        TaskWizard wizard = new TaskWizard(Messages.wizRuntimeTitle, new WizardFragment(){

            protected void createChildFragments(List<WizardFragment> list) {
                list.add(new WebSphereRuntimeWizardFragment());
                list.add(WizardTaskUtil.SaveRuntimeFragment);
            }
        }, taskModel);
        wizard.setForcePreviousAndNextButtons(true);
        WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard){

            protected void finishPressed() {
                if (!oldLoc.equals((Object)runtimeWorkingCopy.getLocation())) {
                    IServer[] servers = ServerUtil.getServers(EditRuntimeAction.this.runtime);
                    ChangeRuntimeLocationDialog dialog = new ChangeRuntimeLocationDialog(EditRuntimeAction.this.shell, servers != null && servers.length > 0);
                    if (dialog.open() == 1) {
                        return;
                    }
                    if (dialog.isDeleteServers()) {
                        try {
                            ServerUtil.deleteServers(servers, false);
                        }
                        catch (Exception e) {
                            Trace.logError(e.getLocalizedMessage(), e);
                        }
                    }
                }
                super.finishPressed();
            }
        };
        return dialog.open();
    }
}

