/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.repository.IRuntimeInfo;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.actions.WebSphereUtilityAction;
import com.ibm.ws.st.ui.internal.download.ConfigSnippetWizardContainer;
import com.ibm.ws.st.ui.internal.download.DownloadHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class ConfigSnippetAction
extends WebSphereUtilityAction {
    private IRuntime runtime;
    private IRuntimeInfo core;

    public ConfigSnippetAction(Shell shell, ISelectionProvider selProvider) {
        super(Messages.actionAddConfigSnippets, shell, selProvider);
    }

    @Override
    public boolean selectionChanged(Iterator<?> iterator) {
        this.runtime = null;
        this.core = null;
        if (this.server == null || this.server.getWebSphereRuntime() == null) {
            return false;
        }
        this.runtime = this.server.getWebSphereRuntime().getRuntime();
        if (this.runtime == null || this.runtime.getLocation() == null) {
            return false;
        }
        if (this.isDisableUtilityPrompted()) {
            return false;
        }
        this.core = DownloadHelper.getRuntimeCore(this.runtime);
        if (this.core.getVersion() == null || this.core.getVersion().startsWith("8.5.0")) {
            return false;
        }
        WebSphereRuntime wsRuntime = (WebSphereRuntime)this.runtime.loadAdapter(WebSphereRuntime.class, null);
        if (wsRuntime != null && !wsRuntime.supportsInstallingAdditionalContent()) {
            this.setEnabled(false);
            return false;
        }
        return true;
    }

    @Override
    public boolean isUtilityRemoteSupported() {
        return false;
    }

    public void run() {
        if (this.server == null || this.core == null) {
            return;
        }
        if (this.notifyUtilityDisabled(this.wsServer.getServerType(), "ConfigSnippetAction")) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("folder", this.server.getConfigRoot().getPath().removeLastSegments(1).toOSString());
        map.put("runtimeTypeId", this.runtime.getRuntimeType().getId());
        map.put("extend", "true");
        map.put("core", (String)this.core);
        TaskModel taskModel = new TaskModel();
        taskModel.putObject("runtime", (Object)this.runtime);
        taskModel.putObject("server", (Object)this.server);
        taskModel.putObject("addonMap", map);
        WizardFragment fragment = new WizardFragment(){

            protected void createChildFragments(List<WizardFragment> list) {
                list.add(new ConfigSnippetWizardContainer());
            }
        };
        TaskWizard wizard = new TaskWizard(Messages.wizInstallAddonTitle, fragment, taskModel);
        WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard);
        dialog.setPageSize(450, 600);
        dialog.open();
    }

    public String getId() {
        return "ConfigSnippetAction";
    }
}

