/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.repository.IRuntimeInfo;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.download.DownloadHelper;
import com.ibm.ws.st.ui.internal.download.DownloadUI;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.TaskModel;

public class AddOnRuntimeAction
extends SelectionProviderAction {
    private final Shell shell;
    private IRuntime runtime;
    private IRuntimeInfo core;

    protected AddOnRuntimeAction(Shell shell, ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.actionInstallAddOn);
        this.shell = shell;
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.size() != 1) {
            this.setEnabled(false);
            return;
        }
        this.runtime = null;
        this.core = null;
        for (Object obj : sel) {
            if (obj instanceof IRuntime) {
                this.runtime = (IRuntime)obj;
                IRuntimeType runtimeType = this.runtime.getRuntimeType();
                IPath path = this.runtime.getLocation();
                if (path == null || runtimeType == null || !runtimeType.getId().startsWith("com.ibm.ws.st.runtime")) {
                    this.setEnabled(false);
                    return;
                }
                this.core = DownloadHelper.getRuntimeCore(this.runtime);
                if (this.core.getVersion() == null || this.core.getVersion().startsWith("8.5.0")) {
                    this.setEnabled(false);
                    return;
                }
                WebSphereRuntime wsRuntime = (WebSphereRuntime)this.runtime.loadAdapter(WebSphereRuntime.class, null);
                if (wsRuntime == null || wsRuntime.supportsInstallingAdditionalContent()) continue;
                this.setEnabled(false);
                return;
            }
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    public void run() {
        if (this.runtime == null || this.core == null) {
            return;
        }
        IPath path = this.runtime.getLocation();
        if (path == null) {
            return;
        }
        WebSphereRuntime wsRuntime = (WebSphereRuntime)this.runtime.loadAdapter(WebSphereRuntime.class, null);
        if (wsRuntime == null) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map = new HashMap();
        map.put("folder", this.runtime.getLocation().toOSString());
        map.put("runtimeTypeId", this.runtime.getRuntimeType().getId());
        map.put("core", (String)this.core);
        TaskModel taskModel = new TaskModel();
        taskModel.putObject("runtime", (Object)this.runtime);
        taskModel.putObject("addonMap", map);
        DownloadUI.launchAddonsDialog(this.shell, taskModel);
    }
}

