/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.ui.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.provisional.IServerToolTip;

public class WebSphereServerToolTip
implements IServerToolTip {
    public void createContent(Composite parent, IServer server) {
        String[] errors;
        Composite comp = parent;
        WebSphereServer serv = (WebSphereServer)server.loadAdapter(WebSphereServer.class, null);
        if (serv == null) {
            return;
        }
        WebSphereRuntime runtime = serv.getWebSphereRuntime();
        if (runtime == null) {
            return;
        }
        Label label = new Label(comp, 0);
        label.setText(NLS.bind((String)Messages.serverTooltipName, (Object)serv.getServerName()));
        label.setBackground(parent.getBackground());
        label = new Label(comp, 0);
        label.setText(NLS.bind((String)Messages.serverTooltipLocation, (Object)runtime.getRuntime().getLocation().toOSString()));
        label.setBackground(parent.getBackground());
        if (serv.getConfigurationRoot() != null) {
            label = new Label(comp, 0);
            label.setText(NLS.bind((String)Messages.serverTooltipConfigRoot, (Object)serv.getConfigurationRoot().toOSString()));
            label.setBackground(parent.getBackground());
        }
        if (serv.isLocalSetup() && serv.getServerInfo() != null && (errors = serv.getServerInfo().getServerErrors()).length > 0) {
            label = new Label(comp, 0);
            label.setText(Messages.serverTooltipErrors);
            label.setBackground(parent.getBackground());
            for (String error : errors) {
                label = new Label(comp, 0);
                label.setText("\t" + error);
                label.setBackground(parent.getBackground());
            }
        }
    }
}

