/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.core.internal.SetServerPasswordCommand;
import com.ibm.ws.st.core.internal.SetServerPortCommand;
import com.ibm.ws.st.core.internal.SetServerUserNameCommand;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import com.ibm.ws.st.ui.internal.Messages;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.ui.editor.IServerEditorPartInput;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class ServerEditorConnectionSettingsSection
extends ServerEditorSection {
    protected WebSphereServer wsServer;
    protected Text userName;
    protected Text password;
    protected Text port;
    protected Button verifyButton;
    protected boolean updating;
    protected FormToolkit toolkit;
    protected STATE validity = STATE.NOT_STARTED;
    protected PropertyChangeListener listener;
    protected boolean hostNameChanged = false;

    protected void addChangeListener() {
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (ServerEditorConnectionSettingsSection.this.updating) {
                    return;
                }
                ServerEditorConnectionSettingsSection.this.updating = true;
                WebSphereServer cfr_ignored_0 = ServerEditorConnectionSettingsSection.this.wsServer;
                if ("userName".equals(event.getPropertyName())) {
                    String newValue = (String)event.getNewValue();
                    if (newValue != null) {
                        ServerEditorConnectionSettingsSection.this.userName.setText(newValue);
                    }
                } else {
                    WebSphereServer cfr_ignored_1 = ServerEditorConnectionSettingsSection.this.wsServer;
                    if (".serverConnectionPassword".equals(event.getPropertyName())) {
                        String newValue = (String)event.getNewValue();
                        if (newValue != null) {
                            ServerEditorConnectionSettingsSection.this.password.setText(newValue);
                        }
                    } else {
                        WebSphereServer cfr_ignored_2 = ServerEditorConnectionSettingsSection.this.wsServer;
                        if ("securePort".equals(event.getPropertyName())) {
                            String newValue = (String)event.getNewValue();
                            if (newValue != null) {
                                ServerEditorConnectionSettingsSection.this.port.setText(newValue);
                            }
                        } else if ("hostname".equals(event.getPropertyName())) {
                            ServerEditorConnectionSettingsSection.this.hostNameChanged = true;
                        }
                    }
                }
                ServerEditorConnectionSettingsSection.this.validatePage();
                ServerEditorConnectionSettingsSection.this.updating = false;
            }
        };
        this.server.addPropertyChangeListener(this.listener);
        this.wsServer.addPropertyChangeListener(this.listener);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        this.toolkit = this.getFormToolkit(parent.getDisplay());
        Section section = this.toolkit.createSection(parent, 394);
        section.setText(Messages.editorServerConnectionSettingsTitle);
        section.setDescription(Messages.editorServerConnectionSettingsDescription);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 15;
        layout.marginWidth = 15;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        section.setClient((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(Messages.wizRemoteUserLabel);
        this.userName = new Text(composite, 2048);
        this.userName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.userName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ServerEditorConnectionSettingsSection.this.updating) {
                    return;
                }
                ServerEditorConnectionSettingsSection.this.updating = true;
                ServerEditorConnectionSettingsSection.this.execute((IUndoableOperation)new SetServerUserNameCommand(ServerEditorConnectionSettingsSection.this.wsServer, ServerEditorConnectionSettingsSection.this.userName.getText()));
                ServerEditorConnectionSettingsSection.this.updating = false;
                ServerEditorConnectionSettingsSection.this.validatePage();
            }
        });
        label = new Label(composite, 0);
        label = new Label(composite, 0);
        label.setText(Messages.wizRemotePasswordLabel);
        this.password = new Text(composite, 0x400800);
        this.password.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.password.setEchoChar('*');
        this.password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ServerEditorConnectionSettingsSection.this.updating) {
                    return;
                }
                ServerEditorConnectionSettingsSection.this.updating = true;
                ServerEditorConnectionSettingsSection.this.execute((IUndoableOperation)new SetServerPasswordCommand(ServerEditorConnectionSettingsSection.this.wsServer, ServerEditorConnectionSettingsSection.this.password.getText()));
                ServerEditorConnectionSettingsSection.this.updating = false;
                ServerEditorConnectionSettingsSection.this.validatePage();
            }
        });
        label = new Label(composite, 0);
        label = new Label(composite, 0);
        label.setText(Messages.wizRemotePortLabel);
        this.port = new Text(composite, 2048);
        this.port.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.port.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ServerEditorConnectionSettingsSection.this.updating) {
                    return;
                }
                ServerEditorConnectionSettingsSection.this.updating = true;
                ServerEditorConnectionSettingsSection.this.execute((IUndoableOperation)new SetServerPortCommand(ServerEditorConnectionSettingsSection.this.wsServer, ServerEditorConnectionSettingsSection.this.port.getText()));
                ServerEditorConnectionSettingsSection.this.updating = false;
                ServerEditorConnectionSettingsSection.this.validatePage();
            }
        });
        this.verifyButton = new Button(composite, 0);
        this.verifyButton.setText(Messages.wizRemoteConnect);
        this.verifyButton.setToolTipText(Messages.editorVerifyConnectTooltip);
        final Composite comp = composite;
        this.verifyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ServerEditorConnectionSettingsSection.this.validatePage();
                if (ServerEditorConnectionSettingsSection.this.getErrorMessage() != null) {
                    return;
                }
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IProgressMonitor mon;
                        block4: {
                            mon = monitor;
                            if (mon == null) {
                                mon = new NullProgressMonitor();
                            }
                            mon.beginTask(Messages.taskConnecting, 100);
                            mon.worked(10);
                            if (mon.isCanceled()) {
                                return;
                            }
                            mon.worked(10);
                            try {
                                JMXConnection connection = new JMXConnection(ServerEditorConnectionSettingsSection.this.wsServer.getConnectionHost(), ServerEditorConnectionSettingsSection.this.wsServer.getConnectionPort(), ServerEditorConnectionSettingsSection.this.wsServer.getServerUserName(), ServerEditorConnectionSettingsSection.this.wsServer.getTempServerConnectionPassword());
                                connection.connect();
                                ServerEditorConnectionSettingsSection.this.validity = STATE.COMPLETE;
                            }
                            catch (Exception e) {
                                ServerEditorConnectionSettingsSection.this.validity = STATE.CONNECTION_FAILED;
                                if (!Trace.ENABLED) break block4;
                                Trace.trace((byte)0, (String)"Failed to connect to the server", (Throwable)e);
                            }
                        }
                        mon.done();
                    }
                };
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(comp.getShell());
                try {
                    dialog.run(true, true, runnable);
                }
                catch (Exception ex) {
                    ServerEditorConnectionSettingsSection.this.validity = STATE.CONNECTION_FAILED;
                    Trace.logError((String)"An unexpected exception occured while connecting to the server", (Throwable)ex);
                }
                if (ServerEditorConnectionSettingsSection.this.validity.equals((Object)STATE.COMPLETE)) {
                    MessageDialog.openInformation((Shell)ServerEditorConnectionSettingsSection.this.getShell(), (String)Messages.editorVerifyConnection, (String)Messages.editorConnectionSuccessful);
                } else if (ServerEditorConnectionSettingsSection.this.validity.equals((Object)STATE.CONNECTION_FAILED) || ServerEditorConnectionSettingsSection.this.validity.equals((Object)STATE.NOT_STARTED)) {
                    MessageDialog.openError((Shell)ServerEditorConnectionSettingsSection.this.getShell(), (String)Messages.editorVerifyConnectionError, (String)com.ibm.ws.st.core.internal.Messages.remoteJMXConnectionFailure);
                }
            }
        });
        this.initialize();
    }

    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
        super.dispose();
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        if (this.server != null) {
            this.wsServer = (WebSphereServer)this.server.loadAdapter(WebSphereServer.class, null);
            if (input instanceof IServerEditorPartInput) {
                this.readOnly = ((IServerEditorPartInput)input).isServerReadOnly();
            }
        }
        this.addChangeListener();
        this.initialize();
    }

    protected void initialize() {
        if (this.userName == null || this.password == null || this.port == null || this.wsServer == null) {
            return;
        }
        this.updating = true;
        if (!this.wsServer.isLocalSetup()) {
            String serverConnectionPassword = this.wsServer.getServerPassword();
            this.password.setText(serverConnectionPassword);
            this.wsServer.setTempServerConnectionPassword(serverConnectionPassword);
            this.userName.setText(this.wsServer.getServerUserName());
            this.port.setText(this.wsServer.getServerSecurePort());
        } else {
            this.userName.setEnabled(false);
            this.password.setEnabled(false);
            this.port.setEnabled(false);
            this.verifyButton.setEnabled(false);
        }
        this.validatePage();
        this.updating = false;
    }

    protected void validatePage() {
        if (!this.wsServer.isLocalSetup()) {
            if (this.hostNameChanged) {
                this.password.setEnabled(true);
                this.userName.setEnabled(true);
                this.port.setEnabled(true);
                this.verifyButton.setEnabled(true);
            }
            if (this.userName.getText() == null || this.userName.getText().length() < 1) {
                this.setErrorMessage(Messages.editorConnectionInfoValidationError);
                this.verifyButton.setEnabled(false);
                return;
            }
            if (this.password.getText() == null || this.password.getText().length() < 1) {
                this.setErrorMessage(Messages.editorConnectionInfoValidationError);
                this.verifyButton.setEnabled(false);
                return;
            }
            try {
                if (this.port.getText() == null || this.port.getText().length() < 1 || Integer.parseInt(this.port.getText()) < 1) {
                    this.setErrorMessage(Messages.editorConnectionInfoValidationError);
                    this.verifyButton.setEnabled(false);
                    return;
                }
            }
            catch (NumberFormatException e) {
                this.setErrorMessage(NLS.bind((String)Messages.editorConnectionInfoPortValidationError, (Object)this.port.getText()));
                this.verifyButton.setEnabled(false);
                return;
            }
            this.hostNameChanged = false;
            this.verifyButton.setEnabled(true);
        } else {
            this.userName.setText("");
            this.password.setText("");
            this.port.setText("");
            this.password.setEnabled(false);
            this.userName.setEnabled(false);
            this.port.setEnabled(false);
            this.verifyButton.setEnabled(false);
        }
        this.setErrorMessage(null);
    }

    public IStatus[] getSaveStatus() {
        String errorMessage = this.getErrorMessage();
        Status[] status = null;
        if (errorMessage != null) {
            status = new Status[]{new Status(4, "com.ibm.ws.st.ui", errorMessage)};
        } else {
            this.wsServer.setServerPassword(this.password.getText());
        }
        return status;
    }

    protected static enum STATE {
        NOT_STARTED,
        COMPLETE,
        CONNECTION_FAILED;

    }
}

