/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SWTUtil {
    private static FontMetrics fontMetrics;

    protected static void initializeDialogUnits(Control testControl) {
        GC gc = new GC((Drawable)testControl);
        gc.setFont(JFaceResources.getDialogFont());
        fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    protected static int getButtonWidthHint(Button button) {
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static Button createButton(Composite comp, String label) {
        Button b = new Button(comp, 8);
        b.setText(label);
        if (fontMetrics == null) {
            SWTUtil.initializeDialogUnits((Control)comp);
        }
        GridData data = new GridData(0x1000000, 1, false, false);
        data.widthHint = SWTUtil.getButtonWidthHint(b);
        b.setLayoutData((Object)data);
        return b;
    }

    public static int convertHorizontalDLUsToPixels(Composite comp, int x) {
        if (fontMetrics == null) {
            SWTUtil.initializeDialogUnits((Control)comp);
        }
        return Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)x);
    }

    public static int convertVerticalDLUsToPixels(Composite comp, int y) {
        if (fontMetrics == null) {
            SWTUtil.initializeDialogUnits((Control)comp);
        }
        return Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)y);
    }

    public static int convertWidthInCharsToPixels(Composite comp, int y) {
        if (fontMetrics == null) {
            SWTUtil.initializeDialogUnits((Control)comp);
        }
        return Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String shortenText(Control control, String text, int min) {
        GC gc = new GC((Drawable)control);
        String shortenedText = text;
        try {
            Point size = new GC((Drawable)control).textExtent(text);
            int availSpace = control.getSize().x - control.getBorderWidth();
            if (size.x > availSpace) {
                float ratio = (float)availSpace / (float)size.x;
                int len = (int)Math.floor((float)text.length() * ratio);
                if (len >= min + 3) {
                    shortenedText = text.substring(0, len -= 3) + "...";
                }
            }
        }
        finally {
            gc.dispose();
        }
        return shortenedText;
    }

    public static String formatTooltip(String text, int maxLineLen) {
        StringBuilder s = new StringBuilder(text);
        StringBuilder sb = new StringBuilder();
        while (s.length() > maxLineLen) {
            int ind;
            for (ind = maxLineLen; ind > 0 && s.charAt(ind) != ' '; --ind) {
            }
            sb.append(s.substring(0, ind == 0 ? maxLineLen : ind));
            sb.append("\n");
            s.delete(0, ind == 0 ? maxLineLen : ind + 1);
        }
        sb.append((CharSequence)s);
        return sb.toString();
    }
}

