/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.core.internal.FeatureResolverWrapper;
import com.ibm.ws.st.core.internal.ProjectPrefs;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.config.FeatureList;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.config.FeatureUI;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class RequiredFeaturesPropertyPage
extends PropertyPage {
    protected IProject project;
    protected Label propertyPageDescriptionLabel;
    protected Table requiredFeaturesTable;
    protected ProjectPrefs prefs;

    protected void findFeatures(IProject project, WebSphereRuntime wr, IProgressMonitor monitor) {
        this.requiredFeaturesTable.removeAll();
        if (com.ibm.ws.st.core.internal.Activator.isAutomaticFeatureDetectionEnabled()) {
            TableItem[] items;
            this.propertyPageDescriptionLabel.setText(Messages.propertyPageFeatureRequired);
            this.requiredFeaturesTable.setVisible(true);
            List requiredFeatures2 = FeatureResolverWrapper.findFeatures((IProject)project, (WebSphereRuntime)wr, (boolean)false, (IProgressMonitor)monitor);
            for (String s : requiredFeatures2) {
                TableItem item = new TableItem(this.requiredFeaturesTable, 0);
                item.setText(0, s);
                String name = FeatureList.getFeatureDisplayName((String)s, (WebSphereRuntime)wr);
                if (name != null) {
                    item.setText(1, name);
                }
                item.setText(2, Messages.propertyPageFeatureAppRequired);
                if (FeatureList.isFeatureSuperseded((String)s, (WebSphereRuntime)wr)) {
                    item.setImage(Activator.getImage("featureSuperseded"));
                    continue;
                }
                item.setImage(Activator.getImage("featureElement"));
            }
            for (TableItem item : items = this.requiredFeaturesTable.getItems()) {
                TableEditor editor = new TableEditor(this.requiredFeaturesTable);
                final CCombo combo = new CCombo((Composite)this.requiredFeaturesTable, 0x800008);
                combo.setBackground(this.requiredFeaturesTable.getBackground());
                String[] s = new String[]{Messages.propertyPageFeatureAlways, Messages.propertyPageFeaturePrompt, Messages.propertyPageFeatureNever};
                combo.setItems(s);
                final String feature = item.getText(0);
                int b = this.prefs.getFeaturePrompt(feature);
                if (b == 0) {
                    combo.select(1);
                } else if (b == 2) {
                    combo.select(2);
                } else {
                    combo.select(0);
                }
                combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        int c = combo.getSelectionIndex();
                        if (c == 0) {
                            RequiredFeaturesPropertyPage.this.prefs.setFeaturePrompt(feature, (byte)1);
                        } else if (c == 1) {
                            RequiredFeaturesPropertyPage.this.prefs.setFeaturePrompt(feature, (byte)0);
                        } else if (c == 2) {
                            RequiredFeaturesPropertyPage.this.prefs.setFeaturePrompt(feature, (byte)2);
                        }
                    }
                });
                editor.grabHorizontal = true;
                editor.setEditor((Control)combo, item, 3);
            }
            FeatureUI.resizeColumns(this.requiredFeaturesTable);
        } else {
            this.propertyPageDescriptionLabel.setText(Messages.propertyPageFeatureRequiredDisabled);
            this.requiredFeaturesTable.setVisible(false);
        }
    }

    protected Control createContents(Composite parent) {
        try {
            IAdaptable element = this.getElement();
            this.project = (IProject)element.getAdapter(IProject.class);
            this.prefs = new ProjectPrefs(this.project);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            this.propertyPageDescriptionLabel = new Label(composite, 64);
            GridData data = new GridData(4, 0x1000000, true, false);
            data.horizontalSpan = 2;
            this.propertyPageDescriptionLabel.setLayoutData((Object)data);
            this.requiredFeaturesTable = new Table(composite, 68096);
            data = new GridData(4, 1, true, false);
            data.heightHint = 200;
            data.verticalSpan = 3;
            data.horizontalSpan = 2;
            this.requiredFeaturesTable.setLayoutData((Object)data);
            FeatureUI.createColumns(this.requiredFeaturesTable);
            final TableColumn statusColumn = new TableColumn(this.requiredFeaturesTable, 0);
            statusColumn.setText(Messages.propertyPageFeatureAppColumn);
            statusColumn.setResizable(true);
            statusColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FeatureUI.sortTable(RequiredFeaturesPropertyPage.this.requiredFeaturesTable, statusColumn);
                }
            });
            final TableColumn actionColumn = new TableColumn(this.requiredFeaturesTable, 0);
            actionColumn.setText(Messages.propertyPageFeatureActionColumn);
            actionColumn.setResizable(true);
            actionColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FeatureUI.sortTable(RequiredFeaturesPropertyPage.this.requiredFeaturesTable, actionColumn);
                }
            });
            this.init();
            Dialog.applyDialogFont((Control)composite);
            return composite;
        }
        catch (Exception e) {
            Trace.logError((String)"Error creating property page", (Throwable)e);
            return null;
        }
    }

    protected void init() {
        try {
            IRuntime runtime;
            WebSphereRuntime wr;
            IFacetedProject fp = ProjectFacetsManager.create((IProject)this.project);
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime rt = fp.getPrimaryRuntime();
            if (rt != null && (wr = (WebSphereRuntime)(runtime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)rt)).loadAdapter(WebSphereRuntime.class, null)) != null) {
                this.findFeatures(this.project, wr, null);
            }
        }
        catch (Exception e) {
            Trace.logError((String)"Error initializing property page", (Throwable)e);
        }
    }

    protected void performDefaults() {
        this.init();
    }

    protected boolean save() {
        return this.prefs.save();
    }

    protected void performApply() {
        this.save();
    }

    public boolean performOk() {
        return this.save();
    }
}

