/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.ui.internal.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class PublishWithErrorDialog
extends MessageDialogWithToggle {
    private final ArrayList<String> projectNames;
    protected Table projectTable;

    public PublishWithErrorDialog(Shell parentShell, ArrayList<String> projectNames) {
        super(parentShell, Messages.publishWithErrorsDialogTitle, null, Messages.publishWithErrorMessage, 4, new String[0], 1, Messages.publishWithErrorToggle, false);
        this.projectNames = projectNames;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button OK = this.createButton(parent, 0, Messages.publishWarningOKButton, true);
        Button Cancel = this.createButton(parent, -1, Messages.publishWarningCancelButton, false);
        super.createButtonsForButtonBar(parent);
    }

    public Control createCustomArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 7;
        comp.setLayout((Layout)layout);
        StyledText descriptionText = new StyledText(comp, 2634);
        GridData data = new GridData(1808);
        data.heightHint = 100;
        descriptionText.setTopMargin(3);
        descriptionText.setLeftMargin(5);
        descriptionText.setRightMargin(5);
        descriptionText.setAlwaysShowScrollBars(false);
        descriptionText.setLayoutData((Object)data);
        descriptionText.setText(this.getProjectListAsString(this.projectNames));
        descriptionText.setEditable(false);
        Label warning = new Label(comp, 0);
        data = new GridData(4, 4, true, true);
        data.verticalIndent = 8;
        warning.setLayoutData((Object)data);
        warning.setText(Messages.publishWithErrorUserMessage);
        return parent;
    }

    private String getProjectListAsString(ArrayList<String> projectNames) {
        if (projectNames == null || projectNames.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Iterator<String> iter = projectNames.iterator();
        while (iter.hasNext()) {
            result.append(iter.next());
            if (!iter.hasNext()) continue;
            result.append("\n");
        }
        return result.toString();
    }
}

