/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;

public class ProductInfoPropertyPage
extends PropertyPage {
    public ProductInfoPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        try {
            IAdaptable element = this.getElement();
            IRuntime runtime = null;
            IServer server = (IServer)element.getAdapter(IServer.class);
            runtime = server != null ? server.getRuntime() : (IRuntime)element.getAdapter(IRuntime.class);
            WebSphereRuntime wsRuntime = null;
            if (runtime != null) {
                wsRuntime = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
            }
            final Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 1;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            final Label progressLabel = new Label(composite, 0);
            progressLabel.setText(com.ibm.ws.st.core.internal.Messages.taskProductInfo);
            progressLabel.setLayoutData((Object)new GridData(4, 3, true, true));
            final ProgressIndicator progress = new ProgressIndicator(composite);
            progress.setLayoutData((Object)new GridData(4, 3, true, false));
            Dialog.applyDialogFont((Control)composite);
            if (wsRuntime == null) {
                Label label = new Label(composite, 8);
                label.setLayoutData((Object)new GridData(4, 1, true, false));
                label.setText(Messages.productInfoUnavailable);
                progressLabel.dispose();
                progress.dispose();
            } else {
                final Display display = this.getShell().getDisplay();
                final WebSphereRuntime wsRuntime2 = wsRuntime;
                Thread t = new Thread("Liberty product info"){

                    @Override
                    public void run() {
                        NullProgressMonitor monitor = new NullProgressMonitor(){

                            public void beginTask(String name, final int max) {
                                display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        progress.beginTask(max);
                                    }
                                });
                            }

                            public void internalWorked(final double work) {
                                display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        progress.worked(work);
                                    }
                                });
                            }
                        };
                        monitor.beginTask(com.ibm.ws.st.core.internal.Messages.taskProductInfo, 200);
                        final int[] indent = new int[1];
                        try {
                            final String version = wsRuntime2.getProductInfo("version", (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 100));
                            display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Text versionText = new Text(composite, 72);
                                    versionText.setForeground(composite.getForeground());
                                    versionText.setBackground(composite.getBackground());
                                    versionText.setText(version);
                                    GridData data = new GridData(4, 1, true, false);
                                    versionText.setLayoutData((Object)data);
                                    versionText.moveAbove((Control)progressLabel);
                                    composite.layout(true);
                                    indent[0] = Math.abs(versionText.computeTrim((int)0, (int)0, (int)100, (int)100).x);
                                }
                            });
                        }
                        catch (Exception e) {
                            display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Label label = new Label(composite, 8);
                                    label.setLayoutData((Object)new GridData(4, 1, true, false));
                                    label.setText(Messages.productInfoUnavailable);
                                }
                            });
                        }
                        String featureInfo = null;
                        try {
                            featureInfo = wsRuntime2.getProductInfo("featureInfo", (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 100));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        monitor.done();
                        final String featureInfo2 = featureInfo;
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                progressLabel.dispose();
                                progress.dispose();
                                Label featureInfoLabel = new Label(composite, 0);
                                featureInfoLabel.setText(Messages.productInfoFeatures);
                                GridData data = new GridData(4, 1, true, false);
                                data.verticalIndent = 10;
                                data.horizontalIndent = indent[0];
                                featureInfoLabel.setLayoutData((Object)data);
                                FontData[] fontData = featureInfoLabel.getFont().getFontData();
                                for (int i = 0; i < fontData.length; ++i) {
                                    fontData[i].setStyle(1);
                                }
                                final Font font = new Font((Device)featureInfoLabel.getDisplay(), fontData);
                                featureInfoLabel.setFont(font);
                                featureInfoLabel.addDisposeListener(new DisposeListener(){

                                    public void widgetDisposed(DisposeEvent e) {
                                        font.dispose();
                                    }
                                });
                                if (featureInfo2 == null) {
                                    Label label = new Label(composite, 8);
                                    label.setText(Messages.productInfoUnavailable);
                                    data = new GridData(4, 1, true, false);
                                    data.horizontalIndent = 15;
                                    label.setLayoutData((Object)data);
                                } else {
                                    Text featureInfoText = new Text(composite, 584);
                                    featureInfoText.setForeground(composite.getForeground());
                                    featureInfoText.setBackground(composite.getBackground());
                                    featureInfoText.setText(featureInfo2);
                                    featureInfoText.setLayoutData((Object)new GridData(4, 4, true, true));
                                }
                                composite.layout(true);
                            }
                        });
                    }
                };
                t.setDaemon(true);
                t.start();
            }
            return composite;
        }
        catch (Exception e) {
            Trace.logError("Error creating product info property page", e);
            return null;
        }
    }
}

