/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class NewConfigFileWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection selection;
    private NewConfigFilePage mainPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle(Messages.wizNewConfigFileTitle);
    }

    public void addPages() {
        this.mainPage = new NewConfigFilePage(this.selection);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        return this.mainPage.finish();
    }

    private static class NewConfigFilePage
    extends WizardNewFileCreationPage {
        public NewConfigFilePage(IStructuredSelection selection) {
            super("NewConfigFilePage", selection);
            this.setTitle(Messages.wizNewConfigFilePageTitle);
            this.setDescription(Messages.wizNewConfigFilePageDesc);
            this.setFileExtension("xml");
            this.setAppropriatePath(selection);
        }

        protected InputStream getInitialContents() {
            return new ByteArrayInputStream("<server>\n    \n</server>".getBytes());
        }

        public boolean finish() {
            IFile newFile = this.createNewFile();
            if (newFile == null) {
                return false;
            }
            Activator.openConfigurationEditor(newFile, newFile.getLocation().toFile().toURI());
            return true;
        }

        private void setAppropriatePath(IStructuredSelection selection) {
            Object obj = selection.getFirstElement();
            if (obj instanceof IProject) {
                WebSphereServerInfo[] servers;
                IProject project = (IProject)obj;
                for (WebSphereServerInfo server : servers = WebSphereUtil.getWebSphereServerInfos()) {
                    IFolder folder = server.getServerFolder();
                    if (folder != null && folder.exists() && folder.getProject().equals(project)) {
                        this.setContainerFullPath(folder.getFullPath());
                        return;
                    }
                    folder = server.getUserDirectory().getSharedConfigFolder();
                    if (folder == null || !folder.exists() || !folder.getProject().equals(project)) continue;
                    this.setContainerFullPath(folder.getFullPath());
                    return;
                }
            }
        }
    }
}

