/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.ui.internal.ConsoleLineTracker;
import com.ibm.ws.st.ui.internal.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.widgets.Display;

public class HTTPHandler {
    private static final int BUFFER = 2048;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static AtomicInteger COUNTER = new AtomicInteger(0);
    private final int count = COUNTER.getAndIncrement();
    private final byte[] readBuffer = new byte[2048];
    private byte[] buffer = new byte[0];
    private int bufferIndex = 0;
    private final InputStream in;
    private final String hash;
    private int contentLength = -1;
    private byte transferEncoding = (byte)-1;
    private static final String[] ENCODING_STRING = new String[]{"chunked", "identity", "gzip", "compressed", "deflate"};
    private static final byte ENCODING_IDENTITY = 1;

    public HTTPHandler(InputStream in, int hash) {
        this.in = in;
        this.hash = hash + "";
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Started: " + this);
        }
    }

    private void fillBuffer() throws IOException {
        int n = this.in.read(this.readBuffer);
        if (n <= 0) {
            throw new IOException("End of input");
        }
        int len = this.buffer.length - this.bufferIndex;
        if (len < 0) {
            len = 0;
        }
        byte[] x = new byte[n + len];
        System.arraycopy(this.buffer, this.bufferIndex, x, 0, len);
        System.arraycopy(this.readBuffer, 0, x, len, n);
        this.bufferIndex = 0;
        this.buffer = x;
    }

    private int getFirstCRLF() {
        int size = this.buffer.length;
        for (int i = this.bufferIndex + 1; i < size; ++i) {
            if (this.buffer[i - 1] != 13 || this.buffer[i] != 10) continue;
            return i;
        }
        return -1;
    }

    private void parseBody() throws IOException {
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Parsing body for: " + this);
        }
        if (this.contentLength != -1) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Parsing body");
            }
            byte[] b2 = null;
            int b2Index = 0;
            if (this.contentLength < 0x100000) {
                b2 = new byte[this.contentLength];
            }
            byte[] b = this.removeFromBuffer(Math.min(this.buffer.length, this.bufferIndex + this.contentLength));
            if (b2 != null) {
                System.arraycopy(b, 0, b2, 0, b.length);
                b2Index += b.length;
            }
            int n = 0;
            for (int bytesLeft = this.contentLength - b.length; bytesLeft > 0; bytesLeft -= n) {
                n = this.in.read(this.readBuffer, 0, Math.min(this.readBuffer.length, bytesLeft));
                if (b2 == null) continue;
                System.arraycopy(this.readBuffer, 0, b2, b2Index, n);
                b2Index += n;
            }
            if (b2 != null) {
                this.openEditor(new String(b2));
            }
        } else if (this.transferEncoding != -1 && this.transferEncoding != 1) {
            this.parseChunk();
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Done parsing body for: " + this);
        }
    }

    private void parseChunk() throws IOException {
        byte[] b;
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Parsing chunk");
        }
        boolean done = false;
        byte[] body = new byte[]{};
        while (!done) {
            int length;
            block8: {
                b = this.readLine();
                String s = new String(b);
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "Chunk-length: " + s);
                }
                int index = s.indexOf(" ");
                length = -1;
                try {
                    if (index > 0) {
                        s = s.substring(0, index);
                    }
                    length = Integer.parseInt(s.trim(), 16);
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block8;
                    Trace.trace((byte)0, "Error chunk for: " + this, e);
                }
            }
            if (length <= 0) {
                done = true;
                continue;
            }
            b = this.readBytes(length + 2);
            byte[] temp = new byte[body.length + b.length - 2];
            System.arraycopy(body, 0, temp, 0, body.length);
            System.arraycopy(b, 0, temp, body.length, b.length - 2);
            body = temp;
        }
        b = this.readLine();
        while (b.length > 2) {
            b = this.readLine();
        }
        this.openEditor(new String(body));
    }

    private void parseHeader() throws IOException {
        String s;
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Parsing header for: " + this);
        }
        byte[] b = this.readLine();
        boolean first = true;
        while (b.length > 5) {
            s = new String(b);
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Header: " + HTTPHandler.traceBytes(s));
            }
            if (first) {
                int index = s.indexOf(" ");
                if (index >= 0) {
                    String t = s.substring(index + 1);
                    index = t.indexOf(" ");
                    if ((t = t.substring(0, index)).startsWith("/" + this.hash + "/")) {
                        t = t.substring(2 + this.hash.length());
                        this.openEditor(t);
                    }
                }
                first = false;
            }
            this.parseHeaderLine(s);
            b = this.readLine();
        }
        if (Trace.ENABLED) {
            s = new String(b);
            Trace.trace((byte)0, "Final header: " + HTTPHandler.traceBytes(s));
        }
    }

    private static String traceBytes(String s) {
        String t = s.replace("\n", "/n");
        t = t.replace("\r", "/r");
        return t;
    }

    private byte[] readBytes(int n) throws IOException {
        while (this.buffer.length - this.bufferIndex < n) {
            this.fillBuffer();
        }
        return this.removeFromBuffer(this.bufferIndex + n);
    }

    private byte[] readLine() throws IOException {
        int n = this.getFirstCRLF();
        while (n < 0) {
            this.fillBuffer();
            n = this.getFirstCRLF();
        }
        return this.removeFromBuffer(n + 1);
    }

    private byte[] removeFromBuffer(int n) {
        byte[] b = new byte[n - this.bufferIndex];
        System.arraycopy(this.buffer, this.bufferIndex, b, 0, n - this.bufferIndex);
        if (this.buffer.length > 4096 || this.bufferIndex > 2048) {
            int size = this.buffer.length;
            byte[] x = new byte[size - n];
            System.arraycopy(this.buffer, n, x, 0, size - n);
            this.buffer = x;
            this.bufferIndex = 0;
        } else {
            this.bufferIndex = n;
        }
        return b;
    }

    public void parse() {
        block3: {
            try {
                this.contentLength = -1;
                this.transferEncoding = (byte)-1;
                this.parseHeader();
                this.parseBody();
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "Done HTTP request for " + this);
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block3;
                Trace.trace((byte)0, "Error in: " + this, e);
            }
        }
    }

    private void parseHeaderLine(String s) {
        block7: {
            if (s.toLowerCase().startsWith("content-length: ")) {
                try {
                    this.contentLength = Integer.parseInt(s.substring(16).trim());
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "Content length: " + this + " " + this.contentLength);
                    }
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block7;
                    Trace.trace((byte)0, "Content length error", e);
                }
            } else if (s.toLowerCase().startsWith("transfer-encoding: ")) {
                String t = s.substring(19).trim();
                int size = ENCODING_STRING.length;
                for (int i = 0; i < size; ++i) {
                    if (!ENCODING_STRING[i].equalsIgnoreCase(t)) continue;
                    this.transferEncoding = (byte)i;
                    if (!Trace.ENABLED) continue;
                    Trace.trace((byte)0, "Transfer encoding: " + ENCODING_STRING[i]);
                }
            }
        }
    }

    private void openEditor(final String s) {
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Opening Java editor on: " + s);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConsoleLineTracker.openJavaEditor(s);
            }
        });
    }

    public String toString() {
        return "HTTPHandler " + this.count;
    }
}

