/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.ui.internal.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public class DomXmlDocumentFileCache {
    private static final DomXmlDocumentFileCache instance = new DomXmlDocumentFileCache();
    private final Object mapLock = new Object();
    Map<File, DomXmlCacheEntry> map = new HashMap<File, DomXmlCacheEntry>();

    private DomXmlDocumentFileCache() {
    }

    public static DomXmlDocumentFileCache getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileIntoString(File f) throws IOException {
        try (BufferedReader br = null;){
            String str;
            StringBuilder sb = new StringBuilder();
            br = new BufferedReader(new FileReader(f));
            while (null != (str = br.readLine())) {
                sb.append(str + "\n");
            }
            String string = sb.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocument(ConfigurationFile cf) throws IOException {
        DomXmlCacheEntry e;
        File f = new File(cf.getURI());
        if (!f.exists() || !f.canRead()) {
            return DomXmlDocumentFileCache.parseDomDocument(cf);
        }
        String fileContents = DomXmlDocumentFileCache.readFileIntoString(f);
        Object object = this.mapLock;
        synchronized (object) {
            e = this.map.get(f);
            boolean createNew = false;
            if (e != null) {
                if (e.document != null && e.document.get() != null && e.fileContents != null && e.fileContents.get() != null && e.fileContents.get().equalsIgnoreCase(fileContents)) {
                    createNew = false;
                } else {
                    this.map.remove(f);
                    createNew = true;
                }
            } else {
                createNew = true;
            }
            if (createNew) {
                e = new DomXmlCacheEntry();
                e.fileContents = new SoftReference<String>(fileContents);
                e.document = new SoftReference<Document>(DomXmlDocumentFileCache.parseDomDocument(cf));
                this.map.put(f, e);
            }
        }
        if (e != null) {
            return e.document.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document parseDomDocument(ConfigurationFile configFile) {
        InputStream in = null;
        IDOMModel dom = null;
        URI uri = configFile.getURI();
        IModelManager manager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        try {
            in = new BufferedInputStream(new FileInputStream(new File(uri)));
            model = manager.getModelForRead(new File(uri).getAbsolutePath(), in, null);
            if (model == null || !(model instanceof IDOMModel)) {
                Trace.logError("Unable to load IDOM Model from uri: " + uri, null);
                Document document = null;
                return document;
            }
        }
        catch (Exception e) {
            Trace.logError("Error loading IDOM Model from uri: " + uri, e);
            Document document = null;
            return document;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        dom = (IDOMModel)model;
        IDOMDocument domDocument = dom.getDocument();
        domDocument.setUserData("uri", (Object)uri.toString(), null);
        domDocument.setUserData("userDirectory", (Object)configFile.getUserDirectory(), null);
        IDOMDocument iDOMDocument = domDocument;
        return iDOMDocument;
        finally {
            if (dom != null) {
                dom.releaseFromRead();
            }
        }
    }

    class DomXmlCacheEntry {
        SoftReference<String> fileContents;
        SoftReference<Document> document;

        DomXmlCacheEntry() {
        }
    }
}

