/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.core.internal.IWebSphereServerListener;
import com.ibm.ws.st.core.internal.ServerListenerUtil;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.Bootstrap;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigurationDropinsFolder;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.ConfigurationFolder;
import com.ibm.ws.st.core.internal.config.ExtendedConfigFile;
import com.ibm.ws.st.core.internal.config.IConfigurationElement;
import com.ibm.ws.st.ui.internal.CustomServerConfigTreeNode;
import com.ibm.ws.st.ui.internal.DomXmlDocumentFileCache;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.RuntimeExplorer;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.custom.CustomServerConfigManager;
import com.ibm.xwt.dde.internal.customization.CustomizationManager;
import com.ibm.xwt.dde.internal.viewers.TreeContentProvider;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.util.RuntimeLifecycleAdapter;
import org.eclipse.wst.server.core.util.ServerLifecycleAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DDETreeContentProvider
extends TreeContentProvider {
    private static final String DDE_CUSTOMIZATION = "com.ibm.ws.st.ui.configuration.editor";
    private static final String SERVERS_VIEW_ID = "org.eclipse.wst.server.ui.ServersView";
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected CommonViewer commonViewer;
    protected RuntimeLifecycleAdapter runtimeListener;
    protected ServerLifecycleAdapter serverListener;
    protected IWebSphereServerListener listener;

    public DDETreeContentProvider() {
        super(DDETreeContentProvider.getCustomization());
    }

    public static CustomizationManager.Customization getCustomization() {
        return CustomizationManager.getInstance().getCustomization(DDE_CUSTOMIZATION);
    }

    protected static boolean checkType(IRuntime runtime) {
        return WebSphereUtil.isWebSphereRuntime((IRuntime)runtime);
    }

    protected static boolean checkType(IServer server) {
        IServerType type = server.getServerType();
        return type != null && type.getId().startsWith("com.ibm.ws.st.server");
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (!(viewer instanceof CommonViewer)) {
            return;
        }
        this.commonViewer = (CommonViewer)viewer;
        if (this.listener == null) {
            this.listener = new IWebSphereServerListener(){

                public void serverChanged(WebSphereServerInfo server) {
                    DDETreeContentProvider.this.refresh(server);
                }

                public void runtimeChanged(IRuntime runtime) {
                    DDETreeContentProvider.this.refresh(runtime);
                }
            };
            ServerListenerUtil.getInstance().addServerListener(this.listener);
        }
        if (this.runtimeListener == null) {
            this.runtimeListener = new RuntimeLifecycleAdapter(){

                public void runtimeAdded(IRuntime runtime) {
                    if (DDETreeContentProvider.checkType(runtime)) {
                        DDETreeContentProvider.this.add(runtime);
                    }
                }

                public void runtimeChanged(IRuntime runtime) {
                    if (DDETreeContentProvider.checkType(runtime)) {
                        DDETreeContentProvider.this.refresh(runtime);
                    }
                }

                public void runtimeRemoved(IRuntime runtime) {
                    if (DDETreeContentProvider.checkType(runtime)) {
                        DDETreeContentProvider.this.remove(runtime);
                    }
                }
            };
            ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)this.runtimeListener);
        }
        if (this.serverListener == null) {
            this.serverListener = new ServerLifecycleAdapter(){

                public void serverAdded(IServer server) {
                    WebSphereServer ws;
                    if (DDETreeContentProvider.checkType(server) && (ws = (WebSphereServer)server.loadAdapter(WebSphereServer.class, null)) != null) {
                        DDETreeContentProvider.this.refresh(ws.getServerInfo());
                    }
                }

                public void serverChanged(IServer server) {
                    WebSphereServer ws;
                    if (DDETreeContentProvider.checkType(server) && (ws = (WebSphereServer)server.loadAdapter(WebSphereServer.class, null)) != null) {
                        DDETreeContentProvider.this.refresh(ws.getServerInfo());
                    }
                }

                public void serverRemoved(IServer server) {
                    WebSphereServer ws;
                    if (DDETreeContentProvider.checkType(server) && (ws = (WebSphereServer)server.loadAdapter(WebSphereServer.class, null)) != null) {
                        DDETreeContentProvider.this.refresh(ws.getServerInfo());
                    }
                }
            };
            ServerCore.addServerLifecycleListener((IServerLifecycleListener)this.serverListener);
        }
    }

    protected void add(IRuntime runtime) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DDETreeContentProvider.this.commonViewer != null) {
                    DDETreeContentProvider.this.commonViewer.refresh(DDETreeContentProvider.this.commonViewer.getInput());
                }
            }
        });
    }

    protected void refresh(final IRuntime runtime) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DDETreeContentProvider.this.commonViewer != null) {
                    if (DDETreeContentProvider.SERVERS_VIEW_ID.equals(DDETreeContentProvider.this.commonViewer.getCommonNavigator().getViewSite().getId())) {
                        DDETreeContentProvider.this.commonViewer.refresh(true);
                    } else {
                        DDETreeContentProvider.this.commonViewer.refresh((Object)runtime, true);
                    }
                }
            }
        });
    }

    protected void remove(final IRuntime runtime) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DDETreeContentProvider.this.commonViewer != null) {
                    DDETreeContentProvider.this.commonViewer.remove((Object)runtime);
                }
            }
        });
    }

    protected void refresh(final IServer server) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DDETreeContentProvider.this.commonViewer != null) {
                    DDETreeContentProvider.this.commonViewer.refresh((Object)server, true);
                    WebSphereServer ws = (WebSphereServer)server.loadAdapter(WebSphereServer.class, null);
                    DDETreeContentProvider.this.commonViewer.refresh((Object)ws.getServerInfo(), true);
                }
            }
        });
    }

    protected void refresh(final WebSphereServerInfo serverInfo) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DDETreeContentProvider.this.commonViewer != null) {
                    DDETreeContentProvider.this.commonViewer.refresh((Object)serverInfo, true);
                    WebSphereServer ws = WebSphereUtil.getWebSphereServer((WebSphereServerInfo)serverInfo);
                    if (ws != null) {
                        IServer server = ws.getServer();
                        if (server.isWorkingCopy()) {
                            IServerWorkingCopy wc = (IServerWorkingCopy)server;
                            server = wc.getOriginal();
                        }
                        DDETreeContentProvider.this.commonViewer.refresh((Object)server, true);
                    }
                }
            }
        });
    }

    public void dispose() {
        this.commonViewer = null;
        ServerListenerUtil.getInstance().removeServerListener(this.listener);
        ServerCore.removeRuntimeLifecycleListener((IRuntimeLifecycleListener)this.runtimeListener);
        ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this.serverListener);
        super.dispose();
    }

    protected static URI getURI(Document document) {
        try {
            String userDataURI = (String)document.getUserData("uri");
            if (userDataURI == null) {
                return null;
            }
            return new URI(userDataURI);
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Error getting URI from document", e);
            }
            return null;
        }
    }

    public static URI getURI(Element element) {
        return DDETreeContentProvider.getURI(element.getOwnerDocument());
    }

    private static UserDirectory getUserDirectory(Document document) {
        return (UserDirectory)document.getUserData("userDirectory");
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof String) {
            return new Object[]{inputElement};
        }
        Object[] children = this.getChildren(inputElement);
        if (children != null && children.length == 0 && inputElement instanceof Element) {
            return new Object[]{Messages.configEmpty};
        }
        return children;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children;
        NamedNodeMap nnm;
        Node attrNode;
        Element element;
        IServer server;
        if (parentElement instanceof IServer) {
            server = (IServer)parentElement;
            WebSphereServer ws = (WebSphereServer)server.loadAdapter(WebSphereServer.class, null);
            try {
                ArrayList<Object> list = new ArrayList<Object>();
                CustomServerConfigManager customServerConfigManager = CustomServerConfigManager.getInstance();
                List<Object> customServerElements = customServerConfigManager.getCustomServerElements(server);
                if (customServerElements != null && customServerElements.size() > 0) {
                    list.addAll(customServerElements);
                } else {
                    WebSphereServerInfo wsServer;
                    Document document;
                    ConfigurationFile configFile = ws.getConfiguration();
                    if (configFile != null && (document = DomXmlDocumentFileCache.getInstance().getDocument(configFile)) != null) {
                        list.add(document.getDocumentElement());
                    }
                    if ((wsServer = ws.getServerInfo()) != null) {
                        ConfigurationDropinsFolder dropinsFolder;
                        ExtendedConfigFile jvmOptions;
                        Bootstrap config = wsServer.getBootstrap();
                        if (config != null) {
                            list.add(config);
                        }
                        if ((jvmOptions = wsServer.getJVMOptions(wsServer.getServerPath())) != null) {
                            list.add(jvmOptions);
                        }
                        if ((config = wsServer.getServerEnv()) != null) {
                            list.add(config);
                        }
                        if ((dropinsFolder = wsServer.getConfigurationDropinsFolder()) != null) {
                            list.add(dropinsFolder);
                        }
                    }
                }
                return list.toArray();
            }
            catch (Exception e) {
                Trace.logError("Error while trying to load config tree for server: " + server.getName(), e);
            }
        }
        if (parentElement instanceof Element && "include".equals((element = (Element)parentElement).getNodeName()) && (attrNode = (nnm = element.getAttributes()).getNamedItem("location")) != null) {
            String include = attrNode.getNodeValue();
            Document document = element.getOwnerDocument();
            URI baseUri = DDETreeContentProvider.getURI(document);
            UserDirectory userDir = DDETreeContentProvider.getUserDirectory(document);
            if (userDir != null) {
                IResource includeFile;
                IFolder mappedConfigFolder;
                URI includeURI = null;
                IFile configIFile = ConfigUtils.getMappedConfigIFile((URI)baseUri);
                if (configIFile != null && (mappedConfigFolder = ConfigUtils.getMappedConfigFolder((IResource)configIFile.getProject())) != null && (includeFile = mappedConfigFolder.findMember(include)) != null) {
                    includeURI = includeFile.getLocationURI();
                }
                if (includeURI == null) {
                    includeURI = ConfigUtils.resolve((URI)baseUri, (String)include, (UserDirectory)userDir);
                }
                if (includeURI == null) {
                    return NO_CHILDREN;
                }
                try {
                    ConfigurationFile configFile = new ConfigurationFile(includeURI, userDir);
                    Document document2 = configFile.getDomDocument();
                    if (document2 != null) {
                        return super.getChildren((Object)document2.getDocumentElement());
                    }
                }
                catch (Exception e) {
                    Trace.logError("Error while trying to load config tree for include file with uri: " + includeURI, e);
                }
            }
        }
        if (parentElement instanceof IRuntime) {
            IRuntime runtime = (IRuntime)parentElement;
            WebSphereRuntime wr = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
            if (wr == null) {
                return NO_CHILDREN;
            }
            List userDirs = wr.getUserDirectories();
            if (userDirs == null || userDirs.isEmpty()) {
                return NO_CHILDREN;
            }
            if (userDirs.size() == 1) {
                UserDirectory userDir = (UserDirectory)userDirs.get(0);
                return new Object[]{new RuntimeExplorer.Node(userDir, RuntimeExplorer.NodeType.SERVERS), new RuntimeExplorer.Node(userDir, RuntimeExplorer.NodeType.SHARED_CONFIGURATIONS)};
            }
            return userDirs.toArray();
        }
        if (parentElement instanceof UserDirectory) {
            UserDirectory userDir = (UserDirectory)parentElement;
            return new Object[]{new RuntimeExplorer.Node(userDir, RuntimeExplorer.NodeType.SERVERS), new RuntimeExplorer.Node(userDir, RuntimeExplorer.NodeType.SHARED_CONFIGURATIONS)};
        }
        if (parentElement instanceof RuntimeExplorer.Node) {
            RuntimeExplorer.Node node = (RuntimeExplorer.Node)parentElement;
            return node.getChildren();
        }
        if (parentElement instanceof WebSphereServerInfo) {
            ConfigurationDropinsFolder dropinsFolder;
            ExtendedConfigFile jvmOptions;
            server = (WebSphereServerInfo)parentElement;
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(server.getConfigRoot());
            Bootstrap config = server.getBootstrap();
            if (config != null) {
                list.add(config);
            }
            if ((jvmOptions = server.getJVMOptions(server.getServerPath())) != null) {
                list.add(jvmOptions);
            }
            if ((config = server.getServerEnv()) != null) {
                list.add(config);
            }
            if ((dropinsFolder = server.getConfigurationDropinsFolder()) != null) {
                list.add(dropinsFolder);
            }
            return list.toArray();
        }
        if (parentElement instanceof ConfigurationFolder) {
            return this.getConfigurationFolderChildren(parentElement);
        }
        if (parentElement instanceof ConfigurationFile) {
            ConfigurationFile configFile = (ConfigurationFile)parentElement;
            Document document2 = configFile.getDomDocument();
            Element node = document2.getDocumentElement();
            return this.getChildren(node);
        }
        if (parentElement instanceof CustomServerConfigTreeNode) {
            children = ((CustomServerConfigTreeNode)parentElement).getChildren();
            return children.toArray(new Object[children.size()]);
        }
        children = super.getChildren(parentElement);
        if (children != null && children.length == 0 && parentElement instanceof Element && "server".equals(((Element)parentElement).getNodeName())) {
            return new Object[]{Messages.configEmpty};
        }
        return children;
    }

    public Object getParent(Object element) {
        if (element instanceof RuntimeExplorer.Node) {
            return ((RuntimeExplorer.Node)element).getParent();
        }
        if (element instanceof WebSphereServerInfo) {
            return ((WebSphereServerInfo)element).getUserDirectory();
        }
        return super.getParent(element);
    }

    public Object[] getConfigurationFolderChildren(Object parent) {
        ExtendedConfigFile jvmOptions;
        ConfigurationFolder folder = (ConfigurationFolder)parent;
        String name = folder.getPath().lastSegment();
        if (name.equals("configDropins")) {
            return folder.getChildren();
        }
        ArrayList<Object> configFolderChildren = new ArrayList<Object>();
        for (IConfigurationElement configElement : folder.getChildren()) {
            configFolderChildren.add(configElement);
        }
        List servers = folder.getUserDirectory().getWebSphereRuntime().getWebSphereServerInfos();
        WebSphereServerInfo configServer = null;
        IPath currConfigDropinsSubFolderPath = null;
        for (WebSphereServerInfo currServer : servers) {
            IPath currConfigOverrideDropinsPath = currServer.getConfigOverrideDropinsPath();
            IPath currConfigDefaultDropinsPath = currServer.getConfigDefaultDropinsPath();
            if (currConfigOverrideDropinsPath != null && currConfigOverrideDropinsPath.equals((Object)folder.getPath())) {
                currConfigDropinsSubFolderPath = currConfigOverrideDropinsPath;
                configServer = currServer;
                break;
            }
            if (currConfigDefaultDropinsPath == null || !currConfigDefaultDropinsPath.equals((Object)folder.getPath())) continue;
            currConfigDropinsSubFolderPath = currConfigDefaultDropinsPath;
            configServer = currServer;
            break;
        }
        if (configServer != null && currConfigDropinsSubFolderPath != null && (jvmOptions = configServer.getJVMOptions(currConfigDropinsSubFolderPath)) != null) {
            configFolderChildren.add(jvmOptions);
        }
        return configFolderChildren.toArray();
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IServer) {
            return true;
        }
        if (element instanceof IRuntime) {
            return true;
        }
        if (element instanceof UserDirectory) {
            return true;
        }
        if (element instanceof RuntimeExplorer.Node) {
            Object[] obj = ((RuntimeExplorer.Node)element).getChildren();
            return obj != null && obj.length > 0;
        }
        if (element instanceof WebSphereServerInfo) {
            Object[] obj = this.getChildren(element);
            return obj != null && obj.length > 0;
        }
        if (element instanceof ConfigurationFolder) {
            return this.getConfigurationFolderChildren(element).length > 0;
        }
        if (element instanceof ConfigurationFile) {
            return true;
        }
        return super.hasChildren(element);
    }
}

