/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.common.core.ext.internal.servertype.AbstractServerExtension;
import com.ibm.ws.st.common.core.ext.internal.servertype.ServerTypeExtensionFactory;
import com.ibm.ws.st.core.internal.ConsoleLineTrackerHelper;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import java.io.File;
import java.io.FileWriter;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class ConsoleLineTracker
implements IConsoleLineTracker {
    private static final String SERVLET_ERROR = "[ERROR   ] SRVE0777E";
    private static final String JSP_WARNING = "[WARNING ] SRVE0269W: ";
    private static final String JNDI_INJECT_ERROR = "[ERROR   ] CWNEN0030E:";
    private static final String JNDI_NO_INITIAL_CONTEXT_EXCEPTION = "javax.naming.NoInitialContextException:";
    private static final String COLD_START_ERROR = "[ERROR   ] CWWKE0040E: ";
    private static final String WEB_APP_ADD = "[AUDIT   ] CWWKT0016I: ";
    private static final String WEB_APP_REMOVE = "[AUDIT   ] CWWKT0017I: ";
    private static final String HTTP_WHITEBOARD_ADD = "[AUDIT   ] CWWKN2000A: ";
    private static final String OSGI_APPCONSOLE_ADD = "[AUDIT   ] CWWKN2050A: ";
    private static final String OSGI_APPCONSOLE_REMOVE = "[AUDIT   ] CWWKN2051A: ";
    private static final String HTTP_WHITEBOARD_REMOVE = "[AUDIT   ] CWWKN2001A: ";
    private static final String CONFIG_DROPINS_ADD = "[AUDIT   ] CWWKG0093A: ";
    private static final String INCLUDES_ADD = "[AUDIT   ] CWWKG0028A: ";
    private static final String FEATURE_JSP = "jsp";
    private static final String FEATURE_JNDI = "jndi";
    private static final String FEATURE_JDBC = "jdbc";
    private static final String ELEMENT_DATASOURCE = "dataSource";
    private static final String DATASOURCE_CLASS = "javax.sql.DataSource";
    private AbstractServerExtension serverExtension = null;
    public static final String CONSOLE_LINE_TRACKER_TEST = "console.line.tracker.test";
    public static final String BROWSER_LINK_LOG = "consolelinetracker-browserlink.log";
    private IConsole console;

    public void init(IConsole console) {
        this.console = console;
    }

    public void lineAppended(IRegion line) {
        block30: {
            try {
                AbstractHyperlink link;
                int offset = line.getOffset();
                int length = line.getLength();
                String text = this.console.getDocument().get(offset, length);
                if (text == null || length == 0) {
                    return;
                }
                if (text.equals("wasdev")) {
                    link = new AbstractHyperlink(){

                        @Override
                        public void linkActivated() {
                            try {
                                IWorkbenchBrowserSupport bs = PlatformUI.getWorkbench().getBrowserSupport();
                                IWebBrowser b = bs.createBrowser(6, null, null, null);
                                b.openURL(new URL("http://wasdev.net"));
                            }
                            catch (Exception e) {
                                Trace.logError("Error activating console link: http://wasdev.net", e);
                            }
                        }
                    };
                    this.console.addLink((IHyperlink)link, offset, text.length());
                }
                if (text.startsWith(SERVLET_ERROR)) {
                    int start = text.indexOf("'") + 1;
                    int end = text.indexOf("'", start);
                    if (start > 0 && end > 0 && start < end - 3) {
                        String content1;
                        String content = text.substring(start, end);
                        int index = content.indexOf(":");
                        if (index > -1) {
                            String contentBegin = content.substring(0, index);
                            String contentEnd = content.substring(index);
                            content1 = contentBegin + "()" + contentEnd;
                        } else {
                            content1 = content + "()";
                        }
                        AbstractHyperlink link2 = new AbstractHyperlink(){

                            @Override
                            public void linkActivated() {
                                try {
                                    ConsoleLineTracker.openJavaEditor(content1);
                                }
                                catch (Exception e) {
                                    Trace.logError("Error activating console link: " + content1, e);
                                }
                            }
                        };
                        this.console.addLink((IHyperlink)link2, offset + start, end - start);
                    }
                } else if (text.startsWith(JSP_WARNING)) {
                    link = new AbstractHyperlink(){

                        @Override
                        public void linkActivated() {
                            ConsoleLineTracker.this.addJSPSupport();
                        }
                    };
                    this.console.addLink((IHyperlink)link, offset + JSP_WARNING.length(), length - JSP_WARNING.length());
                } else if (text.startsWith(COLD_START_ERROR)) {
                    link = new AbstractHyperlink(){

                        @Override
                        public void linkActivated() {
                            ConsoleLineTracker.this.promptForColdStart();
                        }
                    };
                    this.console.addLink((IHyperlink)link, offset + COLD_START_ERROR.length(), length - COLD_START_ERROR.length());
                } else if (text.startsWith(WEB_APP_ADD) || text.startsWith(WEB_APP_REMOVE)) {
                    this.addBrowserLinkToConsole(text, offset, length, WEB_APP_ADD);
                } else if (text.startsWith(HTTP_WHITEBOARD_ADD)) {
                    this.addBrowserLinkToConsole(text, offset, length, HTTP_WHITEBOARD_ADD);
                } else if (text.startsWith(HTTP_WHITEBOARD_REMOVE)) {
                    this.addBrowserLinkToConsole(text, offset, length, HTTP_WHITEBOARD_REMOVE);
                } else if (text.startsWith(OSGI_APPCONSOLE_ADD)) {
                    this.addBrowserLinkToConsole(text, offset, length, OSGI_APPCONSOLE_ADD);
                } else if (text.startsWith(OSGI_APPCONSOLE_REMOVE)) {
                    this.addBrowserLinkToConsole(text, offset, length, OSGI_APPCONSOLE_REMOVE);
                } else if (text.contains(JNDI_NO_INITIAL_CONTEXT_EXCEPTION)) {
                    link = new AbstractHyperlink(){

                        @Override
                        public void linkActivated() {
                            ConsoleLineTracker.this.addJNDISupport();
                        }
                    };
                    this.console.addLink((IHyperlink)link, offset + JNDI_NO_INITIAL_CONTEXT_EXCEPTION.length(), length - JNDI_NO_INITIAL_CONTEXT_EXCEPTION.length());
                } else if (text.startsWith(JNDI_INJECT_ERROR) && text.contains(DATASOURCE_CLASS)) {
                    final String output = text;
                    AbstractHyperlink link3 = new AbstractHyperlink(){

                        @Override
                        public void linkActivated() {
                            ConsoleLineTracker.this.addJDBCSupport(output);
                        }
                    };
                    this.console.addLink((IHyperlink)link3, offset + JNDI_INJECT_ERROR.length(), length - JNDI_INJECT_ERROR.length());
                } else if (text.startsWith(CONFIG_DROPINS_ADD)) {
                    this.addPathLinkToConsole(text, offset, length, CONFIG_DROPINS_ADD);
                } else if (text.startsWith(INCLUDES_ADD)) {
                    this.addPathLinkToConsole(text, offset, length, INCLUDES_ADD);
                }
            }
            catch (BadLocationException e) {
                if (!Trace.ENABLED) break block30;
                Trace.trace((byte)1, "Error trying to add links to console", e);
            }
        }
    }

    protected static void openJavaEditor(String content2) {
        IProject[] projects;
        String content = content2;
        int index = content.indexOf(":");
        int lineNumber = -1;
        if (index > 0) {
            try {
                lineNumber = Integer.parseInt(content.substring(index + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            content = content.substring(0, index);
        }
        index = content.lastIndexOf(".");
        if (content.endsWith("()") && index > 0) {
            content = content.substring(0, index);
        }
        for (IProject p : projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            try {
                int start;
                ITextEditor editor;
                block9: {
                    IJavaProject javaProject;
                    IType type;
                    if (!p.isOpen() || !p.isNatureEnabled("org.eclipse.jdt.core.javanature") || (type = (javaProject = JavaCore.create((IProject)p)).findType(content)) == null) continue;
                    editor = (ITextEditor)JavaUI.openInEditor((IJavaElement)type);
                    IDocumentProvider provider = editor.getDocumentProvider();
                    IDocument document = provider.getDocument((Object)editor.getEditorInput());
                    start = 0;
                    try {
                        start = document.getLineOffset(lineNumber - 1);
                    }
                    catch (BadLocationException ble) {
                        if (!Trace.ENABLED) break block9;
                        Trace.trace((byte)0, "Could not get offset for line " + lineNumber);
                    }
                }
                editor.selectAndReveal(start, 0);
                IWorkbenchPage page = editor.getSite().getPage();
                page.activate((IWorkbenchPart)editor);
            }
            catch (Exception e) {
                Trace.logError("Error opening Java editor", e);
            }
        }
    }

    protected void addJSPSupport() {
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Running JSP feature quick fix");
        }
        try {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (MessageDialog.openConfirm((Shell)shell, (String)Messages.title, (String)Messages.taskFixJSP)) {
                WebSphereServer server = this.getServer();
                if (server == null) {
                    Trace.logError("Failed to get server", null);
                    return;
                }
                IStatus status = ConsoleLineTrackerHelper.addFeatureSupport((WebSphereServer)server, (String)FEATURE_JSP);
                if (status == ConsoleLineTrackerHelper.EXIST_STATUS) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "JSP support already exists on server");
                    }
                    MessageDialog.openError((Shell)shell, (String)Messages.title, (String)NLS.bind((String)Messages.errorFeatureExists, (Object)FEATURE_JSP));
                } else if (status == ConsoleLineTrackerHelper.UNRESOLVED_STATUS) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "JSP feature is not part of the runtime install");
                    }
                    MessageDialog.openError((Shell)shell, (String)Messages.title, (String)NLS.bind((String)Messages.errorFeatureUnresolved, (Object)FEATURE_JSP));
                }
            }
        }
        catch (Exception e) {
            Trace.logError("Error trying to add JSP support", e);
        }
    }

    protected void addJNDISupport() {
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Running JNDI feature quick fix");
        }
        try {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (MessageDialog.openConfirm((Shell)shell, (String)Messages.title, (String)Messages.taskFixJNDI)) {
                WebSphereServer server = this.getServer();
                if (server == null) {
                    Trace.logError("Failed to get server", null);
                    return;
                }
                IStatus status = ConsoleLineTrackerHelper.addFeatureSupport((WebSphereServer)server, (String)FEATURE_JNDI);
                if (status == ConsoleLineTrackerHelper.EXIST_STATUS) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "JNDI support already exists on server");
                    }
                    MessageDialog.openError((Shell)shell, (String)Messages.title, (String)NLS.bind((String)Messages.errorFeatureExists, (Object)FEATURE_JNDI));
                } else if (status == ConsoleLineTrackerHelper.UNRESOLVED_STATUS) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "JNDI feature is not part of the runtime install");
                    }
                    MessageDialog.openError((Shell)shell, (String)Messages.title, (String)NLS.bind((String)Messages.errorFeatureUnresolved, (Object)FEATURE_JNDI));
                }
            }
        }
        catch (Exception e) {
            Trace.logError("Error trying to add JNDI support", e);
        }
    }

    protected void addJDBCSupport(String text) {
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Running JDBC feature quick fix");
        }
        try {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            WebSphereServer server = this.getServer();
            if (server == null) {
                Trace.logError("Failed to get server", null);
                return;
            }
            ConfigurationFile configFile = server.getConfiguration();
            if (configFile.getIFile() == null) {
                server.refreshConfiguration();
            }
            if (ConsoleLineTrackerHelper.isFeatureExist((WebSphereServer)server, (String)FEATURE_JDBC)) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "JDBC support already exists on server");
                }
                if (configFile.hasElement(ELEMENT_DATASOURCE)) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "dataSource element already exists on server");
                    }
                    MessageDialog.openError((Shell)shell, (String)Messages.title, (String)NLS.bind((String)Messages.errorElementSet, (Object)ELEMENT_DATASOURCE));
                } else {
                    MessageDialog.openError((Shell)shell, (String)Messages.title, (String)NLS.bind((String)Messages.errorElementNotSet, (Object)ELEMENT_DATASOURCE));
                }
                return;
            }
            if (MessageDialog.openConfirm((Shell)shell, (String)Messages.title, (String)Messages.taskFixJDBC)) {
                IStatus status = ConsoleLineTrackerHelper.addFeatureSupport((WebSphereServer)server, (String)FEATURE_JDBC);
                if (status == ConsoleLineTrackerHelper.EXIST_STATUS) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "JDBC support already exists on server");
                    }
                    MessageDialog.openError((Shell)shell, (String)Messages.title, (String)NLS.bind((String)Messages.errorFeatureExists, (Object)FEATURE_JDBC));
                } else if (status == ConsoleLineTrackerHelper.UNRESOLVED_STATUS) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "JDBC feature is not part of the runtime install");
                    }
                    MessageDialog.openError((Shell)shell, (String)Messages.title, (String)NLS.bind((String)Messages.errorFeatureUnresolved, (Object)FEATURE_JDBC));
                }
            }
        }
        catch (Exception e) {
            Trace.logError("Error trying to add JDBC support", e);
        }
    }

    private WebSphereServer getServer() throws Exception {
        ILaunchConfiguration launchConfig = this.console.getProcess().getLaunch().getLaunchConfiguration();
        IServer srv = ServerUtil.getServer((ILaunchConfiguration)launchConfig);
        return srv == null ? null : (WebSphereServer)srv.loadAdapter(WebSphereServer.class, null);
    }

    protected void promptForColdStart() {
        try {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (MessageDialog.openQuestion((Shell)shell, (String)Messages.title, (String)Messages.taskColdStart)) {
                ILaunchConfiguration launchConfig = this.console.getProcess().getLaunch().getLaunchConfiguration();
                final IServer server = ServerUtil.getServer((ILaunchConfiguration)launchConfig);
                final String mode = server.getMode();
                if (server.getServerState() == 2) {
                    server.stop(false, new IServer.IOperationListener(){

                        public void done(IStatus result) {
                            if (result != null && result.isOK()) {
                                ConsoleLineTracker.cleanAndStart(server, mode);
                            }
                        }
                    });
                } else {
                    ConsoleLineTracker.cleanAndStart(server, mode);
                }
            }
        }
        catch (Exception e) {
            Trace.logError("Error trying to do a clean start", e);
        }
    }

    protected static void cleanAndStart(IServer server, String mode) {
        WebSphereServerBehaviour wsServer = (WebSphereServerBehaviour)server.loadAdapter(WebSphereServerBehaviour.class, null);
        wsServer.setCleanOnStartup(true);
        server.start(mode, (IServer.IOperationListener)null);
    }

    protected void openBrowser(String urlString) {
        block2: {
            try {
                IWorkbenchBrowserSupport bs = PlatformUI.getWorkbench().getBrowserSupport();
                IWebBrowser b = bs.createBrowser(6, null, null, null);
                b.openURL(new URL(urlString));
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block2;
                Trace.trace((byte)1, "URL is not valid or could not open browser", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBrowserLinkToConsole(String text, int offset, int length, String prefix) {
        String tempUrl;
        int start;
        block10: {
            if (this.console == null) {
                return;
            }
            start = text.indexOf(": ", prefix.length()) + 2;
            tempUrl = null;
            tempUrl = text.endsWith("*") ? text.substring(start, length - 1) : text.substring(start, length);
            try {
                WebSphereServer server = this.getServer();
                if (this.serverExtension == null) {
                    this.serverExtension = ServerTypeExtensionFactory.getServerExtension((String)server.getServerType());
                }
                if (this.serverExtension == null) break block10;
                URI uri = URI.create(tempUrl);
                IServer iServer = server.getServer();
                String serverHost = iServer.getHost();
                int uriPort = uri.getPort();
                String serverPort = uriPort < 0 ? "" : Integer.toString(uriPort);
                String scheme = tempUrl.substring(0, tempUrl.indexOf(uri.getHost()));
                String mappedHost = this.serverExtension.getConnectionHost(iServer, serverHost, serverPort);
                String mappedPort = this.serverExtension.getConnectionPort(iServer, serverPort);
                tempUrl = scheme + mappedHost + ":" + mappedPort + uri.getPath();
                String trackerValue = System.getProperty(CONSOLE_LINE_TRACKER_TEST);
                if (trackerValue == null) break block10;
                File consoleLineTrackerLog = com.ibm.ws.st.core.internal.Activator.getInstance().getStateLocation().append(BROWSER_LINK_LOG).toFile();
                try (FileWriter fw = null;){
                    fw = new FileWriter(consoleLineTrackerLog, true);
                    fw.append("Original URL:" + uri.toString() + "\n");
                    fw.append("Mapped URL:" + tempUrl + "\n");
                }
            }
            catch (Exception e) {
                Trace.logError("Cannot convert to a mapped URL", e);
            }
        }
        final String url = tempUrl;
        AbstractHyperlink link = new AbstractHyperlink(){

            @Override
            public void linkActivated() {
                ConsoleLineTracker.this.openBrowser(url);
            }
        };
        this.console.addLink((IHyperlink)link, offset + start, length - start);
    }

    protected void openFileOnEditor(String path) {
        WebSphereServer server = null;
        try {
            server = this.getServer();
        }
        catch (Exception e) {
            Trace.logError("Failed to get server", e);
            return;
        }
        if (server.isLocalSetup()) {
            this.openLocalFile(path);
        } else {
            this.openRemoteFile(server, path);
        }
    }

    private void openLocalFile(String path) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path pathToFile = new Path(path);
        IFile fileToOpen = workspaceRoot.getFileForLocation((IPath)pathToFile);
        Activator.openConfigurationEditor(fileToOpen, pathToFile.toFile().toURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openRemoteFile(WebSphereServer server, String path) {
        JMXConnection jmx = null;
        String localFilePath = null;
        try {
            jmx = server.createJMXConnection();
            localFilePath = server.getWebSphereServerBehaviour().resolveLocalFilePath(path, jmx);
        }
        catch (Exception e) {
            Trace.logError("Failed to create JMX connection", e);
        }
        finally {
            if (jmx != null) {
                jmx.disconnect();
            }
        }
        if (localFilePath != null && !localFilePath.isEmpty()) {
            this.openLocalFile(localFilePath);
        }
    }

    private void addPathLinkToConsole(String text, int offset, int length, String prefix) {
        String output = text;
        int pathIndex = 0;
        pathIndex = output.contains("\\") ? output.indexOf("\\") - 2 : output.indexOf("/");
        final String path = text.substring(pathIndex, length);
        AbstractHyperlink link = new AbstractHyperlink(){

            @Override
            public void linkActivated() {
                try {
                    ConsoleLineTracker.this.openFileOnEditor(path);
                }
                catch (Exception e) {
                    Trace.logError("Error activating console link: " + path, e);
                }
            }
        };
        this.console.addLink((IHyperlink)link, offset + pathIndex, length - pathIndex);
    }

    public void dispose() {
    }

    class AbstractHyperlink
    implements IHyperlink {
        AbstractHyperlink() {
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
        }
    }
}

