/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.ui.internal.DDETreeContentProvider;
import com.ibm.ws.st.ui.internal.Trace;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.CommonViewer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigurationResourceContentProvider
extends DDETreeContentProvider {
    private IResourceChangeListener listener;

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (!(viewer instanceof CommonViewer)) {
            return;
        }
        this.commonViewer = (CommonViewer)viewer;
        if (this.listener == null) {
            this.listener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    IResourceDelta delta = event.getDelta();
                    if (delta == null) {
                        return;
                    }
                    if (event.getBuildKind() == 15) {
                        return;
                    }
                    try {
                        final ArrayList<IFile> files = new ArrayList<IFile>(10);
                        delta.accept(new IResourceDeltaVisitor(){

                            public boolean visit(IResourceDelta visitorDelta) {
                                IFile file;
                                IContentType contentType;
                                IResource resource = visitorDelta.getResource();
                                if (visitorDelta.getKind() == 4 && resource != null && resource instanceof IFile && (contentType = IDE.getContentType((IFile)(file = (IFile)resource))) != null && "com.ibm.ws.st.configuration".equals(contentType.getId())) {
                                    if ((visitorDelta.getFlags() & 0x100) == 0 && (visitorDelta.getFlags() & 0x40000) == 0) {
                                        return false;
                                    }
                                    files.add(file);
                                }
                                return true;
                            }
                        });
                        if (!files.isEmpty()) {
                            ConfigurationResourceContentProvider.this.refreshFiles(files);
                        }
                    }
                    catch (CoreException ce) {
                        Trace.trace((byte)1, "Error in resource listener", ce);
                    }
                }
            };
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.listener, 1);
        }
    }

    protected void refreshFiles(final List<IFile> files) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ConfigurationResourceContentProvider.this.commonViewer != null) {
                    for (IFile file : files) {
                        ConfigurationResourceContentProvider.this.commonViewer.refresh((Object)file);
                    }
                }
            }
        });
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        IFile file;
        URI uri;
        Document doc;
        if (parentElement instanceof IFile && (doc = ConfigUtils.getDOM((URI)(uri = (file = (IFile)parentElement).getLocation().toFile().toURI()))) != null) {
            if (doc.getUserData("uri") == null) {
                doc.setUserData("uri", uri.toString(), null);
                doc.setUserData("userDirectory", file.getProject().getLocation().toFile().toURI().toString(), null);
            }
            Element node = doc.getDocumentElement();
            return this.getChildren(node);
        }
        if (parentElement instanceof Element && "include".equals(((Element)parentElement).getNodeName())) {
            return NO_CHILDREN;
        }
        return super.getChildren(parentElement);
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof IFile) {
            return true;
        }
        return super.hasChildren(element);
    }

    @Override
    public void dispose() {
        this.commonViewer = null;
        if (this.listener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
        }
    }
}

