/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.ConfigVarsUtils;
import com.ibm.ws.st.core.internal.config.DocumentLocation;
import com.ibm.ws.st.core.internal.config.SchemaUtil;
import com.ibm.ws.st.core.internal.config.URILocation;
import com.ibm.ws.st.ui.internal.BaseHyperlinkDetector;
import com.ibm.ws.st.ui.internal.ConfigHyperlink;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.config.ConfigUIUtils;
import java.net.URI;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConfigHyperlinkDetector
extends BaseHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        CMNode cmNode;
        Attr attr;
        IHyperlink[] varHyperlink;
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        Node node = this.getCurrentNode(document, region.getOffset());
        if (node == null) {
            return null;
        }
        Document dom = node.getOwnerDocument();
        if (dom == null || !this.isConfigDocument(dom)) {
            return null;
        }
        IHyperlink[] includeHyperlink = this.getIncludeHyperlink(node, region);
        if (includeHyperlink != null) {
            return includeHyperlink;
        }
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(document, region.getOffset());
        if (sdRegion == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "VariableHyperlinkDetector: could not identify the IStructuredDocumentRegion");
            }
            return null;
        }
        ITextRegion textRegion = sdRegion.getRegionAtCharacterOffset(region.getOffset());
        if (textRegion == null || !"XML_TAG_ATTRIBUTE_VALUE".equals(textRegion.getType()) && !"XML_CONTENT".equals(textRegion.getType())) {
            return null;
        }
        String textString = sdRegion.getFullText(textRegion);
        if (textString == null || textString.isEmpty()) {
            return null;
        }
        int startOffset = region.getOffset() - sdRegion.getStartOffset(textRegion);
        int endOffset = startOffset + (region.getLength() == 0 ? 0 : region.getLength() - 1);
        if ("XML_TAG_ATTRIBUTE_VALUE".equals(textRegion.getType())) {
            if ((textString = textString.trim()).charAt(0) == '\"') {
                textString = textString.substring(1);
                startOffset = startOffset > 0 ? startOffset - 1 : startOffset;
                int n = endOffset = endOffset > 0 ? endOffset - 1 : endOffset;
            }
            if (textString.charAt(textString.length() - 1) == '\"') {
                startOffset = startOffset == (textString = textString.substring(0, textString.length() - 1)).length() ? startOffset - 1 : startOffset;
                int n = endOffset = endOffset == textString.length() ? endOffset - 1 : endOffset;
            }
        }
        if ((varHyperlink = this.getVariableHyperlink(textString, startOffset, endOffset, region, dom, node, attr = this.getCurrentAttr(node, sdRegion, textRegion))) != null) {
            return varHyperlink;
        }
        if (attr != null) {
            node = attr;
        }
        if ((cmNode = this.getCMNode(node)) == null) {
            return null;
        }
        String type = ConfigUtils.getTypeName((CMNode)cmNode);
        if (type == null) {
            return null;
        }
        if (ConfigVars.getTypeSet((String)type) == ConfigVars.REFERENCE_TYPES) {
            String[] references;
            for (String reference : references = SchemaUtil.getReferences((CMNode)cmNode)) {
                IHyperlink[] idHyperlink = this.getFactoryIdHyperlink(textString, startOffset, endOffset, reference, region, dom);
                if (idHyperlink == null) continue;
                return idHyperlink;
            }
        }
        return null;
    }

    private IHyperlink[] getIncludeHyperlink(Node node, IRegion region) {
        String include;
        IEditorInput editorInput = ConfigUIUtils.getActiveEditorInput();
        if (editorInput == null) {
            return null;
        }
        URI baseURI = ConfigUIUtils.getURI(editorInput);
        if (baseURI == null) {
            return null;
        }
        if (node.getNodeType() == 1 && "include".equals(node.getNodeName()) && (include = ((Element)node).getAttribute("location")) != null && !include.trim().isEmpty()) {
            IResource includeFile;
            IFileEditorInput fileEditorInput;
            IFile file;
            IFolder mappedConfigFolder;
            URI uri = null;
            WebSphereServerInfo serverInfo = ConfigUtils.getServerInfo((URI)baseURI);
            if (editorInput instanceof IFileEditorInput && (mappedConfigFolder = ConfigUtils.getMappedConfigFolder((IResource)(file = (fileEditorInput = (IFileEditorInput)editorInput).getFile()))) != null && (uri = (includeFile = mappedConfigFolder.findMember(include)).getLocationURI()) != null) {
                return new IHyperlink[]{new ConfigHyperlink(region, (URILocation)DocumentLocation.createDocumentLocation((URI)uri, (DocumentLocation.Type)DocumentLocation.Type.SERVER_XML), include)};
            }
            if (serverInfo != null) {
                uri = serverInfo.resolve(baseURI, include);
            } else {
                UserDirectory userDir = ConfigUtils.getUserDirectory((URI)baseURI);
                if (userDir != null) {
                    uri = userDir.resolve(baseURI, include);
                }
            }
            if (uri != null) {
                return new IHyperlink[]{new ConfigHyperlink(region, (URILocation)DocumentLocation.createDocumentLocation((URI)uri, (DocumentLocation.Type)DocumentLocation.Type.SERVER_XML), include)};
            }
        }
        return null;
    }

    private IHyperlink[] getVariableHyperlink(String textString, int startOffset, int endOffset, IRegion region, Document dom, Node node, Attr attr) {
        String varName = ConfigVarsUtils.getVariableName((String)textString, (int)startOffset, (int)endOffset);
        if (varName == null || varName.isEmpty()) {
            return null;
        }
        ConfigVars configVars = node != null && node.getNodeType() == 1 ? ConfigUIUtils.getConfigVars(ConfigUIUtils.getActiveEditorInput(), (Element)node, attr == null ? null : attr.getName()) : ConfigUIUtils.getConfigVars(ConfigUIUtils.getActiveEditorInput(), dom);
        DocumentLocation location = configVars.getDocumentLocation(varName);
        if (location != null && location.getURI() != null) {
            return new IHyperlink[]{new ConfigHyperlink(region, (URILocation)location, varName)};
        }
        return null;
    }

    private IHyperlink[] getFactoryIdHyperlink(String text, int startOffset, int endOffset, String reference, IRegion region, Document dom) {
        Map<String, URILocation> idMap;
        URI uri = null;
        WebSphereServerInfo serverInfo = null;
        UserDirectory userDir = null;
        IEditorInput editorInput = ConfigUIUtils.getActiveEditorInput();
        if (editorInput != null && (uri = ConfigUIUtils.getURI(editorInput)) != null) {
            serverInfo = ConfigUtils.getServerInfo((URI)uri);
            UserDirectory userDirectory = userDir = serverInfo != null ? serverInfo.getUserDirectory() : ConfigUtils.getUserDirectory((URI)uri);
        }
        if ((idMap = ConfigUIUtils.getIdMap(dom, uri, serverInfo, userDir, reference)).size() == 0) {
            return null;
        }
        String str = ConfigUIUtils.getListItem(text, startOffset, endOffset);
        if (str == null || str.isEmpty()) {
            return null;
        }
        URILocation location = idMap.get(str);
        if (location != null && location.getURI() != null) {
            return new IHyperlink[]{new ConfigHyperlink(region, location, str)};
        }
        return null;
    }

    private IStructuredDocumentRegion getStructuredDocumentRegion(IDocument document, int offset) {
        if (document instanceof IStructuredDocument) {
            IStructuredDocument doc = (IStructuredDocument)document;
            return doc.getRegionAtCharacterOffset(offset);
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)1, "VariableHyperlinkDetector: document is not an IStructuredDocument");
        }
        return null;
    }
}

