/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.core.internal.ProjectPrefs;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.ui.internal.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class ClasspathPropertyPage
extends PropertyPage {
    protected ProjectPrefs prefs;
    protected boolean updating;
    protected boolean changed;
    protected Button excludeThirdParty;
    protected Button excludeStable;
    protected Button excludeIBMAPI;
    protected Button excludeUnknown;
    protected IProject project;

    protected Control createContents(Composite parent) {
        try {
            IAdaptable element = this.getElement();
            this.project = (IProject)element.getAdapter(IProject.class);
            if (this.project != null) {
                this.prefs = new ProjectPrefs(this.project);
            }
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 1;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            Label label = new Label(composite, 0);
            label.setText(Messages.runtimeClasspathMessage);
            this.excludeThirdParty = new Button(composite, 32);
            this.excludeThirdParty.setText(Messages.runtimeClasspathExcludeThirdParty);
            GridData data = new GridData(4, 1, true, false);
            data.horizontalIndent = 15;
            this.excludeThirdParty.setLayoutData((Object)data);
            this.excludeThirdParty.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (ClasspathPropertyPage.this.updating) {
                        return;
                    }
                    ClasspathPropertyPage.this.changed = true;
                    ClasspathPropertyPage.this.prefs.setExcludeThirdPartyAPI(ClasspathPropertyPage.this.excludeThirdParty.getSelection());
                }
            });
            this.excludeStable = new Button(composite, 32);
            this.excludeStable.setText(Messages.runtimeClasspathExcludeStable);
            data = new GridData(4, 1, true, false);
            data.horizontalIndent = 15;
            this.excludeStable.setLayoutData((Object)data);
            this.excludeStable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (ClasspathPropertyPage.this.updating) {
                        return;
                    }
                    ClasspathPropertyPage.this.changed = true;
                    ClasspathPropertyPage.this.prefs.setExcludeStableAPI(ClasspathPropertyPage.this.excludeStable.getSelection());
                }
            });
            this.excludeIBMAPI = new Button(composite, 32);
            this.excludeIBMAPI.setText(Messages.runtimeClasspathExcludeIBM);
            data = new GridData(4, 1, true, false);
            data.horizontalIndent = 15;
            this.excludeIBMAPI.setLayoutData((Object)data);
            this.excludeIBMAPI.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (ClasspathPropertyPage.this.updating) {
                        return;
                    }
                    ClasspathPropertyPage.this.changed = true;
                    ClasspathPropertyPage.this.prefs.setExcludeIBMAPI(ClasspathPropertyPage.this.excludeIBMAPI.getSelection());
                }
            });
            this.excludeUnknown = new Button(composite, 32);
            this.excludeUnknown.setText(Messages.runtimeClasspathExcludeUnknown);
            data = new GridData(4, 1, true, false);
            data.horizontalIndent = 15;
            this.excludeUnknown.setLayoutData((Object)data);
            this.excludeUnknown.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (ClasspathPropertyPage.this.updating) {
                        return;
                    }
                    ClasspathPropertyPage.this.changed = true;
                    ClasspathPropertyPage.this.prefs.setExcludeUnrecognized(ClasspathPropertyPage.this.excludeUnknown.getSelection());
                }
            });
            this.init();
            Dialog.applyDialogFont((Control)composite);
            return composite;
        }
        catch (Exception e) {
            Trace.logError((String)"Error creating property page", (Throwable)e);
            return null;
        }
    }

    protected void init() {
        this.updating = true;
        this.excludeThirdParty.setSelection(this.prefs.isExcludeThirdPartyAPI());
        this.excludeStable.setSelection(this.prefs.isExcludeStableAPI());
        this.excludeIBMAPI.setSelection(this.prefs.isExcludeIBMAPI());
        this.excludeUnknown.setSelection(this.prefs.isExcludeUnrecognized());
        this.updating = false;
    }

    protected void performDefaults() {
        this.prefs.reset();
        this.changed = true;
        this.init();
    }

    protected boolean save() {
        if (this.prefs == null) {
            return true;
        }
        boolean b = this.prefs.save();
        if (this.changed) {
            try {
                IClasspathEntry[] entries;
                Path path = new Path("org.eclipse.jst.server.core.container/com.ibm.ws.st.core.runtimeClasspathProvider");
                IJavaProject javaProject = JavaCore.create((IProject)this.project);
                for (IClasspathEntry entry : entries = javaProject.getRawClasspath()) {
                    IPath entryPath = entry.getPath();
                    if (entryPath.segmentCount() <= 1 || !path.segment(0).equals(entryPath.segment(0)) || !path.segment(1).equals(entryPath.segment(1))) continue;
                    JavaCore.setClasspathContainer((IPath)entryPath, (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{null}, null);
                }
            }
            catch (Exception e) {
                Trace.logError((String)("Could not reset the classpath container: " + this.project), (Throwable)e);
            }
            this.changed = false;
        }
        return b;
    }

    protected void performApply() {
        this.save();
    }

    public boolean performOk() {
        return this.save();
    }
}

