/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.common.core.internal;

import com.ibm.ws.st.common.core.internal.Activator;
import com.ibm.ws.st.common.core.internal.TraceDebugListener;
import com.ibm.ws.st.common.core.internal.TraceSpecification;
import com.ibm.ws.st.common.core.internal.TraceUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Trace {
    private static final String CLASS_NAME = Trace.class.getName();
    public static final byte INFO = 0;
    public static final byte WARNING = 1;
    private static final byte PERFORMANCE = 4;
    public static boolean ENABLED = false;
    private static final byte[] TRACE_LEVELS = new byte[]{0, 1, 4};
    private static final TraceDebugListener TDL = new TraceDebugListener(){

        @Override
        public void debugChanged(boolean value) {
            ENABLED = value;
        }
    };
    protected static final TraceSpecification TS = new TraceSpecification("com.ibm.ws.st.common.core", TRACE_LEVELS, TDL);

    private Trace() {
    }

    public static void trace(byte level, String s) {
        Trace.trace(level, s, null);
    }

    public static void trace(byte level, String s, Throwable t) {
        if (!TS.isLevelEnabled(level)) {
            return;
        }
        TraceUtil.trace(level, s, t, CLASS_NAME);
    }

    public static void tracePerf(String s, long time) {
        if (!TS.isLevelEnabled((byte)4)) {
            return;
        }
        TraceUtil.perf(s, time, CLASS_NAME);
    }

    public static void logError(String s, Throwable t) {
        Activator.getInstance().getLog().log((IStatus)new Status(4, "com.ibm.ws.st.common.core", s, t));
    }
}

