/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.common.core.internal;

import com.ibm.ws.st.common.core.internal.Trace;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

public class RemoteServerInfo
extends HashMap<String, Object> {
    private static final long serialVersionUID = 2110714887126584511L;
    public static final int REMOTE_SERVER_STARTUP_WINDOWS = 0;
    public static final int REMOTE_SERVER_STARTUP_LINUX = 1;
    public static final int REMOTE_SERVER_STARTUP_OTHER = 2;
    public static final int REMOTE_SERVER_STARTUP_MAC = 3;
    public static final int REMOTE_SERVER_STARTUP_LOGON_OS = 0;
    public static final int REMOTE_SERVER_STARTUP_LOGON_SSH = 1;
    public static final String PROPERTY_REMOTE_START_ENABLED = "remoteStart_Enabled";
    public static final String PROPERTY_REMOTE_START_TWAS_PROFILE_PATH = "remoteStart_ProfilePath";
    public static final String PROPERTY_REMOTE_START_LIBERTY_RUNTIME_PATH = "remoteStart_LibertyRuntimePath";
    public static final String PROPERTY_REMOTE_START_LIBERTY_CONFIG_PATH = "remoteStart_LibertyConfigPath";
    public static final String PROPERTY_REMOTE_START_PLATFORM = "remoteStart_Platform";
    public static final String PROPERTY_REMOTE_START_LOGONMETHOD = "remoteStart_LogonMethod";
    public static final String PROPERTY_REMOTE_START_OS_ID = "remoteStart_OSId";
    public static final String PROPERTY_REMOTE_START_OS_PWD = "remoteStart_OSPassword";
    public static final String PROPERTY_REMOTE_START_SSH_ID = "remoteStart_SSHId";
    public static final String PROPERTY_REMOTE_START_SSH_PASSPHRASE = "remoteStart_SSHPassphrase";
    public static final String PROPERTY_REMOTE_START_SSH_KEY_FILE = "remoteStart_SSHKeyFile";
    public static final String SECURE_REMOTE_OS_PASSWORD_KEY = ".remoteOSPassword";
    private transient String tempRemoteOSPassword = "";
    public static final String PROPERTY_REMOTE_START_DEBUG_PORT = "remoteStart_debugPort";
    public static final String PROPERTY_IS_CLOUD_ENABLED = "cloudIsEnabled";
    protected transient Vector<PropertyChangeListener> propertyListeners;
    private final RemoteServerType type;

    public String getTempRemoteOSPassword() {
        return this.tempRemoteOSPassword;
    }

    public void setTempRemoteOSPassword(String tempRemoteOSPassword) {
        String oldPass = this.getTempRemoteOSPassword();
        if (oldPass.equals(tempRemoteOSPassword)) {
            return;
        }
        this.tempRemoteOSPassword = tempRemoteOSPassword;
        this.firePropertyChangeEvent(PROPERTY_REMOTE_START_OS_PWD, oldPass, tempRemoteOSPassword);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new Vector();
        }
        this.propertyListeners.add(listener);
    }

    public RemoteServerInfo(RemoteServerType type) {
        this.type = type;
    }

    public RemoteServerType getMode() {
        return this.type;
    }

    public boolean getBooleanValue(String key, boolean defaultValue) {
        block3: {
            try {
                Boolean val = (Boolean)this.get(key);
                if (val != null) {
                    return val;
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block3;
                Trace.trace((byte)1, "Could not get value for key: " + key, e);
            }
        }
        return defaultValue;
    }

    public String getStringValue(String key) {
        block3: {
            try {
                String val = (String)this.get(key);
                if (val != null) {
                    return val;
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block3;
                Trace.trace((byte)1, "Could not get value for key: " + key, e);
            }
        }
        return "";
    }

    public int getIntegerValue(String key, int defaultValue) {
        block3: {
            try {
                Integer val = (Integer)this.get(key);
                if (val != null) {
                    return val;
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block3;
                Trace.trace((byte)1, "Could not get value for key: " + key, e);
            }
        }
        return defaultValue;
    }

    public void putBooleanValue(String key, boolean value) {
        block2: {
            try {
                Boolean val = value;
                this.put(key, val);
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block2;
                Trace.logError("Error setting value for key value pair (" + key + ", " + value + ")", e);
            }
        }
    }

    public void putIntegerValue(String key, int value) {
        block2: {
            try {
                Integer val = value;
                this.put(key, val);
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block2;
                Trace.logError("Error setting value for key value pair (" + key + ", " + value + ")", e);
            }
        }
    }

    public void setRemoteServerOSPwd(String newPassword, String nodeName) {
        block3: {
            String oldValue = this.getRemoteServerOSPwd(nodeName);
            if (oldValue.equals(newPassword)) {
                return;
            }
            ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
            ISecurePreferences node = preferences.node(nodeName);
            try {
                node.put(SECURE_REMOTE_OS_PASSWORD_KEY, newPassword, true);
                preferences.flush();
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block3;
                Trace.logError("Failed to set remote OS password", e);
            }
        }
    }

    public String getRemoteServerOSPwd(String nodeName) {
        String osPassword;
        block2: {
            ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
            ISecurePreferences node = preferences.node(nodeName);
            osPassword = "";
            try {
                osPassword = node.get(SECURE_REMOTE_OS_PASSWORD_KEY, "");
            }
            catch (StorageException e) {
                if (!Trace.ENABLED) break block2;
                Trace.logError("Failed to get remote OS password", e);
            }
        }
        return osPassword;
    }

    public void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyListeners == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        try {
            Vector clone = (Vector)this.propertyListeners.clone();
            int size = clone.size();
            for (int i = 0; i < size; ++i) {
                try {
                    PropertyChangeListener listener = (PropertyChangeListener)clone.elementAt(i);
                    listener.propertyChange(event);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void readObject(ObjectInputStream in) throws IOException {
        throw new IOException("Cannot be deserialized");
    }

    public static enum RemoteServerType {
        TWAS,
        Liberty;

    }

    public static enum CloudType {
        CLOUD,
        NON_CLOUD,
        UNKNOWN;

    }
}

