/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.liberty.gradle.manager.internal;

import com.ibm.ws.st.liberty.buildplugin.integration.internal.IProjectInspector;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.LibertyBuildPluginConfiguration;
import com.ibm.ws.st.liberty.buildplugin.integration.xml.internal.LibertyBuildPluginXMLConfigurationReader;
import com.ibm.ws.st.liberty.gradle.internal.LibertyGradleConstants;
import com.ibm.ws.st.liberty.gradle.internal.Trace;
import com.ibm.ws.st.liberty.gradle.manager.internal.LibertyGradleProjectMapping;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleScript;

public class GradleProjectInspector
implements IProjectInspector {
    private final IProject project;
    private LibertyBuildPluginConfiguration projectConfig;
    private LibertyBuildPluginConfiguration cachedProjectConfig;

    public GradleProjectInspector(IProject project) {
        this.project = project;
    }

    public LibertyBuildPluginConfiguration getBuildPluginConfiguration(IProgressMonitor monitor) {
        try {
            File configFile = this.getLibertyBuildPluginConfigFile(monitor);
            if (configFile == null) {
                return null;
            }
            if (this.projectConfig == null) {
                this.projectConfig = this.populateConfiguration(configFile, monitor);
            }
        }
        catch (Exception e) {
            Trace.trace((byte)0, "Error reading project configuration for project: " + this.project.getName(), e);
        }
        return this.projectConfig;
    }

    public LibertyBuildPluginConfiguration getCachedBuildPluginConfiguration(IProgressMonitor monitor) {
        try {
            File configFile = this.getCachedLibertyBuildPluginConfigurationFile(monitor);
            if (configFile == null) {
                return null;
            }
            if (this.cachedProjectConfig == null) {
                this.cachedProjectConfig = this.populateConfiguration(configFile, monitor);
            }
        }
        catch (Exception e) {
            Trace.logError("Error reading project configuration for project: " + this.project.getName(), e);
        }
        return this.cachedProjectConfig;
    }

    public File getCachedLibertyBuildPluginConfigurationFile(IProgressMonitor monitor) {
        IPath cachePath = LibertyGradleProjectMapping.getInstance().getLibertyBuildProjectCachePath(this.project.getName());
        if (cachePath == null) {
            return null;
        }
        return cachePath.toFile();
    }

    public boolean isSupportedProject(IProgressMonitor monitor) {
        try {
            if (!this.isGradleProject()) {
                return false;
            }
            File configFile = this.getLibertyBuildPluginConfigFile(monitor);
            if (configFile == null) {
                return false;
            }
            return configFile.exists();
        }
        catch (Exception e) {
            Trace.trace((byte)0, "Error encountered while checking whether project " + this.project.getName() + " is a Liberty Gradle enhanced project", e);
            return false;
        }
    }

    public boolean isGradleProject() {
        try {
            return this.project.hasNature("org.eclipse.buildship.core.gradleprojectnature");
        }
        catch (CoreException e) {
            Trace.trace((byte)0, "Error getting the description for the project " + this.project.getName(), e);
            return false;
        }
    }

    public File getLibertyBuildPluginConfigFile(IProgressMonitor mon) throws CoreException {
        IFile f = this.project.getFile("/build/liberty-plugin-config.xml");
        if (!f.exists()) {
            Trace.trace((byte)0, "The gradle project " + this.project.getName() + " does not have the liberty plugin config path.  Liberty Tools will not recognize this as a Liberty Gradle project.");
        }
        if (f != null && f.exists()) {
            return f.getLocation().toFile();
        }
        IFile buildGradleFile = this.project.getFile("build.gradle");
        IFile settingsGradleFile = this.project.getFile("settings.gradle");
        if (!buildGradleFile.exists() && !settingsGradleFile.exists()) {
            return null;
        }
        GradleProject gradleProject = this.getGradleProject(mon);
        if (gradleProject == null) {
            return null;
        }
        GradleScript build = gradleProject.getBuildScript();
        if (build == null) {
            return null;
        }
        File outputDirectory = gradleProject.getBuildDirectory();
        if (outputDirectory == null) {
            return null;
        }
        Path outputPath = new Path(outputDirectory.toString());
        IPath libertyPluginConfigPath = outputPath.append("liberty-plugin-config.xml");
        return libertyPluginConfigPath.toFile();
    }

    public LibertyBuildPluginConfiguration populateConfiguration(File configFile, IProgressMonitor monitor) throws IOException {
        if (monitor != null && monitor.isCanceled() || configFile == null || !configFile.exists()) {
            return null;
        }
        Trace.trace((byte)0, "Reading configFile from" + configFile.getAbsolutePath());
        LibertyBuildPluginXMLConfigurationReader reader = new LibertyBuildPluginXMLConfigurationReader();
        return reader.load(configFile.toURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GradleProject getGradleProject(IProgressMonitor monitor) {
        try (ProjectConnection connection = null;){
            GradleConnector gradleConnector = GradleConnector.newConnector();
            String override = System.getProperty("GRADLE_VERSION_OVERRIDE");
            if (override != null) {
                gradleConnector.useGradleVersion(override);
            }
            if (this.project.getLocation() != null) {
                GradleProject gradleProject;
                connection = gradleConnector.forProjectDirectory(new File(this.project.getLocation().toString())).connect();
                ModelBuilder model = connection.model(GradleProject.class);
                GradleProject gradleProject2 = gradleProject = (GradleProject)model.get();
                return gradleProject2;
            }
        }
        return null;
    }

    public boolean isSupportedModule(IModule module) {
        if (module == null) {
            Trace.trace((byte)0, "The gradle project " + this.project.getName() + " does not map to a supported module type.");
            return false;
        }
        String id = module.getModuleType().getId();
        if ("jst.web".equals(id) || "jst.ear".equals(id)) {
            return true;
        }
        Trace.trace((byte)0, "The gradle project " + this.project.getName() + " is detected as a module but does not specify a supported packaging type (eg. war packaging type).");
        return false;
    }

    public IModule[] getProjectModules() {
        IModule[] modules = new IModule[]{};
        try {
            IModule m = ServerUtil.getModule((IProject)this.project);
            if (m != null) {
                modules = new IModule[]{m};
            }
            StringBuffer moduleMsg = new StringBuffer("Found the following dependency modules for project " + this.project.getName() + ": {");
            for (int i = 0; i < modules.length; ++i) {
                if (i > 0) {
                    moduleMsg.append(", ");
                }
                moduleMsg.append(modules[i].getName());
            }
            moduleMsg.append("}");
            Trace.trace((byte)0, moduleMsg.toString());
        }
        catch (Exception e) {
            Trace.trace((byte)1, "Unable to retrieve modules for project " + this.project.getName() + ".", e);
        }
        return modules;
    }

    public LibertyGradleConstants.ProjectType getProjectType() {
        return LibertyGradleConstants.ProjectType.STANDARD;
    }
}

