/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.liberty.gradle.internal;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.DocumentLocation;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.AbstractCustomServerVariablesHandler;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.LibertyBuildPluginConfiguration;
import com.ibm.ws.st.liberty.gradle.internal.LibertyGradle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IServer;

public class CustomServerVariablesHandler
extends AbstractCustomServerVariablesHandler {
    protected LibertyBuildPluginConfiguration getLibertyBuildPluginConfiguration(IProject project) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (LibertyGradle.isGradleProject(project, (IProgressMonitor)monitor)) {
            return LibertyGradle.getLibertyGradleProjectConfiguration(project, (IProgressMonitor)monitor);
        }
        return null;
    }

    protected IProject getMappedProject(IServer server) {
        return LibertyGradle.getMappedProject(server);
    }

    protected void addInlineVars(IProject project, ConfigVars configVars, LibertyBuildPluginConfiguration libertyBuildProjectConfiguration) {
        URI buildScriptURI = this.obtainBuildScriptURI(project);
        if (libertyBuildProjectConfiguration != null && buildScriptURI != null) {
            DocumentLocation documentLocation = DocumentLocation.createDocumentLocation((URI)buildScriptURI, (DocumentLocation.Type)DocumentLocation.Type.BOOTSTRAP);
            Map bootstrapProperties = libertyBuildProjectConfiguration.getBootstrapProperties();
            for (String key : bootstrapProperties.keySet()) {
                String value = (String)bootstrapProperties.get(key);
                configVars.add(key, value, documentLocation);
            }
        }
    }

    private URI obtainBuildScriptURI(IProject project) {
        if (project == null) {
            return null;
        }
        try {
            return new URI(project.getLocationURI().toString() + "/" + "build.gradle");
        }
        catch (URISyntaxException exception) {
            Trace.logError((String)("Could not obtain URI to build.gradle in project " + project.getName()), (Throwable)exception);
            return null;
        }
    }
}

