/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.common.core.ext.internal.util;

import com.ibm.ws.st.common.core.ext.internal.Messages;
import com.ibm.ws.st.common.core.ext.internal.Trace;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.IPlatformHandler;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.PlatformUtil;
import com.ibm.ws.st.common.core.ext.internal.util.AbstractDockerMachine;
import com.ibm.ws.st.common.core.ext.internal.util.BaseDockerContainer;
import java.io.IOException;
import java.net.ConnectException;
import org.eclipse.osgi.util.NLS;

public class RemoteDockerContainer
extends BaseDockerContainer {
    public RemoteDockerContainer(String containerName, AbstractDockerMachine dockerMachine, IPlatformHandler platformHandler) {
        super(containerName, dockerMachine, platformHandler);
    }

    public RemoteDockerContainer(String containerName, String machineType, String machineName, IPlatformHandler platformHandler) {
        super(containerName, machineType, machineName, platformHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyIn(String sourcePath, String destinationPath) throws Exception {
        try {
            this.platformHandler.startSession();
            String tempDir = this.platformHandler.getTempDir();
            String tempPath = tempDir + this.getFileNameFromPath(sourcePath);
            this.platformHandler.uploadFile(sourcePath, tempPath);
            super.copyIn(tempPath, destinationPath);
            this.platformHandler.startSession();
            this.platformHandler.deleteFile(tempPath);
        }
        catch (Exception e) {
            Trace.logError("Failed to copy the file " + sourcePath + " to " + destinationPath, e);
        }
        finally {
            this.platformHandler.endSession();
        }
    }

    @Override
    public IPlatformHandler.ExecutionOutput copyOut(String sourcePath, String destinationPath, long timeout) throws ConnectException, IOException {
        try {
            this.platformHandler.startSession();
            String filename = this.getFileNameFromPath(destinationPath);
            String modifiedDestinationPath = this.platformHandler.getTempDir() + filename;
            if (this.platformHandler.getOS() == PlatformUtil.OperatingSystem.MAC) {
                this.platformHandler.executeCommand("touch " + modifiedDestinationPath);
            }
            IPlatformHandler.ExecutionOutput output = super.copyOut(sourcePath, modifiedDestinationPath, timeout);
            this.platformHandler.startSession();
            if (!this.platformHandler.fileExists(modifiedDestinationPath)) {
                throw new ConnectException(NLS.bind((String)Messages.errorFailedDockerCommand, (Object[])new String[]{Integer.toString(output.getReturnCode()), output.getOutput(), output.getError()}));
            }
            this.platformHandler.downloadFile(modifiedDestinationPath, destinationPath);
            IPlatformHandler.ExecutionOutput executionOutput = output;
            return executionOutput;
        }
        catch (Exception e) {
            throw new IOException(NLS.bind((String)Messages.errorCopyOut, (Object)sourcePath, (Object)destinationPath), e);
        }
        finally {
            this.platformHandler.endSession();
        }
    }
}

