/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.common.core.ext.internal.util;

import com.ibm.ws.st.common.core.ext.internal.Messages;
import com.ibm.ws.st.common.core.ext.internal.Trace;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.IPlatformHandler;
import com.ibm.ws.st.common.core.ext.internal.util.AbstractDockerMachine;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;

public class MinikubeDockerMachine
extends AbstractDockerMachine {
    private static final String PATTERN_IP_ADDR = "\\d{1,3}.\\d{1,3}.\\d{1,3}.\\d{1,3}";
    private static final Pattern patternIPAddr = Pattern.compile("\\d{1,3}.\\d{1,3}.\\d{1,3}.\\d{1,3}");
    Map<String, String> envMap = null;
    String hostIP = null;

    public MinikubeDockerMachine(IPlatformHandler platformHandler) {
        super(platformHandler);
    }

    @Override
    public boolean isRealMachine() {
        return false;
    }

    @Override
    public AbstractDockerMachine.MachineType getMachineType() {
        return AbstractDockerMachine.MachineType.MINIKUBE;
    }

    @Override
    public String getMachineName() {
        return "minikube";
    }

    @Override
    public String getHost() throws Exception {
        if (this.hostIP == null) {
            this.getEnv();
        }
        return this.hostIP;
    }

    @Override
    public Map<String, String> getDockerEnv() throws Exception {
        if (this.envMap == null) {
            this.getEnv();
        }
        return this.envMap;
    }

    public void getEnv() throws Exception {
        String[] lines;
        IPlatformHandler.ExecutionOutput result = this.platformHandler.executeCommand("minikube docker-env --shell cmd", DEFAULT_TIMEOUT * 2L);
        int exitValue = result.getReturnCode();
        String outputStr = result.getOutput();
        String error = result.getError();
        if (exitValue != 0) {
            Trace.logError("Error getting minikube docker env. Exit value = " + Integer.valueOf(exitValue) + " output: " + outputStr + " error: " + error, null);
            throw new RuntimeException(NLS.bind((String)Messages.errorFailedGettingDockerEnv, (Object[])new String[]{this.getMachineName(), Integer.toString(exitValue), error.trim()}));
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)7, "Environment variables for machine " + this.getMachineName() + " are: " + outputStr);
        }
        HashMap<String, String> env = new HashMap<String, String>();
        String ip = null;
        for (String line : lines = outputStr.split("[\r,\f,\n]+")) {
            String[] envVar;
            String[] tokens = line.split("[ ,\t]+");
            if (tokens.length != 2 || !"SET".equals(tokens[0]) || (envVar = tokens[1].split("[=]")).length != 2) continue;
            env.put(envVar[0], envVar[1]);
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Adding Minikube Docker environment variable name: " + envVar[0] + ", value: " + envVar[1]);
            }
            if (!envVar[0].equals("DOCKER_HOST")) continue;
            Matcher matcher = patternIPAddr.matcher(envVar[1]);
            if (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                ip = envVar[1].substring(start, end);
                if (!Trace.ENABLED) continue;
                Trace.trace((byte)0, "IP address for Minikube Docker machine: " + ip);
                continue;
            }
            if (!Trace.ENABLED) continue;
            Trace.trace((byte)1, "Failed to parse out the ip address from: " + envVar[1]);
        }
        this.envMap = env;
        this.hostIP = ip;
    }

    public String toString() {
        return this.getMachineName();
    }
}

