/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.common.core.ext.internal.util;

import com.ibm.ws.st.common.core.ext.internal.Messages;
import com.ibm.ws.st.common.core.ext.internal.Trace;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.IPlatformHandler;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.PlatformUtil;
import com.ibm.ws.st.common.core.ext.internal.util.AbstractDockerMachine;
import com.ibm.ws.st.common.core.ext.internal.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class BaseDockerContainer
implements IPlatformHandler {
    private static final String HOST_CONFIG_KEY = "HostConfig";
    private static final String PORT_BINDINGS_KEY = "PortBindings";
    private static final String PORT_SUFFIX = "/tcp";
    private static final String HOST_IP_KEY = "HostIp";
    private static final String HOST_PORT_KEY = "HostPort";
    private static final String PUBLISH_ALL_PORTS_KEY = "PublishAllPorts";
    private static final String CONFIG_KEY = "Config";
    private static final String IMAGE_KEY = "Image";
    private static final String CMD_KEY = "Cmd";
    private static final String ENV_KEY = "Env";
    private static final String MOUNTS_KEY = "Mounts";
    private static final String DESTINATION_KEY = "Destination";
    private static final String SOURCE_KEY = "Source";
    private String containerName;
    private final AbstractDockerMachine dockerMachine;
    protected final IPlatformHandler platformHandler;
    private JsonObject inspectObject = null;

    public BaseDockerContainer(String containerName, String machineType, String machineName, IPlatformHandler platformHandler) {
        this.containerName = containerName;
        this.dockerMachine = AbstractDockerMachine.createDockerMachine(machineType, machineName, platformHandler);
        this.platformHandler = platformHandler;
    }

    BaseDockerContainer(String containerName, AbstractDockerMachine dockerMachine, IPlatformHandler platformHandler) {
        this.containerName = containerName;
        this.dockerMachine = dockerMachine;
        this.platformHandler = platformHandler;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public AbstractDockerMachine getDockerMachine() {
        return this.dockerMachine;
    }

    public void copyIn(String sourcePath, String destinationPath) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("docker cp ");
        builder.append(this.getPathWithQuotes(sourcePath));
        builder.append(" " + this.containerName + ":");
        builder.append(destinationPath);
        this.runCommand(builder.toString(), true);
    }

    public void copyOut(String sourcePath, String destinationPath) throws ConnectException, IOException {
        this.copyOut(sourcePath, destinationPath, AbstractDockerMachine.DEFAULT_TIMEOUT);
    }

    public IPlatformHandler.ExecutionOutput copyOut(String sourcePath, String destinationPath, long timeout) throws ConnectException, IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("docker cp ");
        builder.append(this.containerName);
        builder.append(":");
        builder.append(sourcePath);
        builder.append(" ");
        builder.append(this.getPathWithQuotes(destinationPath));
        return this.runCommand(builder.toString(), true, timeout);
    }

    protected String getPathWithQuotes(String path) {
        String result = path;
        if (result.trim().indexOf(" ") > 0) {
            result = "\"" + path + "\"";
        }
        return result;
    }

    public IPlatformHandler.ExecutionOutput dockerExec(String command) throws ConnectException {
        String cmd = this.getExecCommand() + command;
        return this.runCommand(cmd, false);
    }

    public IPlatformHandler.ExecutionOutput dockerExec(String command, boolean checkExitValue, long timeout) throws ConnectException {
        String cmd = this.getExecCommand() + command;
        return this.runCommand(cmd, checkExitValue, timeout);
    }

    public IPlatformHandler.ExecutionOutput dockerExec(Map<String, String> cmdEnv, String command, boolean checkExitValue, long timeout, IProgressMonitor progressMonitor) throws ConnectException {
        String cmd = this.getExecCommand() + command;
        return this.runCommand(cmdEnv, cmd, checkExitValue, timeout, progressMonitor);
    }

    public IPlatformHandler.ExecutionOutput dockerRootExec(String command, boolean checkExitValue, long timeout) throws ConnectException {
        String cmd = this.getRootExecCommand() + command;
        return this.runCommand(cmd, checkExitValue, timeout);
    }

    @Override
    public boolean fileExists(String path) throws ConnectException {
        IPlatformHandler.ExecutionOutput result = this.dockerExec("test -f " + path);
        return result.getReturnCode() == 0;
    }

    @Override
    public boolean directoryExists(String path) throws ConnectException {
        IPlatformHandler.ExecutionOutput result = this.dockerExec("test -d " + path);
        return result.getReturnCode() == 0;
    }

    @Override
    public void deleteFile(String file) throws ConnectException {
        this.dockerExec("rm  " + file);
    }

    public void deleteFolder(String folder) throws ConnectException {
        this.dockerExec("rm -rf " + folder);
    }

    public IPlatformHandler.ExecutionOutput renameFile(String oldFileName, String newFileName) throws ConnectException {
        return this.dockerExec("mv " + oldFileName + " " + newFileName);
    }

    public boolean isRunning() throws ConnectException {
        String cmd = "docker inspect --format {{.State.Running}} " + this.containerName;
        IPlatformHandler.ExecutionOutput result = this.runCommand(cmd, true);
        boolean isRunning = "true".equals(result.getOutput().trim());
        if (Trace.ENABLED) {
            Trace.trace((byte)7, "Docker container " + this.toString() + " is running: " + isRunning);
        }
        return isRunning;
    }

    public String getLogs() throws ConnectException {
        String cmd = "docker logs " + this.containerName;
        IPlatformHandler.ExecutionOutput result = this.runCommand(cmd, true);
        String logs = result.getOutput().trim();
        return logs;
    }

    public String getPortMapping(String containerPort) throws ConnectException {
        String cmd = "docker port " + this.containerName + " " + containerPort;
        IPlatformHandler.ExecutionOutput result = this.runCommand(cmd, true);
        String mapping = result.getOutput().trim();
        if (Trace.ENABLED) {
            Trace.trace((byte)7, "Docker container " + this.toString() + " port mapping for " + containerPort + " is: " + mapping);
        }
        return mapping;
    }

    public String getHostMappedPort(String containerPort) throws Exception {
        String mapping = this.getPortMapping(containerPort);
        return BaseDockerContainer.getPortFromMapping(mapping);
    }

    public String getHostMappedIP(String containerPort) throws Exception {
        String host;
        String mapping = this.getPortMapping(containerPort);
        if (mapping.contains("\n")) {
            mapping = mapping.substring(0, mapping.indexOf("\n"));
        }
        if ((host = BaseDockerContainer.getHostFromMapping(mapping)) == null) {
            host = this.getDockerMachine().getHost();
        }
        return host;
    }

    public static String getPortFromMapping(String mapping) {
        int index = mapping.lastIndexOf(":");
        if (index >= 0) {
            String port = mapping.substring(index + 1);
            return port;
        }
        return mapping;
    }

    public static String getHostFromMapping(String mapping) {
        String host;
        int index = mapping.lastIndexOf(":");
        if (index >= 0 && !(host = mapping.substring(0, index)).isEmpty() && !host.equals("0.0.0.0")) {
            return host;
        }
        return null;
    }

    public List<String> getEnv() throws ConnectException {
        JsonArray envArray;
        ArrayList<String> env = new ArrayList<String>();
        JsonObject config = this.getConfig();
        if (config != null && (envArray = (JsonArray)config.get((Object)ENV_KEY)) != null) {
            for (int i = 0; i < envArray.size(); ++i) {
                env.add(envArray.getString(i));
            }
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)7, "Docker container " + this.toString() + " environment variables: " + env);
        }
        return env;
    }

    public Map<String, String> getPortBindings() throws ConnectException {
        JsonValue jsonValue;
        JsonObject inspect = this.getInspectOutput();
        HashMap<String, String> bindings = new HashMap<String, String>();
        JsonObject hostConfig = (JsonObject)inspect.get((Object)HOST_CONFIG_KEY);
        if (hostConfig != null && (jsonValue = (JsonValue)hostConfig.get((Object)PORT_BINDINGS_KEY)) instanceof JsonObject) {
            JsonObject portBindings = (JsonObject)jsonValue;
            for (Object key : portBindings.keySet()) {
                JsonArray portArray;
                String containerPort = (String)key;
                if (containerPort.endsWith(PORT_SUFFIX)) {
                    containerPort = containerPort.substring(0, containerPort.length() - PORT_SUFFIX.length());
                }
                if ((portArray = (JsonArray)portBindings.get(key)) == null || portArray.size() <= 0) continue;
                JsonObject portObject = (JsonObject)portArray.get(0);
                String hostIP = portObject.getString(HOST_IP_KEY);
                String hostPort = portObject.getString(HOST_PORT_KEY);
                if (hostIP.isEmpty()) {
                    bindings.put(containerPort, hostPort);
                    continue;
                }
                bindings.put(containerPort, hostIP + ":" + hostPort);
            }
        }
        return bindings;
    }

    public boolean getPublishAllPorts() throws ConnectException {
        JsonObject inspect = this.getInspectOutput();
        JsonObject hostConfig = (JsonObject)inspect.get((Object)HOST_CONFIG_KEY);
        if (hostConfig != null) {
            boolean publishAllPorts = hostConfig.getBoolean(PUBLISH_ALL_PORTS_KEY, false);
            return publishAllPorts;
        }
        return false;
    }

    public List<String> getCommand() throws ConnectException {
        JsonArray cmdArray;
        ArrayList<String> cmd = new ArrayList<String>();
        JsonObject config = this.getConfig();
        if (config != null && (cmdArray = (JsonArray)config.get((Object)CMD_KEY)) != null) {
            for (int i = 0; i < cmdArray.size(); ++i) {
                cmd.add(cmdArray.getString(i));
            }
        }
        return cmd;
    }

    public String getImageName() throws ConnectException {
        String imageName = null;
        JsonObject config = this.getConfig();
        if (config != null) {
            imageName = config.getString(IMAGE_KEY);
        }
        return imageName;
    }

    public void stop() throws ConnectException {
        this.stop((IProgressMonitor)new NullProgressMonitor());
    }

    public void stop(IProgressMonitor monitor) throws ConnectException {
        String cmd = "docker stop " + this.containerName;
        this.runCommand(cmd, true, AbstractDockerMachine.DEFAULT_TIMEOUT * 5L, monitor);
    }

    public void start() throws ConnectException {
        this.start((IProgressMonitor)new NullProgressMonitor());
    }

    public void start(IProgressMonitor monitor) throws ConnectException {
        String cmd = "docker start " + this.containerName;
        this.runCommand(cmd, true, AbstractDockerMachine.DEFAULT_TIMEOUT * 5L, monitor);
    }

    public void commit(String imageName) throws ConnectException {
        String cmd = "docker commit " + this.containerName + " " + imageName;
        this.runCommand(cmd, true, AbstractDockerMachine.DEFAULT_TIMEOUT * 5L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean flatten(String imageName, IProgressMonitor progressMonitor) throws Exception {
        IProgressMonitor monitor = progressMonitor;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String tmpFile = "";
        try {
            this.platformHandler.startSession();
            tmpFile = this.getTmpFileName(this.containerName, ".tar");
            int retries = 0;
            while (this.platformHandler.fileExists(tmpFile) && retries++ < 100) {
                tmpFile = this.getTmpFileName(this.containerName, ".tar");
            }
            String path = this.getPathWithQuotes(tmpFile);
            String cmd = "docker export --output " + path + " " + this.containerName;
            monitor.beginTask(NLS.bind((String)Messages.flattenExportContainer, (Object)this.containerName), -1);
            this.runCommand(cmd, true, 300000L + AbstractDockerMachine.DEFAULT_TIMEOUT, monitor);
            if (monitor.isCanceled()) {
                boolean bl = false;
                return bl;
            }
            monitor.setTaskName(NLS.bind((String)Messages.flattenImportImage, (Object)imageName));
            cmd = "docker import " + path + " " + imageName;
            this.runCommand(cmd, true, 300000L + AbstractDockerMachine.DEFAULT_TIMEOUT, monitor);
            if (monitor.isCanceled()) {
                block36: {
                    try {
                        this.getDockerMachine().removeImage(imageName);
                    }
                    catch (Exception e1) {
                        if (!Trace.ENABLED) break block36;
                        Trace.logError("Docker import cancelled but unable to remove image: " + imageName + ". The image may still exist.", e1);
                    }
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            try {
                this.getDockerMachine().removeImage(imageName);
                return false;
            }
            catch (Exception e1) {
                Trace.logError("Docker flatten image encountered problems. Failed to remove the image: " + imageName + ". The image may still exist.", e1);
                return false;
            }
        }
        finally {
            block37: {
                try {
                    if (this.platformHandler.fileExists(tmpFile)) {
                        this.platformHandler.deleteFile(tmpFile);
                    }
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block37;
                    Trace.trace((byte)0, "Failed to delete temporary file for exported container: " + tmpFile);
                }
            }
            try {
                this.platformHandler.endSession();
            }
            catch (Exception exception) {}
        }
    }

    public void rename(String name) throws ConnectException {
        String cmd = "docker rename " + this.containerName + " " + name;
        this.runCommand(cmd, true);
        this.containerName = name;
    }

    public List<DockerProcess> getContainerProcesses() throws ConnectException {
        String cmd = "docker top " + this.containerName;
        IPlatformHandler.ExecutionOutput result = this.runCommand(cmd, true);
        String output = result.getOutput();
        String[] lines = output.split("[\r\n]+");
        ArrayList<DockerProcess> processes = new ArrayList<DockerProcess>();
        for (int i = 1; i < lines.length; ++i) {
            String[] words = lines[i].split("\\s");
            if (words.length < 3) continue;
            ArrayList<String> processCmd = new ArrayList<String>(words.length - 2);
            for (int j = 2; j < words.length; ++j) {
                processCmd.add(words[j]);
            }
            DockerProcess process = new DockerProcess(words[0], words[1], processCmd);
            processes.add(process);
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)7, "Docker container " + this.toString() + " process information: " + processes);
        }
        return processes;
    }

    private JsonObject getConfig() throws ConnectException {
        JsonObject inspect = this.getInspectOutput();
        return (JsonObject)inspect.get((Object)CONFIG_KEY);
    }

    private synchronized JsonObject getInspectOutput() throws ConnectException {
        if (this.inspectObject == null) {
            try {
                IPlatformHandler.ExecutionOutput result = this.runCommand("docker inspect " + this.containerName, true);
                ByteArrayInputStream stream = new ByteArrayInputStream(result.getOutput().getBytes());
                JsonReader reader = Json.createReader((InputStream)stream);
                JsonArray inspectArray = reader.readArray();
                this.inspectObject = (JsonObject)inspectArray.get(0);
            }
            catch (Exception e) {
                throw new ConnectException(e.getMessage());
            }
        }
        return this.inspectObject;
    }

    protected IPlatformHandler.ExecutionOutput runCommand(String command, boolean checkExitValue) throws ConnectException {
        return this.runCommand(null, command, checkExitValue, AbstractDockerMachine.DEFAULT_TIMEOUT, null);
    }

    protected IPlatformHandler.ExecutionOutput runCommand(String command, boolean checkExitValue, long timeout) throws ConnectException {
        return this.runCommand(null, command, checkExitValue, timeout, null);
    }

    protected IPlatformHandler.ExecutionOutput runCommand(String command, boolean checkExitValue, long timeout, IProgressMonitor monitor) throws ConnectException {
        return this.runCommand(null, command, checkExitValue, timeout, monitor);
    }

    protected IPlatformHandler.ExecutionOutput runCommand(Map<String, String> cmdEnv, String command, boolean checkExitValue, long timeout, IProgressMonitor monitor) throws ConnectException {
        try {
            this.platformHandler.startSession();
            Map<String, String> envMap = this.dockerMachine.getDockerEnv();
            if (envMap == null) {
                envMap = new HashMap<String, String>(4);
            }
            if (cmdEnv != null) {
                envMap.putAll(cmdEnv);
            }
            IPlatformHandler.ExecutionOutput result = this.platformHandler.executeCommand(envMap, command, timeout, monitor);
            if (checkExitValue && result.getReturnCode() != 0) {
                if (Trace.ENABLED) {
                    Trace.logError("Docker command failed: " + command + ", exit value: " + result.getReturnCode() + ", output: " + result.getOutput() + ", error: " + result.getError(), null);
                }
                throw new IOException(NLS.bind((String)Messages.errorFailedDockerCommand, (Object[])new String[]{command, Integer.toString(result.getReturnCode()), result.getError()}));
            }
            IPlatformHandler.ExecutionOutput executionOutput = result;
            return executionOutput;
        }
        catch (Exception e) {
            throw new ConnectException(e.getMessage());
        }
        finally {
            this.platformHandler.endSession();
        }
    }

    private String getExecCommand() {
        return "docker exec -i " + this.containerName + " ";
    }

    private String getRootExecCommand() {
        return "docker exec --user root " + this.containerName + " ";
    }

    public String toString() {
        return "(" + this.dockerMachine + ") " + this.containerName;
    }

    @Override
    public void startSession() throws Exception {
        this.platformHandler.startSession();
    }

    @Override
    public void createDirectory(String path) throws ConnectException, IOException {
        try {
            this.dockerExec("mkdir -p " + path);
        }
        catch (Exception e) {
            throw new ConnectException(e.getMessage());
        }
    }

    @Override
    public void uploadFile(String sourcePath, String destinationPath) throws Exception {
        this.copyIn(sourcePath, destinationPath);
        this.dockerRootExec("sh -c \"chmod 664 " + destinationPath + "\"", true, AbstractDockerMachine.DEFAULT_TIMEOUT);
    }

    @Override
    public void downloadFile(String sourcePath, String destinationPath) throws ConnectException, IOException {
        this.copyOut(sourcePath, destinationPath);
    }

    @Override
    public IPlatformHandler.ExecutionOutput executeCommand(String command) throws Exception {
        return this.dockerExec(command);
    }

    @Override
    public IPlatformHandler.ExecutionOutput executeCommand(String command, long timeout) throws Exception {
        return this.executeCommand(null, command, timeout, null);
    }

    @Override
    public IPlatformHandler.ExecutionOutput executeCommand(Map<String, String> cmdEnv, String command, long timeout) throws Exception {
        return this.executeCommand(cmdEnv, command, timeout, null);
    }

    @Override
    public IPlatformHandler.ExecutionOutput executeCommand(Map<String, String> env, String command, long timeout, IProgressMonitor monitor) throws Exception {
        return this.dockerExec(env, command, true, timeout, monitor);
    }

    @Override
    public void endSession() throws ConnectException {
        this.platformHandler.endSession();
    }

    @Override
    public String getEnvValue(String var) throws ConnectException, IOException {
        for (String key : this.getEnv()) {
            if (!key.contains(var)) continue;
            return key.split("=")[1];
        }
        return null;
    }

    @Override
    public String getTempDir() throws IOException {
        throw new IOException(Messages.errorDockerTempDir);
    }

    private String getTmpFileName(String name, String extension) throws Exception {
        int i = (int)(Math.random() * 10000.0);
        String tmpFile = this.platformHandler.getTempDir() + this.containerName + i + extension;
        return tmpFile;
    }

    protected String getFileNameFromPath(String destinationPath) {
        int index = destinationPath.lastIndexOf("/");
        if (index == -1) {
            index = destinationPath.lastIndexOf("\\");
        }
        return destinationPath.substring(index + 1);
    }

    @Override
    public PlatformUtil.OperatingSystem getOS() throws Exception {
        return this.platformHandler.getOS();
    }

    public Map<String, String> getAllMountedVolumes() throws Exception {
        Object mounts;
        HashMap<String, String> volumes = new HashMap<String, String>();
        JsonObject inspect = this.getInspectOutput();
        if (inspect.containsKey((Object)MOUNTS_KEY) && (mounts = inspect.get((Object)MOUNTS_KEY)) instanceof JsonArray) {
            JsonArray mountsArray = (JsonArray)mounts;
            for (Object item : mountsArray) {
                if (!(item instanceof JsonObject)) continue;
                JsonObject jsonObj = (JsonObject)item;
                String destination = jsonObj.getString(DESTINATION_KEY);
                String source = jsonObj.getString(SOURCE_KEY);
                volumes.put(source, destination);
            }
        }
        return volumes;
    }

    public Map<IPath, IPath> getMountedVolumeHash() throws Exception {
        HashMap<Path, Path> volumeHash = null;
        ArrayList volumes = new ArrayList();
        JsonObject inspect = this.getInspectOutput();
        if (inspect.containsKey((Object)MOUNTS_KEY)) {
            Object mounts = inspect.get((Object)MOUNTS_KEY);
            if (mounts instanceof JsonArray) {
                JsonArray mountsArray = (JsonArray)mounts;
                volumeHash = new HashMap<Path, Path>(mountsArray.size());
                for (Object item : mountsArray) {
                    if (item instanceof JsonObject) {
                        JsonObject jsonObj = (JsonObject)item;
                        String destination = jsonObj.getString(DESTINATION_KEY);
                        String source = jsonObj.getString(SOURCE_KEY);
                        Path sourcePath = new Path(source);
                        sourcePath = BaseDockerContainer.getContainerToLocalPath((IPath)sourcePath);
                        volumeHash.put(sourcePath, new Path(destination));
                        continue;
                    }
                    if (!Trace.ENABLED) continue;
                    Trace.trace((byte)1, "A mount item in the inspect output for the " + this.getContainerName() + " container was not an instance of JsonObject.");
                }
            } else if (Trace.ENABLED) {
                Trace.trace((byte)1, "The mounts in the inspect output for the " + this.getContainerName() + " container were not an instance of JsonArray.");
            }
        } else if (Trace.ENABLED) {
            Trace.trace((byte)0, "The inspect output for the " + this.getContainerName() + " container did not contain any mounts.");
        }
        return volumeHash;
    }

    public String getMountSourceForDestination(String destinationValue) throws Exception {
        Object mounts;
        JsonObject inspect = this.getInspectOutput();
        if (inspect.containsKey((Object)MOUNTS_KEY) && (mounts = inspect.get((Object)MOUNTS_KEY)) instanceof JsonArray) {
            JsonArray mountsArray = (JsonArray)mounts;
            for (Object item : mountsArray) {
                String srcValue;
                JsonObject jsonObj;
                String destination;
                if (!(item instanceof JsonObject) || !destinationValue.equals(destination = (jsonObj = (JsonObject)item).getString(DESTINATION_KEY)) || (srcValue = jsonObj.getString(SOURCE_KEY)) == null || srcValue.equals("")) continue;
                return srcValue;
            }
        }
        return null;
    }

    public IPath getMountDestinationForSource(IPath sourceValue) throws Exception {
        Object mounts;
        JsonObject inspect = this.getInspectOutput();
        if (inspect.containsKey((Object)MOUNTS_KEY) && (mounts = inspect.get((Object)MOUNTS_KEY)) instanceof JsonArray) {
            JsonArray mountsArray = (JsonArray)mounts;
            for (Object item : mountsArray) {
                String destinationValue;
                if (!(item instanceof JsonObject)) continue;
                JsonObject jsonObj = (JsonObject)item;
                String source = jsonObj.getString(SOURCE_KEY);
                if (!sourceValue.toString().equals(source) || (destinationValue = jsonObj.getString(DESTINATION_KEY)) == null || destinationValue.equals("")) continue;
                return new Path(destinationValue);
            }
        }
        return null;
    }

    public List<String> getContentsOfFolder(String containerFolder) throws ConnectException {
        ArrayList<String> contents = null;
        IPlatformHandler.ExecutionOutput results = this.dockerExec("ls " + containerFolder, true, AbstractDockerMachine.DEFAULT_TIMEOUT);
        String output = results.getOutput();
        if (output != null && output.length() > 0) {
            contents = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(output, "\n");
            while (st.hasMoreTokens()) {
                contents.add(st.nextToken());
            }
        }
        return contents;
    }

    public static IPath getContainerToLocalPath(IPath tempDirectory) {
        boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");
        IPath updatedTempDirectory = null;
        if (isWindows) {
            String winPath;
            if (tempDirectory.segment(0).equals("host_mnt")) {
                String device = tempDirectory.toString().substring(10, 11);
                winPath = device + ":" + tempDirectory.toString().substring(11);
            } else {
                String device = tempDirectory.toString().substring(1, 2);
                winPath = device + ":" + tempDirectory.toString().substring(2);
            }
            updatedTempDirectory = new Path(winPath);
        } else {
            updatedTempDirectory = tempDirectory;
        }
        return FileUtil.getCanonicalPath(updatedTempDirectory);
    }

    public static IPath getLocalToContainerPath(IPath tempDirectory) {
        boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");
        IPath updatedTempDirectory = null;
        if (isWindows) {
            String device = tempDirectory.getDevice().toLowerCase();
            String winPath = "/" + device.substring(0, 1) + tempDirectory.toString().substring(2);
            updatedTempDirectory = new Path(winPath);
        } else {
            updatedTempDirectory = tempDirectory;
        }
        return updatedTempDirectory;
    }

    public static class DockerProcess {
        String pid;
        String user;
        List<String> command;

        public DockerProcess(String pid, String user, List<String> command) {
            this.pid = pid;
            this.user = user;
            this.command = command;
        }

        public String getPID() {
            return this.pid;
        }

        public String getUser() {
            return this.user;
        }

        public List<String> getCommand() {
            return this.command;
        }

        public String toString() {
            return "Id: " + this.pid + ", User: " + this.user + ", Command: " + this.command;
        }
    }
}

