/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.common.core.ext.internal.util;

import com.ibm.ws.st.common.core.ext.internal.Messages;
import com.ibm.ws.st.common.core.ext.internal.Trace;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.IPlatformHandler;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.LocalHandler;
import com.ibm.ws.st.common.core.ext.internal.util.BaseDockerContainer;
import com.ibm.ws.st.common.core.ext.internal.util.DockerMachine;
import com.ibm.ws.st.common.core.ext.internal.util.MinikubeDockerMachine;
import com.ibm.ws.st.common.core.ext.internal.util.PhantomDockerMachine;
import com.ibm.ws.st.common.core.ext.internal.util.RemoteDockerContainer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractDockerMachine {
    public static long DEFAULT_TIMEOUT = 10000L;
    protected IPlatformHandler platformHandler;

    public static MachineType getMachineType(String typeName, String machineName) {
        MachineType type = MachineType.getMachineType(typeName);
        if (type == null) {
            type = machineName != null ? MachineType.STANDARD : MachineType.PHANTOM;
        }
        return type;
    }

    public AbstractDockerMachine(IPlatformHandler platformHandler) {
        this.platformHandler = platformHandler;
    }

    public static boolean isDockerInstalled(IPlatformHandler platformHandler) {
        if (AbstractDockerMachine.hasNativeDocker(platformHandler)) {
            return true;
        }
        if (AbstractDockerMachine.hasDockerMachine(platformHandler)) {
            return true;
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Could not detect that Docker is installed.");
        }
        return false;
    }

    public static boolean hasNativeDocker(IPlatformHandler platformHandler) {
        String cmd = "docker ps";
        try {
            IPlatformHandler.ExecutionOutput result = AbstractDockerMachine.runCommand(cmd, true, platformHandler);
            if (Trace.ENABLED) {
                cmd = "docker version";
                try {
                    result = AbstractDockerMachine.runCommand(cmd, true, platformHandler);
                    Trace.trace((byte)0, "Docker is running natively at version: " + result.getOutput());
                }
                catch (Exception e) {
                    Trace.trace((byte)0, "Execution of '" + cmd + "' failed.", e);
                }
            }
            return true;
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Execution of '" + cmd + "' failed.", e);
            }
            return false;
        }
    }

    public static boolean hasDockerMachine(IPlatformHandler platformHandler) {
        String cmd = "docker-machine version";
        try {
            IPlatformHandler.ExecutionOutput result = AbstractDockerMachine.runCommand(cmd, true, platformHandler);
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Docker toolbox is running at version: " + result.getOutput());
            }
            return true;
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Execution of '" + cmd + "' failed.", e);
            }
            return false;
        }
    }

    public static boolean hasMiniKubeDockerMachine(IPlatformHandler platformHandler) {
        String cmd = "minikube docker-env --shell cmd";
        try {
            IPlatformHandler.ExecutionOutput result = AbstractDockerMachine.runCommand(cmd, true, platformHandler);
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Minikube docker env: " + result.getOutput());
            }
            return true;
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Execution of '" + cmd + "' failed.", e);
            }
            return false;
        }
    }

    public static AbstractDockerMachine createDockerMachine(String machineType, String machineName, IPlatformHandler platformHandler) {
        MachineType type = AbstractDockerMachine.getMachineType(machineType, machineName);
        return AbstractDockerMachine.createDockerMachine(type, machineName, platformHandler);
    }

    public static AbstractDockerMachine createDockerMachine(MachineType type, String machineName, IPlatformHandler platformHandler) {
        switch (type) {
            case STANDARD: {
                return new DockerMachine(machineName, platformHandler);
            }
            case PHANTOM: {
                return new PhantomDockerMachine(platformHandler);
            }
            case MINIKUBE: {
                return new MinikubeDockerMachine(platformHandler);
            }
        }
        return new PhantomDockerMachine(platformHandler);
    }

    public abstract boolean isRealMachine();

    public abstract MachineType getMachineType();

    public abstract String getMachineName();

    public abstract String getHost() throws Exception;

    public abstract Map<String, String> getDockerEnv() throws Exception;

    public IPlatformHandler getplatformHandler() {
        return this.platformHandler;
    }

    public List<BaseDockerContainer> getContainers(boolean allDefined) throws Exception {
        List<String> names = this.getContainerNames(allDefined);
        ArrayList<BaseDockerContainer> containers = new ArrayList<BaseDockerContainer>(names.size());
        for (String name : names) {
            if (this.platformHandler instanceof LocalHandler) {
                containers.add(new BaseDockerContainer(name, this, this.platformHandler));
                continue;
            }
            containers.add(new RemoteDockerContainer(name, this, this.platformHandler));
        }
        return containers;
    }

    public List<String> getContainerNames(boolean allDefined) throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append("docker ps");
        if (allDefined) {
            builder.append(" -a");
        }
        builder.append(" --format {{.Names}}");
        IPlatformHandler.ExecutionOutput result = this.runCommand(builder.toString(), true);
        String[] names = result.getOutput().split("[\r\n]+");
        ArrayList<String> list = new ArrayList<String>(names.length);
        for (String name : names) {
            String containerName = name.trim();
            if (containerName.isEmpty()) continue;
            list.add(containerName);
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)7, "Found the following containers: " + list);
        }
        return list;
    }

    public List<String> getImages() throws Exception {
        ArrayList<String> images = new ArrayList<String>();
        IPlatformHandler.ExecutionOutput result = this.runCommand("docker images", true);
        String[] lines = result.getOutput().split("[\r\n]+");
        if (lines.length < 1) {
            return images;
        }
        for (int i = 1; i < lines.length; ++i) {
            String[] entries = lines[i].split("\\s");
            if (entries.length <= 0) continue;
            images.add(entries[0]);
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)7, "Found the following images: " + images);
        }
        return images;
    }

    public void removeImage(String imageName) throws Exception {
        String cmd = "docker rmi " + imageName;
        this.runCommand(cmd, true);
    }

    public void removeContainer(String containerName) throws Exception {
        this.removeContainer(containerName, false);
    }

    public void removeContainer(String containerName, boolean force) throws Exception {
        String cmd = force ? "docker rm -f " + containerName : "docker rm " + containerName;
        this.runCommand(cmd, true);
    }

    public long getImageSize(String imageName) throws Exception {
        String cmd = "docker inspect --format {{.Size}} " + imageName;
        IPlatformHandler.ExecutionOutput result = this.runCommand(cmd, true);
        String output = result.getOutput().trim();
        long size = Long.parseLong(output);
        return size;
    }

    public static List<AbstractDockerMachine> getDockerMachines(IPlatformHandler platformHandler) throws Exception {
        ArrayList<AbstractDockerMachine> machineList = new ArrayList<AbstractDockerMachine>();
        if (AbstractDockerMachine.hasNativeDocker(platformHandler)) {
            machineList.add(AbstractDockerMachine.createDockerMachine(MachineType.PHANTOM, null, platformHandler));
        }
        if (AbstractDockerMachine.hasDockerMachine(platformHandler)) {
            IPlatformHandler.ExecutionOutput result = AbstractDockerMachine.runCommand("docker-machine ls", true, platformHandler);
            String[] machines = result.getOutput().split("[\r\n]+");
            for (int i = 1; i < machines.length; ++i) {
                if (machines[i].trim().isEmpty()) continue;
                String[] machineInfo = machines[i].split("[ \t]+");
                String name = machineInfo[0];
                machineList.add(AbstractDockerMachine.createDockerMachine(MachineType.STANDARD, name, platformHandler));
            }
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)7, "Found the following machines: " + machineList);
        }
        return machineList;
    }

    public IPlatformHandler.ExecutionOutput runCommand(String command, boolean checkExitValue) throws Exception {
        return AbstractDockerMachine.runCommand(this.getDockerEnv(), command, checkExitValue, this.platformHandler, DEFAULT_TIMEOUT, (IProgressMonitor)new NullProgressMonitor());
    }

    public IPlatformHandler.ExecutionOutput runCommand(String command, boolean checkExitValue, long timeout) throws Exception {
        return AbstractDockerMachine.runCommand(this.getDockerEnv(), command, checkExitValue, this.platformHandler, timeout, (IProgressMonitor)new NullProgressMonitor());
    }

    public IPlatformHandler.ExecutionOutput runCommand(String command, boolean checkExitValue, long timeout, IProgressMonitor monitor) throws Exception {
        return AbstractDockerMachine.runCommand(this.getDockerEnv(), command, checkExitValue, this.platformHandler, timeout, (IProgressMonitor)new NullProgressMonitor());
    }

    protected static IPlatformHandler.ExecutionOutput runCommand(String command, boolean checkExitValue, IPlatformHandler platformHandler) throws Exception {
        return AbstractDockerMachine.runCommand(null, command, checkExitValue, platformHandler, DEFAULT_TIMEOUT, (IProgressMonitor)new NullProgressMonitor());
    }

    private static IPlatformHandler.ExecutionOutput runCommand(Map<String, String> env, String command, boolean checkExitValue, IPlatformHandler platformHandler, long timeout, IProgressMonitor monitor) throws Exception {
        IPlatformHandler.ExecutionOutput result = platformHandler.executeCommand(env, command, timeout, monitor);
        if (checkExitValue && result.getReturnCode() != 0) {
            String output = result.getOutput();
            String error = result.getError();
            if (Trace.ENABLED) {
                Trace.logError("Docker command failed: " + command + ", exit value: " + result.getReturnCode() + ", output: " + output + ", error: " + error, null);
            }
            throw new IOException(NLS.bind((String)Messages.errorFailedDockerCommand, (Object[])new String[]{command, Integer.toString(result.getReturnCode()), error}));
        }
        return result;
    }

    static {
        String timeout = System.getProperty("com.ibm.ws.st.DockerCommandTimeoutInSeconds");
        if (timeout != null) {
            try {
                DEFAULT_TIMEOUT = Long.parseLong(timeout);
                DEFAULT_TIMEOUT *= 1000L;
            }
            catch (NumberFormatException e) {
                Trace.logError("The Docker command timeout value is not a valid integer: " + timeout, e);
            }
        }
    }

    public static enum MachineType {
        STANDARD,
        PHANTOM,
        MINIKUBE;


        public static MachineType getMachineType(String name) {
            for (MachineType type : MachineType.values()) {
                if (!type.name().equals(name)) continue;
                return type;
            }
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "The " + name + " machine type is not recognized.");
            }
            return null;
        }
    }
}

