/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.common.core.ext.internal.trace;

import com.ibm.ws.st.common.core.ext.internal.trace.TraceDebugListener;
import com.ibm.ws.st.common.core.ext.internal.trace.TraceLevel;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;

public class TraceSpecification
implements DebugOptionsListener {
    private boolean isInfoEnabled = false;
    private boolean isWarningEnabled = false;
    private boolean isResourceEnabled = false;
    private boolean isExtensionEnabled = false;
    private boolean isPerfEnabled = false;
    private boolean isJMXEnabled = false;
    private boolean isErrorEnabled = false;
    private boolean isDetailsEnabled = false;
    private boolean isSSMEnabled = false;
    private boolean isSecurityEnabled = false;
    private final String debugOption;
    private final byte[] recognizedLevels;
    private final TraceDebugListener listener;

    public TraceSpecification(String pluginId, byte[] recognizedLevels, TraceDebugListener listener) {
        this.debugOption = pluginId + "/debug";
        this.recognizedLevels = new byte[recognizedLevels.length];
        System.arraycopy(recognizedLevels, 0, this.recognizedLevels, 0, recognizedLevels.length);
        this.listener = listener;
    }

    public void optionsChanged(DebugOptions options) {
        boolean debugOptionEnabled = options.getBooleanOption(this.debugOption, false);
        if (debugOptionEnabled && this.recognizedLevels != null) {
            for (byte level : this.recognizedLevels) {
                String debugOptionName = TraceLevel.getDebugOptionName(level);
                if (debugOptionName == null) continue;
                boolean value = options.getBooleanOption(this.debugOption + "/" + debugOptionName, false);
                this.setLevelEnabled(level, value);
            }
        } else {
            this.resetOptions();
        }
        if (this.listener != null) {
            this.listener.debugChanged(debugOptionEnabled);
        }
    }

    private void resetOptions() {
        this.isInfoEnabled = false;
        this.isWarningEnabled = false;
        this.isResourceEnabled = false;
        this.isExtensionEnabled = false;
        this.isPerfEnabled = false;
        this.isJMXEnabled = false;
        this.isErrorEnabled = false;
        this.isDetailsEnabled = false;
        this.isSSMEnabled = false;
        this.isSecurityEnabled = false;
    }

    private final void setLevelEnabled(byte level, boolean value) {
        switch (level) {
            case 0: {
                this.isInfoEnabled = value;
                break;
            }
            case 1: {
                this.isWarningEnabled = value;
                break;
            }
            case 4: {
                this.isPerfEnabled = value;
                break;
            }
            case 2: {
                this.isResourceEnabled = value;
                break;
            }
            case 3: {
                this.isExtensionEnabled = value;
                break;
            }
            case 5: {
                this.isJMXEnabled = value;
                break;
            }
            case 6: {
                this.isErrorEnabled = value;
                break;
            }
            case 7: {
                this.isDetailsEnabled = value;
                break;
            }
            case 8: {
                this.isSSMEnabled = value;
            }
            case 9: {
                this.isSecurityEnabled = value;
            }
        }
    }

    public final boolean isLevelEnabled(byte level) {
        switch (level) {
            case 0: {
                return this.isInfoEnabled;
            }
            case 1: {
                return this.isWarningEnabled;
            }
            case 4: {
                return this.isPerfEnabled;
            }
            case 2: {
                return this.isResourceEnabled;
            }
            case 3: {
                return this.isExtensionEnabled;
            }
            case 5: {
                return this.isJMXEnabled;
            }
            case 6: {
                return this.isErrorEnabled;
            }
            case 7: {
                return this.isDetailsEnabled;
            }
            case 8: {
                return this.isSSMEnabled;
            }
            case 9: {
                return this.isSecurityEnabled;
            }
        }
        return false;
    }
}

