/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.common.core.ext.internal.setuphandlers;

import com.ibm.ws.st.common.core.ext.internal.Trace;

public class PlatformUtil {
    public static OperatingSystem getOS(String osName) {
        if (osName == null || osName.isEmpty()) {
            Trace.logError("The operating system name is null or empty, defaulting to Linux.", null);
            return OperatingSystem.LINUX;
        }
        String name = osName.toLowerCase();
        if (name.contains("win")) {
            return OperatingSystem.WINDOWS;
        }
        if (name.contains("mac")) {
            return OperatingSystem.MAC;
        }
        if (name.contains("linux")) {
            return OperatingSystem.LINUX;
        }
        Trace.logError("The operating system name is not valid: " + osName + ", defaulting to Linux.", null);
        return OperatingSystem.LINUX;
    }

    public static enum OperatingSystem {
        LINUX,
        MAC,
        WINDOWS;

    }
}

