/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.common.core.ext.internal;

import com.ibm.ws.st.common.core.ext.internal.trace.TraceLevel;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TraceUtil {
    private static final String CLASS_NAME = TraceUtil.class.getName();
    private static final SimpleDateFormat SDF = new SimpleDateFormat("dd/MM/yy HH:mm.ss.SSS");

    public static final void perf(String s, long time, String traceClassName) {
        StringBuilder sb = new StringBuilder(s);
        sb.append(" <");
        sb.append(System.currentTimeMillis() - time);
        sb.append(">");
        TraceUtil.trace((byte)4, sb.toString(), null, traceClassName);
    }

    public static final void trace(byte level, String s, Throwable t, String traceClassName) {
        String levelName = TraceLevel.getLevelName(level);
        StringBuilder sb = new StringBuilder(TraceUtil.getFormattedDate());
        sb.append(" ");
        sb.append(levelName);
        StackTraceElement caller = TraceUtil.getCaller(traceClassName);
        if (caller != null) {
            sb.append(caller.getClassName());
            sb.append("::");
            sb.append(caller.getMethodName());
            sb.append('\t');
        }
        sb.append(s);
        System.out.println(sb.toString());
        if (t != null) {
            t.printStackTrace(System.out);
        }
    }

    private static String getFormattedDate() {
        return SDF.format(new Date());
    }

    private static StackTraceElement getCaller(String traceClassName) {
        Exception ex = new Exception();
        StackTraceElement[] ste = ex.getStackTrace();
        for (int i = 0; i < ste.length; ++i) {
            StackTraceElement s = ste[i];
            String className = s.getClassName();
            if (className.equals(CLASS_NAME) || className.equals(traceClassName)) continue;
            return s;
        }
        return null;
    }
}

