/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.docker.core.internal.launch;

import com.ibm.ws.st.common.core.ext.internal.setuphandlers.IPlatformHandler;
import com.ibm.ws.st.common.core.ext.internal.util.AbstractDockerMachine;
import com.ibm.ws.st.common.core.ext.internal.util.BaseDockerContainer;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.UtilityExtension;
import com.ibm.ws.st.core.internal.UtilityExtensionFactory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import com.ibm.ws.st.core.internal.launch.IUtilityExecutionDelegate;
import com.ibm.ws.st.core.internal.launch.LibertyRemoteUtilityExecutionDelegate;
import com.ibm.ws.st.core.internal.launch.RemoteCreateSSLCertificate;
import com.ibm.ws.st.core.internal.launch.RemoteDumpServer;
import com.ibm.ws.st.core.internal.launch.RemoteJavaDump;
import com.ibm.ws.st.core.internal.launch.RemoteUtility;
import com.ibm.ws.st.docker.core.internal.LibertyLocalDockerUtilityExecutionDelegate;
import com.ibm.ws.st.docker.core.internal.Messages;
import com.ibm.ws.st.docker.core.internal.launch.LibertyDockerServer;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class LibertyLocalDockerUtilityLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    public static final String ATTR_SERVER_ID = "serverID";
    public static final String ATTR_COMMAND = "command";
    protected Map<String, String> serviceInfo = null;
    protected LibertyDockerServer serverExt = null;
    protected String containerName = null;
    protected String machineName = null;
    protected String osName = null;
    protected IPlatformHandler platformHandler = null;
    protected String configPath = null;
    protected Path installPath = null;
    protected AbstractDockerMachine machine = null;
    protected BaseDockerContainer container = null;
    protected IPath remoteUserDir = null;
    protected WebSphereServer wsServer;
    protected WebSphereServerBehaviour wsBehaviour;
    protected int amountOfWork = 5;
    protected Map<String, String> commandVariables = null;
    protected final long TIMEOUT = 600000L + AbstractDockerMachine.DEFAULT_TIMEOUT;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (Trace.ENABLED) {
            Trace.trace((byte)0, (String)"Launch.");
        }
        IServer server = null;
        String serverID = configuration.getAttribute(ATTR_SERVER_ID, (String)null);
        if (serverID != null) {
            server = ServerCore.findServer((String)serverID);
        }
        if (server == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, (String)"Launch configuration could not find server");
            }
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", Messages.E_DockerServerCannotBeFound));
        }
        if (monitor.isCanceled()) {
            return;
        }
        WebSphereServer websphereServer = (WebSphereServer)server.loadAdapter(WebSphereServer.class, null);
        WebSphereServerBehaviour websphereServerBehaviour = (WebSphereServerBehaviour)server.loadAdapter(WebSphereServerBehaviour.class, null);
        IRuntime runtime = server.getRuntime();
        if (runtime == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, (String)"The runtime is null");
            }
            return;
        }
        WebSphereRuntime wsRuntime = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
        if (websphereServer == null || websphereServerBehaviour == null || wsRuntime == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, (String)"Launch configuration could not find WebSphere server");
            }
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        IStatus status2 = websphereServer.validate();
        if (status2 != null && !status2.isOK()) {
            throw new CoreException(status2);
        }
        websphereServerBehaviour.setLaunch(launch);
        if (monitor.isCanceled()) {
            return;
        }
        this.commandVariables = configuration.getAttribute(ATTR_COMMAND, (Map)null);
        String utilityType = this.commandVariables.get("utilityType");
        try {
            if (utilityType != null) {
                if ("createSSLCertificate".equals(utilityType)) {
                    RemoteCreateSSLCertificate utility = new RemoteCreateSSLCertificate(this.commandVariables, (int)this.TIMEOUT, (IUtilityExecutionDelegate)new LibertyLocalDockerUtilityExecutionDelegate());
                    utility.execute(websphereServer, launch.getLaunchMode(), launch, monitor);
                } else if ("dump".equals(utilityType)) {
                    RemoteDumpServer utility = new RemoteDumpServer(this.commandVariables, (int)this.TIMEOUT, (IUtilityExecutionDelegate)new LibertyLocalDockerUtilityExecutionDelegate());
                    utility.execute(websphereServer, launch.getLaunchMode(), launch, monitor);
                } else if ("javadump".equals(utilityType)) {
                    RemoteJavaDump utility = new RemoteJavaDump(this.commandVariables, (int)this.TIMEOUT, (IUtilityExecutionDelegate)new LibertyLocalDockerUtilityExecutionDelegate());
                    utility.execute(websphereServer, launch.getLaunchMode(), launch, monitor);
                } else {
                    UtilityExtension utilityExt = UtilityExtensionFactory.getExtensionClass((String)utilityType);
                    if (utilityExt != null) {
                        RemoteUtility utility = utilityExt.getRemoteUtility(this.commandVariables, (int)this.TIMEOUT, (IUtilityExecutionDelegate)new LibertyRemoteUtilityExecutionDelegate());
                        if (utility != null) {
                            utility.execute(websphereServerBehaviour.getWebSphereServer(), mode, launch, monitor);
                        } else {
                            Trace.logError((String)("The utility extension delegate for the " + utilityType + " utility did not provide a remote handler."), null);
                        }
                    } else {
                        Trace.logError((String)("No utility extension delegate was found for the " + utilityType + " utility."), null);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.core", e.getLocalizedMessage(), (Throwable)e));
        }
    }

    public String getDockerRemoteOutputDir() throws Exception {
        JMXConnection jmx = this.wsServer.createJMXConnection();
        CompositeData metadata = (CompositeData)jmx.getMetadata("${server.output.dir}", "a");
        String remoteOutputDir = (String)metadata.get("fileName");
        remoteOutputDir = remoteOutputDir.replace("\\", "/");
        return remoteOutputDir;
    }

    class Running {
        protected boolean isDone = false;

        Running() {
        }

        public boolean getIsDone() {
            return this.isDone;
        }

        public void setDone(boolean value) {
            this.isDone = value;
        }
    }
}

